/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart.pie;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.frame.DataFrameVector;
import com.zavtech.morpheus.viz.chart.pie.PieModel;
import java.util.Collections;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.stream.IntStream;

public class PieModelDefault<X extends Comparable, S extends Comparable>
implements PieModel<X, S> {
    private DataFrame<?, S> frame;
    private IntFunction<X> itemFunction;
    private IntToDoubleFunction valueFunction;

    public final DataFrame<?, S> getFrame() {
        return this.frame;
    }

    public final IntFunction<X> getItemFunction() {
        return this.itemFunction;
    }

    public final IntToDoubleFunction getValueFunction() {
        return this.valueFunction;
    }

    private void update(DataFrame<?, S> frame, IntFunction<X> itemFunction, IntToDoubleFunction valueFunction) {
        if (frame == null) {
            this.clear(false);
        } else {
            this.frame = frame;
            this.itemFunction = itemFunction;
            this.valueFunction = valueFunction;
        }
    }

    @Override
    public Iterable<X> keys() {
        return () -> {
            if (this.isEmpty()) {
                return Collections.emptyList().iterator();
            }
            return IntStream.range(0, this.frame.rowCount()).mapToObj(this.itemFunction).iterator();
        };
    }

    @Override
    public final boolean isEmpty() {
        return this.frame == null || this.itemFunction == null;
    }

    @Override
    public void clear(boolean notify) {
        this.frame = null;
        this.itemFunction = null;
        this.valueFunction = null;
    }

    @Override
    public void apply(DataFrame<X, S> frame) {
        if (frame == null || frame.cols().stream().filter(DataFrameVector::isNumeric).count() == 0L) {
            this.clear(true);
        } else {
            frame.cols().first(DataFrameVector::isNumeric).ifPresent(column -> {
                int valueColOrdinal = column.ordinal();
                IntFunction<Comparable> itemFunction = ordinal -> (Comparable)frame.rows().key(ordinal);
                IntToDoubleFunction valueFunction = ordinal -> frame.data().getDouble(ordinal, valueColOrdinal);
                this.update(frame, itemFunction, valueFunction);
            });
        }
    }

    @Override
    public void apply(DataFrame<X, S> frame, S valueKey) {
        if (frame == null) {
            this.clear(true);
        } else {
            int valueColOrdinal = frame.cols().ordinalOf(valueKey);
            IntFunction<Comparable> itemFunction = ordinal -> (Comparable)frame.rows().key(ordinal);
            IntToDoubleFunction valueFunction = ordinal -> frame.data().getDouble(ordinal, valueColOrdinal);
            this.update(frame, itemFunction, valueFunction);
        }
    }

    @Override
    public void apply(DataFrame<?, S> frame, S itemKey, S valueKey) {
        if (frame == null) {
            this.clear(true);
        } else {
            int valueColOrdinal = frame.cols().ordinalOf(valueKey);
            int itemColOrdinal = frame.cols().ordinalOf(itemKey);
            IntFunction<Comparable> itemFunction = ordinal -> (Comparable)frame.data().getValue(ordinal, itemColOrdinal);
            IntToDoubleFunction valueFunction = ordinal -> frame.data().getDouble(ordinal, valueColOrdinal);
            this.update(frame, itemFunction, valueFunction);
        }
    }
}

