/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart.xy;

import com.zavtech.morpheus.viz.chart.ChartShape;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.chart.xy.XyStyle;
import com.zavtech.morpheus.viz.util.ColorModel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public abstract class XyPlotBase<X extends Comparable>
implements XyPlot<X> {
    private ColorModel colorModel;
    private Map<Comparable, StyleAdapter> styleMap = new HashMap<Comparable, StyleAdapter>();

    protected XyPlotBase() {
        this.colorModel = ColorModel.DEFAULT.get();
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public XyPlot<X> withColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
        return this;
    }

    @Override
    public XyStyle style(Comparable seriesKey) {
        StyleAdapter style = this.styleMap.get(seriesKey);
        if (style == null) {
            style = new StyleAdapter();
            this.styleMap.put(seriesKey, style);
        }
        return style;
    }

    public Color getSeriesColor(Comparable seriesKey) {
        StyleAdapter adapter = this.styleMap.get(seriesKey);
        return adapter != null && adapter.color != null ? adapter.color : this.colorModel.getColor(seriesKey);
    }

    public Float getSeriesLineWidth(Comparable seriesKey) {
        StyleAdapter adapter = this.styleMap.get(seriesKey);
        return adapter != null ? adapter.lineWidth : null;
    }

    public ChartShape getSeriesPointShape(Comparable seriesKey) {
        StyleAdapter adapter = this.styleMap.get(seriesKey);
        return adapter != null ? adapter.pointShape : null;
    }

    public Boolean isSeriesPointsVisible(Comparable seriesKey) {
        StyleAdapter adapter = this.styleMap.get(seriesKey);
        return adapter != null ? adapter.pointsVisible : null;
    }

    public Boolean isSeriesDashedLine(Comparable seriesKey) {
        StyleAdapter adapter = this.styleMap.get(seriesKey);
        return adapter != null ? adapter.dashes : null;
    }

    private class StyleAdapter
    implements XyStyle {
        private Color color;
        private Boolean dashes;
        private ChartShape pointShape;
        private Float lineWidth;
        private Boolean pointsVisible;

        private StyleAdapter() {
        }

        @Override
        public XyStyle withColor(Color color) {
            this.color = color;
            return this;
        }

        @Override
        public XyStyle withDashes(boolean dashed) {
            this.dashes = dashed;
            return this;
        }

        @Override
        public XyStyle withLineWidth(float lineWidth) {
            this.lineWidth = Float.valueOf(lineWidth);
            return this;
        }

        @Override
        public XyStyle withPointShape(ChartShape pointShape) {
            this.pointShape = pointShape;
            this.pointsVisible = true;
            return this;
        }

        @Override
        public XyStyle withPointsVisible(boolean pointsVisible) {
            this.pointsVisible = pointsVisible;
            return this;
        }
    }
}

