/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.chart.xy;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.frame.DataFrameLeastSquares;
import com.zavtech.morpheus.range.Range;
import com.zavtech.morpheus.util.Bounds;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import com.zavtech.morpheus.viz.chart.xy.XyTrend;
import java.util.Optional;
import java.util.function.IntFunction;

public abstract class XyTrendBase
implements XyTrend {
    private Comparable seriesKey;
    private double beta;
    private double intercept;
    private double rSquared;

    public XyTrendBase(Comparable seriesKey) {
        this.seriesKey = seriesKey;
    }

    @Override
    public Comparable seriesKey() {
        return this.seriesKey;
    }

    public double r2() {
        return this.rSquared;
    }

    public double slope() {
        return this.beta;
    }

    public double intercept() {
        return this.intercept;
    }

    public <X extends Comparable> DataFrame<Double, Comparable> createTrendData(XyDataset<X, Comparable> source, Comparable seriesKey, Comparable trendKey) {
        DataFrame<Integer, Object> seriesFrame = this.createSeriesData(source, seriesKey);
        Optional regressorRange = seriesFrame.col((Object)"Regressor").bounds();
        if (!regressorRange.isPresent()) {
            return DataFrame.empty();
        }
        double minValue = ((Number)((Bounds)regressorRange.get()).lower()).doubleValue();
        double maxValue = ((Number)((Bounds)regressorRange.get()).upper()).doubleValue();
        double step1 = (maxValue - minValue) / 20.0;
        double step2 = (maxValue - minValue) / 10.0;
        Array values = Range.of((double)(minValue - step1), (double)(maxValue + step1 * 2.0), (double)step2).toArray();
        return DataFrame.of((Iterable)values, Comparable.class, columns -> seriesFrame.regress().ols((Object)seriesKey, (Object)"Regressor", true, slr -> {
            this.beta = slr.getBetaValue((Object)"Regressor", DataFrameLeastSquares.Field.PARAMETER);
            this.intercept = slr.getInterceptValue(DataFrameLeastSquares.Field.PARAMETER);
            this.rSquared = slr.getRSquared();
            columns.add((Object)trendKey, Double.class).applyDoubles(v -> {
                double x = (Double)v.rowKey();
                return this.beta * x + this.intercept;
            });
            return Optional.empty();
        }));
    }

    private <X extends Comparable> DataFrame<Integer, Object> createSeriesData(XyDataset<X, Comparable> dataset, Comparable seriesKey) {
        DataFrame frame = dataset.frame();
        Range rowKeys = Range.of((int)0, (int)frame.rowCount());
        int seriesIndex = frame.cols().ordinalOf((Object)seriesKey);
        IntFunction domainFunc = dataset.domainFunction();
        return DataFrame.of((Iterable)rowKeys, Object.class, columns -> {
            columns.add((Object)"Regressor", Double.class).applyDoubles(v -> ((Number)domainFunc.apply(v.rowOrdinal())).doubleValue());
            columns.add((Object)seriesKey, Double.class).applyDoubles(v -> frame.data().getDouble(v.rowOrdinal(), seriesIndex));
        });
    }
}

