/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.range.Range;
import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartLabel;
import com.zavtech.morpheus.viz.chart.ChartLegend;
import com.zavtech.morpheus.viz.chart.ChartOptions;
import com.zavtech.morpheus.viz.chart.ChartTheme;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.google.GChartLabel;
import com.zavtech.morpheus.viz.google.GChartTextStyle;
import com.zavtech.morpheus.viz.google.GPieModel;
import com.zavtech.morpheus.viz.google.GPiePlot;
import com.zavtech.morpheus.viz.google.GXyDataset;
import com.zavtech.morpheus.viz.google.GXyModel;
import com.zavtech.morpheus.viz.google.GXyPlot;
import com.zavtech.morpheus.viz.google.GXyRender;
import com.zavtech.morpheus.viz.html.HtmlCode;
import com.zavtech.morpheus.viz.js.JsCode;
import com.zavtech.morpheus.viz.js.JsObject;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Font;
import java.io.File;
import java.io.OutputStream;
import java.time.LocalDate;
import java.util.UUID;
import java.util.stream.Stream;

class GChart<P>
implements Chart<P> {
    private P plot;
    private ChartOptions options = new ChartOptions.Default();
    private LegendAdapter legend = new LegendAdapter();
    private GChartLabel title = new GChartLabel(Color.BLACK, new Font("Arial", 1, 16));
    private GChartLabel subtitle = new GChartLabel(Color.BLACK, new Font("Arial", 1, 14));

    GChart(P plot) {
        this.plot = plot;
    }

    @Override
    public P plot() {
        return this.plot;
    }

    @Override
    public ChartLabel title() {
        return this.title;
    }

    @Override
    public ChartLabel subtitle() {
        return this.subtitle;
    }

    @Override
    public ChartTheme theme() {
        return null;
    }

    @Override
    public ChartOptions options() {
        return this.options;
    }

    @Override
    public ChartLegend legend() {
        return this.legend;
    }

    @Override
    public Chart show() {
        return this.show(1024, 768);
    }

    @Override
    public Chart show(int width, int height) {
        try {
            String divName = "chart1";
            String functionName = "drawChart1";
            HtmlCode writer = new HtmlCode();
            writer.newElement("html", html -> {
                html.newElement("head", head -> {
                    head.newElement("script", script -> {
                        script.newAttribute("type", "text/javascript");
                        script.newAttribute("src", "https://www.gstatic.com/charts/loader.js");
                    });
                    head.newElement("script", script -> {
                        script.newAttribute("type", "text/javascript");
                        script.text(JsCode.create(js -> {
                            js.newLine().write("google.charts.load('current', {'packages':['corechart']});", new Object[0]);
                            js.newLine().write("google.charts.setOnLoadCallback(%s);", "drawChart1");
                            this.accept((JsCode)js, "drawChart1", "chart1");
                        }));
                    });
                });
                html.newElement("body", body -> body.newElement("div", div -> {
                    div.newAttribute("id", "chart1");
                    div.newAttribute("style", "width:100%;height:100%;");
                }));
            });
            File dir = new File(System.getProperty("user.home"), ".morpheus/charts");
            File file = new File(dir, UUID.randomUUID().toString() + ".html");
            if (file.getParentFile().mkdirs()) {
                System.out.println("Created directory: " + dir.getAbsolutePath());
            }
            System.out.println(writer.toString());
            writer.flush(file);
            Desktop.getDesktop().browse(file.toURI());
            return this;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to generate Google chart", ex);
        }
    }

    @Override
    public Chart writerPng(File file, int width, int height, boolean transparent) {
        return this;
    }

    @Override
    public Chart writerPng(OutputStream os, int width, int height, boolean transparent) {
        return this;
    }

    @Override
    public void accept(JsCode jsCode, String functionName, String divId) {
        jsCode.write("/** This is code generation by the Morpheus Visualization library */", new Object[0]);
        jsCode.newFunction(functionName, func -> {
            if (this.plot() instanceof GXyPlot) {
                GXyModel model = (GXyModel)((GXyPlot)this.plot).data();
                GXyDataset dataset = model.getUnifiedDataset();
                func.write("var data = google.visualization.arrayToDataTable(", new Object[0]);
                dataset.accept((JsCode)func);
                func.write(");", new Object[0]);
            } else if (this.plot instanceof GPiePlot) {
                GPiePlot plot = (GPiePlot)this.plot();
                GPieModel model = (GPieModel)plot.data();
                func.write("var data = google.visualization.arrayToDataTable(", new Object[0]);
                model.accept((JsCode)func);
                func.write(");", new Object[0]);
            }
            func.newLine(2);
            func.write("var options = ", new Object[0]);
            func.newObject(options -> {
                options.setIgnoreNulls(true);
                options.newAttribute((Object)"fontSize", "automatic");
                options.newAttribute((Object)"fontName", "Arial");
                options.newAttribute((Object)"title", this.createTitle());
                options.newAttribute((Object)"titlePosition", "out");
                options.newObject("titleTextStyle", this.title);
                options.newObject("backgroundColor", background -> background.newAttribute((Object)"strokeWidth", 0));
                options.newObject("chartArea", area -> {
                    area.newAttribute((Object)"left", "auto");
                    area.newAttribute((Object)"top", "auto");
                    area.newAttribute((Object)"width", "80%");
                    area.newAttribute((Object)"height", "auto");
                });
                if (this.legend.enabled) {
                    options.newObject("legend", legend -> {
                        legend.newAttribute((Object)"position", this.legend.position);
                        legend.newAttribute((Object)"alignment", this.legend.alignment);
                        legend.newObject("textStyle", this.legend.style);
                    });
                }
                if (this.plot instanceof GXyPlot) {
                    ((GXyPlot)this.plot).accept((JsObject)options);
                    options.newObject("explorer", explorer -> {
                        explorer.newAttribute((Object)"keepInBounds", true);
                        explorer.newArray("actions", true, a -> {
                            a.append("dragToZoom");
                            a.append("rightClickToReset");
                        });
                    });
                } else if (this.plot instanceof GPiePlot) {
                    ((GPiePlot)this.plot).accept((JsObject)options);
                }
            });
            func.write(";", new Object[0]);
            func.newLine();
            func.newLine().write("var target = document.getElementById('%s');", divId);
            func.newLine().write("var chart = new google.visualization.%s(target);", this.getChartType());
            func.newLine().write("chart.draw(data, options);", new Object[0]);
        });
    }

    private String createTitle() {
        StringBuilder result = new StringBuilder();
        if (this.title.getText() != null) {
            result.append(this.title.getText());
        }
        if (this.subtitle.getText() != null) {
            boolean brackets = result.length() > 0;
            result.append(brackets ? " - (" : "");
            result.append(this.subtitle.getText());
            result.append(brackets ? ")" : "");
        }
        return result.toString();
    }

    private String getChartType() {
        if (this.plot instanceof PiePlot) {
            return "PieChart";
        }
        if (this.plot instanceof GXyPlot) {
            GXyPlot gxyPlot = (GXyPlot)this.plot;
            GXyRender render = (GXyRender)gxyPlot.render(0);
            boolean vertical = gxyPlot.isVertical();
            switch (render.getChartType()) {
                case LINES: {
                    return "LineChart";
                }
                case BARS: {
                    return vertical ? "ColumnChart" : "BarChart";
                }
                case AREA: {
                    return "AreaChart";
                }
                case SHAPES: {
                    return "ScatterChart";
                }
                case DOTS: {
                    return "ScatterChart";
                }
            }
            throw new IllegalStateException("Unsupported chart type: " + (Object)((Object)render.getChartType()));
        }
        throw new IllegalArgumentException("Unsupported plot type specified: " + this.plot.getClass());
    }

    public static void main(String[] args) {
        int rowCount = 1000;
        LocalDate startDate = LocalDate.of(2013, 1, 1);
        Range rowKeys = Range.of((int)0, (int)rowCount);
        Range dates = rowKeys.map(startDate::plusDays);
        DataFrame frame = DataFrame.of((Iterable)rowKeys, String.class, columns -> {
            columns.add((Object)"DataDate", (Iterable)dates);
            Stream.of("A", "B", "C", "D").forEach(label -> columns.add(label, (Iterable)Array.randn((int)rowCount).cumSum()));
        });
        frame.out().print();
        Chart.create().asHtml().withLinePlot(frame, "DataDate", chart -> {
            chart.legend().on().right();
            chart.title().withText("Test Chart");
            chart.title().withColor(Color.BLACK);
            ((XyPlot)chart.plot()).axes().domain().label().withText("Cities");
            ((XyPlot)chart.plot()).axes().range(0).label().withText("Population");
            chart.show();
        });
    }

    private class LegendAdapter
    implements ChartLegend {
        private boolean enabled = false;
        private String position = "right";
        private String alignment = "start";
        private GChartTextStyle style = new GChartTextStyle(Color.BLACK, new Font("Arial", 0, 10));

        private LegendAdapter() {
        }

        @Override
        public ChartLegend on() {
            this.enabled = true;
            return this;
        }

        @Override
        public ChartLegend off() {
            this.enabled = false;
            return this;
        }

        @Override
        public ChartLegend right() {
            this.position = "right";
            return this;
        }

        @Override
        public ChartLegend left() {
            this.position = "left";
            return this;
        }

        @Override
        public ChartLegend top() {
            this.position = "top";
            return this;
        }

        @Override
        public ChartLegend bottom() {
            this.position = "bottom";
            return this;
        }
    }
}

