/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.util.Collect;
import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartFactory;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.google.GChart;
import com.zavtech.morpheus.viz.google.GPiePlot;
import com.zavtech.morpheus.viz.google.GXyPlot;
import com.zavtech.morpheus.viz.html.HtmlCode;
import com.zavtech.morpheus.viz.js.JsCode;
import java.awt.Desktop;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class GChartFactory
implements ChartFactory {
    @Override
    public boolean isSupported(Chart<?> chart) {
        return chart instanceof GChart;
    }

    @Override
    public String javascript(Iterable<Chart<?>> charts) {
        return this.javascript((Chart[])Collect.asStream(charts).toArray(Chart[]::new));
    }

    public String javascript(Chart ... charts) {
        return JsCode.create(jsCode -> {
            jsCode.newLine().write("google.charts.load('current', {'packages':['corechart']});", new Object[0]);
            jsCode.newLine().write("google.charts.setOnLoadCallback(%s);", "drawCharts");
            jsCode.newLine();
            jsCode.newFunction("drawCharts", init -> {
                for (int i = 0; i < charts.length; ++i) {
                    init.write("drawChart_%s()", i);
                    init.newLine();
                }
            });
            for (int i = 0; i < charts.length; ++i) {
                Chart chart = charts[i];
                String functionName = String.format("drawChart_%s", i);
                String divId = chart.options().getId().orElse(String.format("chart_%s", i));
                jsCode.newLine().newLine();
                chart.accept((JsCode)jsCode, functionName, divId);
            }
        });
    }

    @Override
    public void show(int columns, Stream<Chart<?>> charts) {
        this.show(columns, Collect.asIterable(charts));
    }

    @Override
    public void show(int columns, Iterable<Chart<?>> charts) {
        try {
            HtmlCode htmlCode = new HtmlCode();
            AtomicInteger chartIndex = new AtomicInteger(-1);
            htmlCode.newElement("html", html -> {
                html.newElement("head", head -> {
                    head.newElement("script", script -> {
                        script.newAttribute("type", "text/javascript");
                        script.newAttribute("src", "https://www.gstatic.com/charts/loader.js");
                    });
                    head.newElement("script", script -> {
                        script.newAttribute("type", "text/javascript");
                        script.text(this.javascript(charts));
                    });
                });
                String width = String.valueOf((int)(100.0 / (double)columns)) + "%";
                String height = String.valueOf((int)(100.0 / (double)columns * 0.9)) + "%";
                html.newElement("body", body -> {
                    chartIndex.set(-1);
                    charts.forEach(chart -> body.newElement("div", div -> {
                        div.newAttribute("id", String.format("chart_%s", chartIndex.incrementAndGet()));
                        div.newAttribute("style", String.format("width:%s;height:%s;float:left;", width, height));
                    }));
                });
            });
            File dir = new File(System.getProperty("user.home"), ".morpheus/charts");
            File file = new File(dir, UUID.randomUUID().toString() + ".html");
            if (file.getParentFile().mkdirs()) {
                System.out.println("Created directory: " + dir.getAbsolutePath());
            }
            System.out.println(htmlCode.toString());
            htmlCode.flush(file);
            Desktop.getDesktop().browse(file.toURI());
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to generate Google chart", ex);
        }
    }

    @Override
    public <X extends Comparable> Chart<XyPlot<X>> ofXY(Class<X> domainType, Consumer<Chart<XyPlot<X>>> configurator) {
        GChart<XyPlot<X>> chart = new GChart<XyPlot<X>>(new GXyPlot());
        if (configurator != null) {
            configurator.accept(chart);
        }
        return chart;
    }

    @Override
    public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> ofPiePlot(boolean is3d, Consumer<Chart<PiePlot<X, S>>> configurator) {
        GChart<PiePlot<X, S>> chart = new GChart<PiePlot<X, S>>(new GPiePlot(is3d));
        if (configurator != null) {
            configurator.accept(chart);
        }
        return chart;
    }
}

