/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.viz.chart.ChartFormat;
import com.zavtech.morpheus.viz.google.GDataType;
import com.zavtech.morpheus.viz.google.GXyDataset;

class GChartFormat
implements ChartFormat {
    private boolean domain;
    private String pattern;

    GChartFormat(boolean domain) {
        this.domain = domain;
    }

    @Override
    public void withPattern(String pattern) {
        this.pattern = pattern;
    }

    String getPattern(GXyDataset dataset) {
        if (this.pattern != null) {
            return this.pattern;
        }
        if (dataset == null) {
            return "auto";
        }
        Class typeClass = this.domain ? dataset.domainType() : Number.class;
        GDataType type = GDataType.getDataType(typeClass, GDataType.STRING);
        switch (type) {
            case BOOLEAN: {
                return "auto";
            }
            case STRING: {
                return "auto";
            }
            case NUMBER: {
                return "decimal";
            }
            case DATE: {
                return "dd-MMM-yyyy";
            }
            case DATETIME: {
                return "dd-MMM-yyyy HH:mm";
            }
            case LOCAL_TIME: {
                return "HH:mm";
            }
        }
        throw new IllegalStateException("Unsupported type specified: " + (Object)((Object)type));
    }
}

