/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.viz.chart.ChartLabel;
import com.zavtech.morpheus.viz.js.JsObject;
import com.zavtech.morpheus.viz.util.ColorModel;
import java.awt.Color;
import java.awt.Font;
import java.util.function.Consumer;

class GChartLabel
implements ChartLabel,
Consumer<JsObject> {
    private Font font;
    private Color color;
    private String text;

    GChartLabel() {
        this(Color.BLACK, new Font("Arial", 0, 12));
    }

    GChartLabel(Color color, Font font) {
        this.color = color;
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    Color getColor() {
        return this.color;
    }

    String getText() {
        return this.text;
    }

    boolean isBold() {
        return this.font != null && this.font.isBold();
    }

    boolean isItalic() {
        return this.font != null && this.font.isItalic();
    }

    String getColorHex() {
        return ColorModel.toHexString(this.color);
    }

    @Override
    public ChartLabel withText(String text) {
        this.text = text;
        return this;
    }

    @Override
    public ChartLabel withColor(Color color) {
        this.color = color;
        return this;
    }

    @Override
    public ChartLabel withFont(Font font) {
        this.font = font;
        return this;
    }

    @Override
    public void accept(JsObject label) {
        label.newAttribute((Object)"color", this.getColorHex());
        label.newAttribute((Object)"fontName", this.getFont().getName());
        label.newAttribute((Object)"fontSize", this.getFont().getSize());
        label.newAttribute((Object)"bold", this.getFont().isBold());
        label.newAttribute((Object)"italic", this.getFont().isItalic());
    }
}

