/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

enum GDataType {
    BOOLEAN("boolean"),
    STRING("string"),
    NUMBER("number"),
    DATE("date"),
    DATETIME("datetime"),
    LOCAL_TIME("timeofday");

    private static final Map<Class, GDataType> typeMap;
    private String label;

    private GDataType(String label) {
        this.label = label;
    }

    public static GDataType getDataType(Class<?> type, GDataType defaultType) {
        return typeMap.getOrDefault(type, defaultType);
    }

    public String getLabel() {
        return this.label;
    }

    static {
        typeMap = new HashMap<Class, GDataType>();
        typeMap.put(String.class, STRING);
        typeMap.put(Boolean.class, BOOLEAN);
        typeMap.put(String.class, STRING);
        typeMap.put(Number.class, NUMBER);
        typeMap.put(Double.class, NUMBER);
        typeMap.put(Integer.class, NUMBER);
        typeMap.put(Float.class, NUMBER);
        typeMap.put(Long.class, NUMBER);
        typeMap.put(Date.class, DATETIME);
        typeMap.put(LocalDate.class, DATE);
        typeMap.put(LocalDateTime.class, DATETIME);
        typeMap.put(ZonedDateTime.class, DATETIME);
        typeMap.put(LocalTime.class, LOCAL_TIME);
    }
}

