/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.viz.chart.pie.PieLabels;
import com.zavtech.morpheus.viz.chart.pie.PieModel;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.pie.PieSection;
import com.zavtech.morpheus.viz.google.GPieModel;
import com.zavtech.morpheus.viz.js.JsObject;
import com.zavtech.morpheus.viz.util.ColorModel;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import java.util.function.IntFunction;

class GPiePlot<X extends Comparable, S extends Comparable>
implements PiePlot<X, S> {
    private boolean is3d;
    private double pieHole = 0.0;
    private double startAngle = 0.0;
    private GPieLabels labels = new GPieLabels();
    private GPieModel<X, S> model = new GPieModel();
    private ColorModel colorModel = ColorModel.DEFAULT.get();
    private Color sectionOutlineColor = Color.WHITE;
    private Map<X, GPieSection> sectionMap = new HashMap<X, GPieSection>();

    GPiePlot(boolean is3d) {
        this.is3d = is3d;
    }

    @Override
    public PieModel<X, S> data() {
        return this.model;
    }

    @Override
    public PieLabels labels() {
        return this.labels;
    }

    @Override
    public PieSection section(X itemKey) {
        GPieSection section = this.sectionMap.get(itemKey);
        if (section == null) {
            section = new GPieSection();
            this.sectionMap.put(itemKey, section);
        }
        return section;
    }

    @Override
    public PiePlot<X, S> withStartAngle(double degrees) {
        this.startAngle = degrees;
        return this;
    }

    @Override
    public PiePlot<X, S> withPieHole(double percent) {
        this.pieHole = percent;
        return this;
    }

    @Override
    public PiePlot<X, S> withSectionOutlineColor(Color color) {
        this.sectionOutlineColor = color;
        return this;
    }

    public void accept(JsObject options) {
        options.newAttribute((Object)"is3D", this.is3d);
        options.newAttribute((Object)"pieHole", this.pieHole);
        options.newAttribute((Object)"pieStartAngle", this.startAngle);
        options.newAttribute((Object)"pieSliceText", this.labels.labelType != null ? this.labels.labelType.value : "none");
        options.newAttribute((Object)"pieSliceBorderColor", ColorModel.toHexString(this.sectionOutlineColor));
        options.newObject("pieSliceTextStyle", textStyle -> {
            textStyle.newAttribute((Object)"color", ColorModel.toHexString(this.labels.color));
            textStyle.newAttribute((Object)"fontName", this.labels.font.getName());
            textStyle.newAttribute((Object)"fontSize", this.labels.font.getSize());
        });
        if (!this.model.isEmpty()) {
            IntFunction itemFunction = this.model.getItemFunction();
            options.newArray("slices", slices -> this.model.getFrame().rows().forEach(row -> {
                Comparable item = (Comparable)itemFunction.apply(row.ordinal());
                GPieSection section = (GPieSection)this.section(item);
                Color color = section.color != null ? section.color : this.colorModel.getColor(item);
                slices.appendObject(slice -> {
                    slice.newAttribute((Object)"color", ColorModel.toHexString(color));
                    slice.newAttribute((Object)"offset", section.offset);
                });
            }));
        }
    }

    private class GPieLabels
    implements PieLabels {
        private LabelType labelType = LabelType.PERCENT;
        private Color color = Color.WHITE;
        private Font font = new Font("Arial", 0, 12);

        private GPieLabels() {
        }

        @Override
        public PieLabels off() {
            this.labelType = null;
            return this;
        }

        @Override
        public PieLabels on() {
            this.labelType = this.labelType != null ? this.labelType : LabelType.PERCENT;
            return this;
        }

        @Override
        public PieLabels withName() {
            this.labelType = LabelType.NAME;
            return this;
        }

        @Override
        public PieLabels withValue() {
            this.labelType = LabelType.VALUE;
            return this;
        }

        @Override
        public PieLabels withPercent() {
            this.labelType = LabelType.PERCENT;
            return this;
        }

        @Override
        public PieLabels withFont(Font font) {
            this.font = font;
            return this;
        }

        @Override
        public PieLabels withTextColor(Color color) {
            this.color = color;
            return this;
        }

        @Override
        public PieLabels withBackgroundColor(Color color) {
            return this;
        }
    }

    private static enum LabelType {
        NAME("label"),
        VALUE("value"),
        PERCENT("percentage");

        private String value;

        private LabelType(String value) {
            this.value = value;
        }
    }

    private class GPieSection
    implements PieSection {
        private Color color;
        private double offset = 0.0;

        private GPieSection() {
        }

        @Override
        public PieSection withColor(Color color) {
            this.color = color;
            return this;
        }

        @Override
        public PieSection withOffset(double offset) {
            this.offset = offset;
            return this;
        }
    }
}

