/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.util.Bounds;
import com.zavtech.morpheus.viz.chart.ChartFormat;
import com.zavtech.morpheus.viz.chart.ChartLabel;
import com.zavtech.morpheus.viz.chart.ChartTextStyle;
import com.zavtech.morpheus.viz.chart.xy.XyAxis;
import com.zavtech.morpheus.viz.google.GChartFormat;
import com.zavtech.morpheus.viz.google.GChartLabel;
import com.zavtech.morpheus.viz.google.GChartTextStyle;
import com.zavtech.morpheus.viz.google.GXyDataset;
import com.zavtech.morpheus.viz.js.JsObject;
import java.awt.Color;
import java.awt.Font;

class GXyAxis
implements XyAxis {
    private GChartLabel label;
    private GChartFormat format;
    private GChartTextStyle ticks;
    private boolean log = false;

    GXyAxis(boolean domain) {
        this.format = new GChartFormat(domain);
        this.label = new GChartLabel(Color.BLACK, new Font("Arial", 0, 12));
        this.ticks = new GChartTextStyle(Color.BLACK, new Font("Arial", 0, 12));
    }

    @Override
    public ChartLabel label() {
        return this.label;
    }

    @Override
    public ChartFormat format() {
        return this.format;
    }

    @Override
    public ChartTextStyle ticks() {
        return this.ticks;
    }

    @Override
    public XyAxis asLogScale() {
        this.log = true;
        return this;
    }

    @Override
    public XyAxis asLinearScale() {
        this.log = false;
        return this;
    }

    @Override
    public XyAxis asDateScale() {
        this.log = false;
        this.format.withPattern("dd-MMM-yyyy");
        return this;
    }

    @Override
    public XyAxis withRange(Bounds<?> range) {
        return this;
    }

    public void accept(JsObject axis, GXyDataset dataset) {
        axis.setIgnoreNulls(true);
        axis.newAttribute((Object)"baselineColor", this.ticks.label().getColorHex());
        axis.newAttribute((Object)"scaleType", this.log ? "log" : null);
        axis.newAttribute((Object)"textPosition", "out");
        axis.newAttribute((Object)"title", this.label.getText());
        axis.newAttribute((Object)"viewWindowMode", "maximized");
        axis.newAttribute((Object)"format", this.format.getPattern(dataset));
        axis.newObject("titleTextStyle", this.label);
        axis.newObject("textStyle", this.ticks);
        axis.newAttribute((Object)"gridLines", "");
    }
}

