/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.range.Range;
import com.zavtech.morpheus.util.IO;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import com.zavtech.morpheus.viz.google.GDataType;
import com.zavtech.morpheus.viz.js.JsCode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;

class GXyDataset<X extends Comparable, S extends Comparable>
implements XyDataset<X, S> {
    private DataFrame<?, S> frame;
    private Array<Integer> colOrdinals;
    private Supplier<Class<X>> domainType;
    private IntFunction<X> domainValueFunction;
    private Consumer<GXyDataset<X, S>> refreshHandler;

    private GXyDataset(Consumer<GXyDataset<X, S>> refreshHandler) {
        this.refreshHandler = refreshHandler;
        this.refresh();
    }

    static <X extends Comparable, S extends Comparable> GXyDataset<X, S> of(Supplier<DataFrame<X, S>> frameSupplier) {
        return new GXyDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).toArray());
                    Supplier domainType = () -> frame.rows().keyType();
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.rows().key(rowIndex));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    static <X extends Comparable, S extends Comparable> GXyDataset<X, S> of(S domainAxisKey, Supplier<DataFrame<?, S>> frameSupplier) {
        return new GXyDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    int domainAxisColOrdinal = frame.cols().ordinalOf((Object)domainAxisKey);
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).filter(i -> i != domainAxisColOrdinal).toArray());
                    Supplier domainType = () -> frame.cols().type((Object)domainAxisKey);
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.data().getValue(rowIndex, domainAxisColOrdinal));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    private void update(DataFrame<?, S> frame, Array<Integer> colOrdinals, Supplier<Class<X>> domainType, IntFunction<X> domainValueFunction) {
        this.frame = frame;
        this.colOrdinals = colOrdinals;
        this.domainType = domainType;
        this.domainValueFunction = domainValueFunction;
    }

    @Override
    public void refresh() {
        this.refreshHandler.accept(this);
    }

    @Override
    public boolean isEmpty() {
        return this.frame == null || this.frame.rowCount() == 0;
    }

    @Override
    public void clear(boolean notify) {
        this.frame = null;
        this.colOrdinals = null;
        this.domainValueFunction = null;
    }

    @Override
    public <R> DataFrame<R, S> frame() {
        return this.frame;
    }

    @Override
    public Class<X> domainType() {
        return this.isEmpty() ? null : this.domainType.get();
    }

    @Override
    public boolean contains(S seriesKey) {
        return !this.isEmpty() && this.frame.cols().contains(seriesKey);
    }

    @Override
    public IntFunction<X> domainFunction() {
        return this.domainValueFunction;
    }

    @Override
    public XyDataset<X, S> withLowerDomainInterval(Function<X, X> lowerIntervalFunction) {
        return null;
    }

    @Override
    public XyDataset<X, S> withUpperDomainInterval(Function<X, X> upperIntervalFunction) {
        return null;
    }

    Class<X> getDomainKeyType() {
        if (this.isEmpty()) {
            return Double.class;
        }
        for (int i = 0; i < this.frame.rowCount(); ++i) {
            Comparable value = (Comparable)this.domainValueFunction.apply(i);
            if (value == null) continue;
            return value.getClass();
        }
        return Double.class;
    }

    public Iterable<X> getDomainValues() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return Range.of((int)0, (int)this.frame.rowCount()).map(this.domainValueFunction::apply);
    }

    public Iterable<S> getSeriesKeys() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        return this.colOrdinals.map(v -> (Comparable)this.frame.cols().key(v.getInt()));
    }

    public int getSeriesCount() {
        return this.isEmpty() ? 0 : this.colOrdinals.length();
    }

    public S getSeriesKey(int series) {
        return (S)(this.isEmpty() ? null : (Comparable)this.frame.cols().key(this.colOrdinals.getInt(series)));
    }

    public int getDomainSize() {
        return this.isEmpty() ? 0 : this.frame.rowCount();
    }

    public X getDomainValue(int item) {
        return (X)(this.isEmpty() ? null : (Comparable)this.domainValueFunction.apply(item));
    }

    public double getRangeValue(int item, int series) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        int colOrdinal = this.colOrdinals.getInt(series);
        return this.frame.data().getDouble(item, colOrdinal);
    }

    public void accept(JsCode script) {
        Class<X> domainClass = this.domainType();
        GDataType domainType = GDataType.getDataType(domainClass, GDataType.STRING);
        script.newArray(array -> {
            array.appendArray(false, header -> {
                header.appendObject(true, domain -> {
                    domain.newAttribute((Object)"id", "domain");
                    domain.newAttribute((Object)"label", "Domain");
                    domain.newAttribute((Object)"type", domainType.getLabel());
                });
                for (int i = 0; i < this.getSeriesCount(); ++i) {
                    Object seriesKey = this.getSeriesKey(i);
                    header.appendObject(true, series -> {
                        series.newAttribute((Object)"id", seriesKey.toString());
                        series.newAttribute((Object)"label", seriesKey.toString());
                        series.newAttribute((Object)"type", "number");
                    });
                }
            });
            Function<Object, String> domainValueFunc = this.createDomainFunction(domainClass);
            for (int i = 0; i < this.getDomainSize(); ++i) {
                int index = i;
                X domainValue = this.getDomainValue(i);
                String stringValue = domainValueFunc.apply(domainValue);
                array.appendArray(true, series -> {
                    series.append(stringValue, false);
                    for (int j = 0; j < this.getSeriesCount(); ++j) {
                        double value = this.getRangeValue(index, j);
                        if (Double.isNaN(value)) {
                            series.append(null);
                            continue;
                        }
                        series.append(value);
                    }
                });
            }
        });
    }

    private Function<Object, String> createDomainFunction(Class<?> dataType) {
        if (Number.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : String.valueOf(value);
        }
        if (Date.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : "new Date(" + ((Date)value).getTime() + ")";
        }
        if (LocalDate.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : "new Date(" + ((LocalDate)value).toEpochDay() * 86400L * 1000L + ")";
        }
        if (LocalDateTime.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : "new Date(" + ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli() + ")";
        }
        if (ZonedDateTime.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : "new Date(" + ((ZonedDateTime)value).toInstant().toEpochMilli() + ")";
        }
        if (Calendar.class.isAssignableFrom(dataType)) {
            return value -> value == null ? "null" : "new Date(" + ((Calendar)value).getTimeInMillis() + ")";
        }
        return value -> value == null ? "null" : "'" + value.toString() + "'";
    }

    public static void main(String[] args) {
        Range rowAxis = Range.ofLocalDates((String)"2017-01-01", (String)"2017-06-01");
        Array colAxis = Array.of((Object[])new String[]{"A", "B", "C", "D"});
        DataFrame frame = DataFrame.ofDoubles((Iterable)rowAxis, (Iterable)colAxis, v -> Math.random());
        GXyDataset dataset = GXyDataset.of(() -> frame);
        JsCode js = new JsCode();
        dataset.accept(js);
        IO.println((Object)js.toString());
    }
}

