/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.index.Index;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import com.zavtech.morpheus.viz.chart.xy.XyModel;
import com.zavtech.morpheus.viz.google.GXyDataset;
import com.zavtech.morpheus.viz.google.GXyPlot;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;

class GXyModel<X extends Comparable, S extends Comparable>
implements XyModel<X, S> {
    private GXyPlot<X> plot;
    private GXyDataset<X, S> unified;
    private Map<Integer, Integer> rangeAxisMap = new HashMap<Integer, Integer>();
    private Map<Integer, GXyDataset<X, S>> datasetMap = new HashMap<Integer, GXyDataset<X, S>>();

    GXyModel(GXyPlot<X> plot) {
        this.plot = plot;
    }

    private void reset() {
        this.unified = null;
    }

    int getDatasetIndex(S seriesKey) {
        OptionalInt maxIndex = this.datasetMap.keySet().stream().mapToInt(x -> x).max();
        if (!maxIndex.isPresent()) {
            throw new IllegalStateException("No datasets configure for chart model");
        }
        for (int index = 0; index < 100; ++index) {
            GXyDataset<X, S> dataset = this.datasetMap.get(index);
            if (dataset == null || dataset.isEmpty() || !dataset.frame().cols().contains(seriesKey)) continue;
            return index;
        }
        throw new IllegalArgumentException("Unable to match series in chart data model: " + seriesKey);
    }

    int getRangeAxisIndex(S seriesKey) {
        OptionalInt maxIndex = this.datasetMap.keySet().stream().mapToInt(x -> x).max();
        if (!maxIndex.isPresent()) {
            return 0;
        }
        for (int datasetIndex = 0; datasetIndex <= maxIndex.getAsInt(); ++datasetIndex) {
            GXyDataset<X, S> dataset = this.datasetMap.get(datasetIndex);
            if (dataset == null || !dataset.contains(seriesKey)) continue;
            return this.rangeAxisMap.getOrDefault(datasetIndex, 0);
        }
        return 0;
    }

    GXyDataset<X, S> getUnifiedDataset() {
        if (this.unified != null) {
            return this.unified;
        }
        this.unified = this.datasetMap.size() == 0 ? GXyDataset.of(() -> null) : (this.datasetMap.size() == 1 ? this.datasetMap.values().iterator().next() : this.combine(this.datasetMap.values()));
        return this.unified;
    }

    private GXyDataset<X, S> combine(Collection<GXyDataset<X, S>> datasets) {
        return GXyDataset.of(() -> {
            Set domainKeyTypeSet = datasets.stream().map(GXyDataset::getDomainKeyType).collect(Collectors.toSet());
            Set seriesKeyTypeSet = datasets.stream().map(d -> d.frame().cols().keyType()).collect(Collectors.toSet());
            if (domainKeyTypeSet.size() > 1) {
                throw new ChartException("Non-homogeneous key types for domain dimension: " + domainKeyTypeSet);
            }
            Class domainKeyType = (Class)domainKeyTypeSet.iterator().next();
            Class seriesKeyType = seriesKeyTypeSet.size() > 1 ? Comparable.class : (Class)seriesKeyTypeSet.iterator().next();
            int rowCount = datasets.stream().mapToInt(GXyDataset::getDomainSize).max().orElse(0);
            int colCount = datasets.stream().mapToInt(GXyDataset::getSeriesCount).sum();
            Index rows = Index.of((Class)domainKeyType, (int)rowCount);
            Index columns = Index.of((Class)seriesKeyType, (int)colCount);
            DataFrame frame = DataFrame.ofDoubles((Iterable)rows, (Iterable)columns);
            datasets.forEach(dataset -> {
                Iterable domainKeys = dataset.getDomainValues();
                frame.rows().addAll(domainKeys);
                for (int j = 0; j < dataset.getSeriesCount(); ++j) {
                    Object seriesKey = dataset.getSeriesKey(j);
                    int colOrdinal = frame.cols().add(seriesKey, Double.class).ordinal();
                    for (int i = 0; i < dataset.getDomainSize(); ++i) {
                        Object domainKey = dataset.getDomainValue(i);
                        double value = dataset.getRangeValue(i, j);
                        frame.data().setDouble(domainKey, colOrdinal, value);
                    }
                }
            });
            return frame.rows().sort(true);
        });
    }

    @Override
    public void setRangeAxis(int dataset, int axis) {
        this.rangeAxisMap.put(dataset, axis);
        this.plot.axes().range(axis);
    }

    @Override
    public Class<X> domainType() {
        if (this.datasetMap.isEmpty()) {
            return null;
        }
        return this.datasetMap.entrySet().iterator().next().getValue().domainType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XyDataset<X, S> at(int index) {
        try {
            XyDataset dataset = this.datasetMap.get(index);
            if (dataset == null) {
                throw new ChartException("No dataset exists for index: 0");
            }
            XyDataset xyDataset = dataset;
            return xyDataset;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(DataFrame<X, S> frame) {
        try {
            int index = this.datasetMap.size();
            GXyDataset dataset = GXyDataset.of(() -> frame);
            this.datasetMap.put(index, dataset);
            int n = index;
            return n;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(DataFrame<?, S> frame, S domainKey) {
        try {
            int index = this.datasetMap.size();
            GXyDataset dataset = GXyDataset.of(domainKey, () -> frame);
            this.datasetMap.put(index, dataset);
            int n = index;
            return n;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XyDataset<X, S> update(int index, DataFrame<X, S> frame) {
        try {
            if (!this.datasetMap.containsKey(index)) {
                throw new ChartException("No dataset exist at index: " + index);
            }
            GXyDataset dataset = GXyDataset.of(() -> frame);
            this.datasetMap.put(index, dataset);
            GXyDataset gXyDataset = dataset;
            return gXyDataset;
        }
        finally {
            this.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XyDataset<X, S> update(int index, DataFrame<?, S> frame, S domainKey) {
        try {
            if (!this.datasetMap.containsKey(index)) {
                throw new ChartException("No dataset exist at index: " + index);
            }
            GXyDataset dataset = GXyDataset.of(domainKey, () -> frame);
            this.datasetMap.put(index, dataset);
            GXyDataset gXyDataset = dataset;
            return gXyDataset;
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void removeAll() {
        try {
            this.datasetMap.clear();
        }
        finally {
            this.reset();
        }
    }

    @Override
    public void remove(int index) {
        try {
            if (!this.datasetMap.containsKey(index)) {
                throw new ChartException("No dataset exists for index: " + index);
            }
            this.datasetMap.remove(index);
        }
        finally {
            this.reset();
        }
    }
}

