/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.index.Index;
import com.zavtech.morpheus.viz.chart.ChartShape;
import com.zavtech.morpheus.viz.chart.xy.XyAxes;
import com.zavtech.morpheus.viz.chart.xy.XyModel;
import com.zavtech.morpheus.viz.chart.xy.XyOrient;
import com.zavtech.morpheus.viz.chart.xy.XyPlotBase;
import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.chart.xy.XyTrend;
import com.zavtech.morpheus.viz.google.GTrendLine;
import com.zavtech.morpheus.viz.google.GXyAxes;
import com.zavtech.morpheus.viz.google.GXyAxis;
import com.zavtech.morpheus.viz.google.GXyDataset;
import com.zavtech.morpheus.viz.google.GXyModel;
import com.zavtech.morpheus.viz.google.GXyRender;
import com.zavtech.morpheus.viz.js.JsObject;
import com.zavtech.morpheus.viz.util.ColorModel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class GXyPlot<X extends Comparable>
extends XyPlotBase<X> {
    private GXyAxes axes = new GXyAxes(this);
    private GXyOrient orient = new GXyOrient();
    private GXyModel<X, Comparable> model = new GXyModel(this);
    private Map<Integer, GXyRender> renderMap = new HashMap<Integer, GXyRender>();
    private Map<Comparable, GTrendLine> trendLineMap = new HashMap<Comparable, GTrendLine>();
    private ChartShape.Provider shapeProvider = new ChartShape.DefaultProvider();

    GXyPlot() {
    }

    @Override
    public XyAxes axes() {
        return this.axes;
    }

    @Override
    public <S extends Comparable> XyModel<X, S> data() {
        return this.model;
    }

    @Override
    public XyOrient orient() {
        return this.orient;
    }

    @Override
    public <S extends Comparable> XyTrend trend(S seriesKey) {
        GTrendLine trend = this.trendLineMap.get(seriesKey);
        if (trend == null) {
            trend = new GTrendLine(seriesKey);
            this.trendLineMap.put(seriesKey, trend);
        }
        return trend;
    }

    @Override
    public XyRender render(int index) {
        GXyRender render = this.renderMap.get(index);
        if (render == null) {
            render = new GXyRender(this);
            this.renderMap.put(index, render);
        }
        return render;
    }

    private GXyRender renderAt(int index) {
        return (GXyRender)this.render(index);
    }

    public void accept(JsObject options) {
        options.setIgnoreNulls(true);
        options.newAttribute((Object)"dataOpacity", 1.0);
        options.newAttribute((Object)"axisTitlesPosition", "out");
        this.axisOptions(options);
        this.seriesOptions(options);
        this.trendLineOptions(options);
        if (this.renderAt(0).isBars()) {
            options.newAttribute((Object)"isStacked", this.renderAt(0).isStacked());
            options.newObject("bar", bar -> bar.newAttribute((Object)"groupWidth", "70%"));
        } else if (this.renderAt(0).isArea()) {
            options.newAttribute((Object)"isStacked", this.renderAt(0).isStacked());
        } else if (this.renderAt(0).isLines()) {
            options.newAttribute((Object)"lineWidth", 1);
            options.newAttribute((Object)"curveType", this.renderAt(0).getCurveType());
        }
        if (!this.renderAt(0).isBars()) {
            options.newAttribute((Object)"orientation", this.isVertical() ? "vertical" : "horizontal");
        }
    }

    private void axisOptions(JsObject options) {
        String domain = this.renderAt(0).isBars() && this.isHorizontal() ? "vAxis" : "hAxis";
        String range1 = this.renderAt(0).isBars() && this.isHorizontal() ? "hAxis" : "vAxis";
        String range2 = this.renderAt(0).isBars() && this.isHorizontal() ? "hAxes" : "vAxes";
        options.newObject(domain, axis -> {
            GXyDataset<X, Comparable> dataset = this.model.getUnifiedDataset();
            GXyAxis domainAxis = (GXyAxis)this.axes().domain();
            domainAxis.accept((JsObject)axis, dataset);
        });
        if (this.axes.rangeAxisCount() == 1) {
            options.newObject(range1, axis -> {
                GXyDataset<X, Comparable> dataset = this.model.getUnifiedDataset();
                GXyAxis rangeAxis = (GXyAxis)this.axes.range(0);
                rangeAxis.accept((JsObject)axis, dataset);
            });
        } else {
            options.newObject(range2, vAxes -> {
                for (int i = 0; i < this.axes.rangeAxisCount(); ++i) {
                    GXyDataset dataset = this.model.getUnifiedDataset();
                    GXyAxis rangeAxis = (GXyAxis)this.axes.range(i);
                    vAxes.newObject(i, axis -> rangeAxis.accept((JsObject)axis, dataset));
                }
            });
        }
    }

    private void seriesOptions(JsObject options) {
        options.newObject("series", seriesList -> {
            GXyDataset<X, Comparable> dataset = this.model.getUnifiedDataset();
            for (int i = 0; i < dataset.getSeriesCount(); ++i) {
                Comparable seriesKey = dataset.getSeriesKey(i);
                int axisIndex = this.model.getRangeAxisIndex(seriesKey);
                int datasetIndex = this.model.getDatasetIndex(seriesKey);
                GXyRender render = this.renderAt(datasetIndex);
                Color color = render.getSeriesColor(seriesKey);
                Optional<Float> lineWidth = render.getSeriesLineWidth(seriesKey);
                Optional<ChartShape> shape = render.getSeriesPointShape(seriesKey);
                seriesList.newObject(i, series -> {
                    series.setIgnoreNulls(true);
                    series.newAttribute((Object)"targetAxisIndex", axisIndex);
                    series.newAttribute((Object)"visibleInLegend", true);
                    series.newAttribute((Object)"color", ColorModel.toHexString(color));
                    if (render.hasShapesOrPoints()) {
                        series.newAttribute((Object)"pointsVisible", render.isSeriesPointsVisible(seriesKey));
                        series.newAttribute((Object)"pointSize", render.getPointSize());
                    }
                    if (render.isLines()) {
                        series.newAttribute((Object)"lineWidth", lineWidth.orElse(Float.valueOf(1.0f)));
                        series.newAttribute((Object)"curveType", render.getCurveType());
                        this.applyShape((JsObject)series, shape.orElse(null));
                        if (render.isSeriesDashedLine(seriesKey)) {
                            series.newArray("lineDashStyle", true, array -> array.append(10).append(2));
                        }
                    }
                });
            }
        });
    }

    private void trendLineOptions(JsObject options) {
        if (this.trendLineMap.size() > 0) {
            GXyDataset<X, Comparable> dataset = this.model.getUnifiedDataset();
            Iterable<Comparable> seriesKeys = dataset.getSeriesKeys();
            Index index = Index.of(seriesKeys);
            if (seriesKeys != null) {
                options.newObject("trendlines", trendLines -> this.trendLineMap.forEach((key, trend) -> {
                    int ordinal = index.getOrdinalForKey(key);
                    trendLines.newObject(ordinal, entry -> {
                        entry.newAttribute((Object)"type", "linear");
                        entry.newAttribute((Object)"color", ColorModel.toHexString(trend.getColor()));
                        entry.newAttribute((Object)"lineWidth", Float.valueOf(trend.getLineWidth()));
                        entry.newAttribute((Object)"opacity", 1.0);
                        entry.newAttribute((Object)"showR2", false);
                        entry.newAttribute((Object)"visibleInLegend", false);
                    });
                }));
            }
        }
    }

    private void applyShape(JsObject object, ChartShape shape) {
        if (shape != null) {
            switch (shape) {
                case CIRCLE: {
                    object.newAttribute((Object)"pointShape", "circle");
                    break;
                }
                case SQUARE: {
                    object.newAttribute((Object)"pointShape", "square");
                    break;
                }
                case DIAMOND: {
                    object.newAttribute((Object)"pointShape", "diamond");
                    break;
                }
                case TRIANGLE_UP: {
                    object.newAttribute((Object)"pointShape", "triangle");
                    break;
                }
                case TRIANGLE_DOWN: {
                    object.newObject("pointShape", x -> x.newAttribute((Object)"type", "triangle").newAttribute((Object)"rotation", 180));
                    break;
                }
                case TRIANGLE_RIGHT: {
                    object.newObject("pointShape", x -> x.newAttribute((Object)"type", "triangle").newAttribute((Object)"rotation", 90));
                    break;
                }
                case TRIANGLE_LEFT: {
                    object.newObject("pointShape", x -> x.newAttribute((Object)"type", "triangle").newAttribute((Object)"rotation", 270));
                    break;
                }
                default: {
                    System.err.println("Unsupported shape: " + (Object)((Object)shape));
                }
            }
        }
    }

    private boolean isHorizontal() {
        return !this.isVertical();
    }

    ChartShape.Provider getShapeProvider() {
        return this.shapeProvider;
    }

    boolean isVertical() {
        if (this.orient.horizontal != null) {
            return this.orient.horizontal == false;
        }
        return this.renderAt(0).isBars();
    }

    private class GXyOrient
    implements XyOrient {
        private Boolean horizontal;

        private GXyOrient() {
        }

        @Override
        public void vertical() {
            this.horizontal = false;
        }

        @Override
        public void horizontal() {
            this.horizontal = true;
        }
    }
}

