/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.google;

import com.zavtech.morpheus.viz.chart.ChartShape;
import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.google.GXyPlot;
import java.awt.Color;
import java.util.Optional;

class GXyRender
implements XyRender {
    private int pointSize = 4;
    private boolean stacked = false;
    private boolean spline = false;
    private boolean dashed = false;
    private boolean shapes = false;
    private Type type = Type.LINES;
    private GXyPlot<? extends Comparable> plot;

    GXyRender(GXyPlot<? extends Comparable> plot) {
        this.plot = plot;
    }

    Type getChartType() {
        return this.type;
    }

    String getCurveType() {
        return this.spline ? "function" : "none";
    }

    boolean isStacked() {
        return this.stacked;
    }

    boolean isBars() {
        return this.type == Type.BARS;
    }

    boolean isLines() {
        return this.getChartType() == Type.LINES;
    }

    boolean isArea() {
        return this.getChartType() == Type.AREA;
    }

    boolean hasShapesOrPoints() {
        return this.type == Type.DOTS || this.shapes;
    }

    boolean isScatter() {
        return this.type == Type.DOTS || this.type == Type.SHAPES;
    }

    boolean isDots() {
        return this.type == Type.DOTS;
    }

    int getPointSize() {
        return this.pointSize;
    }

    @Override
    public void withDots() {
        this.withDots(4);
    }

    @Override
    public void withDots(int diameter) {
        this.type = Type.DOTS;
        this.shapes = false;
        this.dashed = false;
        this.spline = false;
        this.stacked = false;
        this.pointSize = diameter;
    }

    @Override
    public void withArea(boolean stacked) {
        this.type = Type.AREA;
        this.spline = false;
        this.stacked = stacked;
        this.shapes = false;
        this.dashed = false;
    }

    @Override
    public void withBars(boolean stacked, double margin) {
        this.type = Type.BARS;
        this.spline = false;
        this.stacked = stacked;
        this.shapes = false;
        this.dashed = false;
    }

    @Override
    public void withLines(boolean shapes, boolean dashed) {
        this.type = Type.LINES;
        this.shapes = shapes;
        this.dashed = dashed;
        this.spline = false;
        this.stacked = false;
    }

    @Override
    public void withShapes() {
        this.type = Type.SHAPES;
        this.shapes = true;
        this.spline = false;
        this.stacked = false;
        this.dashed = false;
    }

    @Override
    public void withSpline(boolean shapes, boolean dashed) {
        this.type = Type.LINES;
        this.spline = true;
        this.shapes = shapes;
        this.dashed = dashed;
        this.stacked = false;
    }

    Color getSeriesColor(Comparable seriesKey) {
        Color color = this.plot.getSeriesColor(seriesKey);
        return color != null ? color : this.plot.getColorModel().getColor(seriesKey);
    }

    Optional<Float> getSeriesLineWidth(Comparable seriesKey) {
        Float lineWidth = this.plot.getSeriesLineWidth(seriesKey);
        return lineWidth != null ? Optional.of(lineWidth) : (this.isLines() ? Optional.of(Float.valueOf(1.0f)) : Optional.empty());
    }

    boolean isSeriesPointsVisible(Comparable seriesKey) {
        Boolean visible = this.plot.isSeriesPointsVisible(seriesKey);
        return visible != null ? visible : this.shapes || this.type == Type.DOTS;
    }

    boolean isSeriesDashedLine(Comparable seriesKey) {
        Boolean dashed = this.plot.isSeriesDashedLine(seriesKey);
        return dashed != null ? dashed : this.dashed;
    }

    Optional<ChartShape> getSeriesPointShape(Comparable seriesKey) {
        ChartShape shape = this.plot.getSeriesPointShape(seriesKey);
        if (shape != null) {
            return Optional.of(shape);
        }
        if (!this.shapes) {
            return Optional.empty();
        }
        return Optional.of(this.plot.getShapeProvider().getShape(seriesKey));
    }

    static enum Type {
        DOTS,
        SHAPES,
        BARS,
        LINES,
        AREA,
        SPLINE;

    }
}

