/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.html;

import com.zavtech.morpheus.util.IO;
import com.zavtech.morpheus.viz.html.HtmlElement;
import java.awt.Desktop;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.function.Consumer;

public class HtmlCode {
    private String indent = "";
    private StringBuilder html = new StringBuilder();

    public static String createHtml(Consumer<HtmlCode> consumer) {
        HtmlCode writer = new HtmlCode();
        consumer.accept(writer);
        return writer.toString().trim();
    }

    public HtmlCode indent(int count) {
        StringBuilder indentation = new StringBuilder(this.indent);
        for (int i = 0; i < count; ++i) {
            indentation.append(" ");
            this.html.append(" ");
        }
        this.indent = indentation.toString();
        return this;
    }

    public HtmlCode unident(int count) {
        this.indent = this.indent.substring(0, this.indent.length() - count);
        return this;
    }

    public HtmlCode newLine() {
        this.html.append("\n");
        this.html.append(this.indent);
        return this;
    }

    public HtmlCode write(String line, Object ... args) {
        if (args == null || args.length == 0) {
            this.html.append(line);
            return this;
        }
        this.html.append(String.format(line, args));
        return this;
    }

    public HtmlCode newElement(String name, Consumer<HtmlElement> consumer) {
        HtmlElement element = new HtmlElement(name, this);
        consumer.accept(element);
        element.close();
        return this;
    }

    public void flush(File file) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(file));){
            bos.write(this.html.toString().getBytes());
        }
    }

    public File browse() throws IOException {
        return this.browse(File.createTempFile("chart_", ".html"));
    }

    public File browse(File file) throws IOException {
        IO.writeText((String)this.html.toString(), (File)file);
        Desktop.getDesktop().browse(file.toURI());
        return file;
    }

    public String toString() {
        return this.html.toString();
    }

    public static void main(String[] args) {
        HtmlCode htmlCode = new HtmlCode();
        htmlCode.newElement("html", html -> {
            html.newElement("head", head -> {
                head.newElement("title", title -> title.text("This is a test page"));
                head.newElement("script", script -> {
                    script.newAttribute("type", "text/javascript");
                    script.newAttribute("src", "https://www.gstatic.com/charts/loader.js");
                });
                head.newElement("script", script -> {
                    script.newAttribute("type", "text/javascript");
                    script.text("var x = 20;\nvar y = 45;\nvar z = 2323;");
                });
            });
            html.newElement("body", body -> {
                body.newElement("p", p -> p.text("Hello World!"));
                body.newElement("table", table -> {
                    table.newElement("thead", head -> head.newElement("tr", row -> {
                        row.newElement("td", td -> td.text("Column-0"));
                        row.newElement("td", td -> td.text("Column-1"));
                        row.newElement("td", td -> td.text("Column-2"));
                        row.newElement("td", td -> td.text("Column-3"));
                        row.newElement("td", td -> td.text("Column-4"));
                    }));
                    for (int i = 0; i < 10; ++i) {
                        table.newElement("tr", row -> {
                            row.newElement("td", td -> td.text(String.valueOf(Math.random())));
                            row.newElement("td", td -> td.text(String.valueOf(Math.random())));
                            row.newElement("td", td -> td.text(String.valueOf(Math.random())));
                            row.newElement("td", td -> td.text(String.valueOf(Math.random())));
                            row.newElement("td", td -> td.text(String.valueOf(Math.random())));
                        });
                    }
                });
            });
        });
        System.out.println(htmlCode.toString());
    }
}

