/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.html;

import com.zavtech.morpheus.util.Collect;
import com.zavtech.morpheus.viz.html.HtmlCode;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;

public class HtmlElement {
    private static final Set<String> newLineSet = new HashSet<String>();
    private static final Set<String> noIndentSet = new HashSet<String>();
    private String name;
    private boolean attrs;
    private HtmlCode writer;
    private boolean mixedContent;

    HtmlElement(String name, HtmlCode writer) {
        this.name = name;
        this.attrs = true;
        this.writer = writer;
        if (newLineSet.contains(name.toLowerCase())) {
            this.writer.newLine();
        }
        if (!noIndentSet.contains(name.toLowerCase())) {
            this.writer.indent(4);
        }
        this.writer.write("<%s", name);
    }

    public HtmlElement text(String text) {
        String[] lines;
        if (this.attrs) {
            this.writer.write(">", new Object[0]);
            this.attrs = false;
        }
        if ((lines = text.split("\n")).length > 1) {
            this.mixedContent = true;
            this.writer.indent(4);
            for (String line : lines) {
                this.writer.newLine();
                this.writer.write(line, new Object[0]);
            }
            this.writer.unident(4);
        } else {
            this.writer.write(text, new Object[0]);
        }
        return this;
    }

    public HtmlElement newAttribute(String name, String value) {
        if (!this.attrs) {
            throw new IllegalStateException("The html element named " + name + " has already been closed");
        }
        this.writer.write(" %s=\"%s\"", name, value);
        return this;
    }

    public HtmlElement newElement(String name, Consumer<HtmlElement> consumer) {
        if (this.attrs) {
            this.writer.write(">", new Object[0]);
            this.attrs = false;
        }
        this.mixedContent = true;
        HtmlElement element = new HtmlElement(name, this.writer);
        consumer.accept(element);
        element.close();
        return this;
    }

    HtmlElement close() {
        this.writer.write(!this.mixedContent ? ">" : "", new Object[0]);
        if (this.mixedContent && newLineSet.contains(this.name.toLowerCase())) {
            this.writer.newLine();
        }
        this.writer.write("</%s>", this.name);
        if (!noIndentSet.contains(this.name.toLowerCase())) {
            this.writer.unident(4);
        }
        return this;
    }

    static {
        newLineSet.addAll(Collect.asSet((Object[])new String[]{"html", "body", "head", "script", "div", "p", "h1", "h2", "h3", "h4", "input", "dl", "ol", "area", "canvas", "code", "table", "tr", "td", "thead", "form", "hr", "meta", "nav", "ol", "option", "pre", "section", "select", "tbody", "textarea", "tfoot", "th", "title"}));
        noIndentSet.add("html");
        noIndentSet.add("body");
        noIndentSet.add("img");
        noIndentSet.add("span");
    }
}

