/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.index.Index;
import com.zavtech.morpheus.range.Range;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;

class JFCatDataset<X extends Comparable, S extends Comparable>
extends AbstractDataset
implements XyDataset<X, S>,
CategoryDataset {
    private static final Double NAN = Double.NaN;
    private Index<S> seriesKeys;
    private Index<X> domainKeys;
    private DataFrame<?, S> frame;
    private Array<Integer> colOrdinals;
    private Supplier<Class<X>> domainType;
    private IntFunction<X> domainValueFunction;
    private Consumer<JFCatDataset<X, S>> refreshHandler;

    private JFCatDataset(Consumer<JFCatDataset<X, S>> refreshHandler) {
        this.refreshHandler = refreshHandler;
        this.refresh();
    }

    public static <X extends Comparable, S extends Comparable> JFCatDataset<X, S> of(Supplier<DataFrame<X, S>> frameSupplier) {
        return new JFCatDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).toArray());
                    Supplier domainType = () -> frame.rows().keyType();
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.rows().key(rowIndex));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    public static <X extends Comparable, S extends Comparable> JFCatDataset<X, S> of(S domainAxisKey, Supplier<DataFrame<?, S>> frameSupplier) {
        return new JFCatDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    int domainAxisColOrdinal = frame.cols().ordinalOf((Object)domainAxisKey);
                    Supplier domainType = () -> frame.cols().type((Object)domainAxisKey);
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).filter(i -> i != domainAxisColOrdinal).toArray());
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.data().getValue(rowIndex, domainAxisColOrdinal));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(DataFrame<?, S> frame, Array<Integer> colOrdinals, Supplier<Class<X>> domainType, IntFunction<X> domainValueFunction) {
        try {
            this.frame = frame;
            this.colOrdinals = colOrdinals;
            this.domainType = domainType;
            this.domainValueFunction = domainValueFunction;
            this.domainKeys = Index.of((Iterable)Range.of((int)0, (int)frame.rowCount()).map(domainValueFunction::apply).toArray());
            this.seriesKeys = Index.of((Iterable)colOrdinals.map(v -> (Comparable)frame.cols().key(v.getInt())));
        }
        finally {
            this.fireDatasetChanged();
        }
    }

    @Override
    public void refresh() {
        this.refreshHandler.accept(this);
    }

    @Override
    public boolean isEmpty() {
        return this.frame == null || this.seriesKeys == null || this.seriesKeys.size() == 0;
    }

    @Override
    public void clear(boolean notify) {
        this.frame = null;
        this.seriesKeys = null;
        this.domainKeys = null;
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    @Override
    public Class<X> domainType() {
        return this.isEmpty() ? null : this.domainType.get();
    }

    @Override
    public <R> DataFrame<R, S> frame() {
        return this.frame;
    }

    @Override
    public boolean contains(S seriesKey) {
        return this.seriesKeys.contains(seriesKey);
    }

    @Override
    public IntFunction<X> domainFunction() {
        return this.domainValueFunction;
    }

    @Override
    public XyDataset<X, S> withLowerDomainInterval(Function<X, X> lowerIntervalFunction) {
        return this;
    }

    @Override
    public XyDataset<X, S> withUpperDomainInterval(Function<X, X> upperIntervalFunction) {
        return this;
    }

    public int getRowCount() {
        return this.isEmpty() ? 0 : this.seriesKeys.size();
    }

    public int getColumnCount() {
        return this.isEmpty() ? 0 : this.domainKeys.size();
    }

    public List getRowKeys() {
        return this.isEmpty() ? Collections.emptyList() : this.seriesKeys.toList();
    }

    public List getColumnKeys() {
        return this.isEmpty() ? Collections.emptyList() : this.domainKeys.toList();
    }

    public Comparable getRowKey(int rowIndex) {
        return (Comparable)this.seriesKeys.getKey(rowIndex);
    }

    public Comparable getColumnKey(int colIndex) {
        return (Comparable)this.domainKeys.getKey(colIndex);
    }

    public int getRowIndex(Comparable rowKey) {
        return this.seriesKeys.getIndexForKey((Object)rowKey);
    }

    public int getColumnIndex(Comparable colKey) {
        return this.domainKeys.getIndexForKey((Object)colKey);
    }

    public Number getValue(Comparable rowKey, Comparable colKey) {
        if (this.isEmpty()) {
            return NAN;
        }
        int rowOrdinal = this.domainKeys.getIndexForKey((Object)colKey);
        int colOrdinal = this.frame.cols().ordinalOf((Object)rowKey);
        return this.frame.data().getDouble(rowOrdinal, colOrdinal);
    }

    public Number getValue(int rowIndex, int colIndex) {
        if (this.isEmpty()) {
            return NAN;
        }
        int colOrdinal = this.colOrdinals.getInt(rowIndex);
        return this.frame.data().getDouble(colIndex, colOrdinal);
    }
}

