/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.xy.XyAxes;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import com.zavtech.morpheus.viz.chart.xy.XyModel;
import com.zavtech.morpheus.viz.chart.xy.XyOrient;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlotBase;
import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.chart.xy.XyTrend;
import com.zavtech.morpheus.viz.jfree.JFCatDataset;
import com.zavtech.morpheus.viz.jfree.JFCatRender;
import com.zavtech.morpheus.viz.jfree.JFXyAxes;
import java.awt.Color;
import java.awt.Paint;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;

class JFCatPlot<X extends Comparable>
extends XyPlotBase<X>
implements XyPlot<X> {
    private CategoryPlot plot;
    private Map<Integer, JFCatDataset<X, ? extends Comparable>> datasetMap = new LinkedHashMap<Integer, JFCatDataset<X, ? extends Comparable>>();

    JFCatPlot(CategoryAxis domainAxis, ValueAxis rangeAxis) {
        this.plot = new CategoryPlot(null, domainAxis, rangeAxis, null);
        this.plot.getRangeAxis().setAutoRange(true);
        this.plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        this.plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        this.plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.REVERSE);
        if (rangeAxis instanceof NumberAxis) {
            ((NumberAxis)rangeAxis).setAutoRangeIncludesZero(false);
        }
    }

    CategoryPlot underlying() {
        return this.plot;
    }

    @Override
    public XyAxes axes() {
        return new JFXyAxes((Plot)this.plot);
    }

    @Override
    public <S extends Comparable> XyModel<X, S> data() {
        return new ModelAdapter();
    }

    @Override
    public XyOrient orient() {
        return new OrientAdapter();
    }

    @Override
    public <S extends Comparable> XyTrend trend(S seriesKey) {
        throw new UnsupportedOperationException("Trend lines are not supported for categorical / discrete XY plots");
    }

    @Override
    public XyRender render(int index) {
        return new JFCatRender(this, index);
    }

    private int getDatasetCount() {
        int count = 0;
        for (int i = 0; i < this.plot.getDatasetCount(); ++i) {
            CategoryDataset dataSet = this.plot.getDataset(i);
            if (dataSet == null) continue;
            ++count;
        }
        return count;
    }

    private class ModelAdapter<S extends Comparable>
    implements XyModel<X, S> {
        private ModelAdapter() {
        }

        @Override
        public Class<X> domainType() {
            if (JFCatPlot.this.datasetMap.isEmpty()) {
                return null;
            }
            return ((JFCatDataset)JFCatPlot.this.datasetMap.entrySet().iterator().next().getValue()).domainType();
        }

        @Override
        public void setRangeAxis(int dataset, int axis) {
            ValueAxis rangeAxis = JFCatPlot.this.plot.getRangeAxis(axis);
            if (rangeAxis == null) {
                JFCatPlot.this.plot.setRangeAxis(axis, (ValueAxis)new NumberAxis());
                JFCatPlot.this.plot.mapDatasetToRangeAxis(dataset, axis);
            } else {
                JFCatPlot.this.plot.mapDatasetToRangeAxis(dataset, axis);
            }
        }

        @Override
        public XyDataset<X, S> at(int index) {
            JFCatDataset dataset = (JFCatDataset)JFCatPlot.this.datasetMap.get(index);
            if (dataset != null) {
                return dataset;
            }
            throw new IllegalArgumentException("No chart data located at index: " + index);
        }

        @Override
        public int add(DataFrame<X, S> frame) {
            int index = JFCatPlot.this.getDatasetCount();
            JFCatDataset dataset = JFCatDataset.of(() -> frame);
            JFCatPlot.this.datasetMap.put(index, dataset);
            JFCatPlot.this.plot.setDataset(index, dataset);
            return index;
        }

        @Override
        public int add(DataFrame<?, S> frame, S domainKey) {
            int index = JFCatPlot.this.getDatasetCount();
            JFCatDataset dataset = JFCatDataset.of(domainKey, () -> frame);
            JFCatPlot.this.datasetMap.put(index, dataset);
            JFCatPlot.this.plot.setDataset(index, dataset);
            return index;
        }

        @Override
        public XyDataset<X, S> update(int index, DataFrame<X, S> frame) {
            JFCatDataset dataset = JFCatDataset.of(() -> frame);
            JFCatPlot.this.datasetMap.put(index, dataset);
            JFCatPlot.this.plot.setDataset(index, dataset);
            return dataset;
        }

        @Override
        public XyDataset<X, S> update(int index, DataFrame<?, S> frame, S domainKey) {
            JFCatDataset dataset = JFCatDataset.of(domainKey, () -> frame);
            JFCatPlot.this.datasetMap.put(index, dataset);
            JFCatPlot.this.plot.setDataset(index, dataset);
            return dataset;
        }

        @Override
        public void remove(int index) {
            XyDataset dataset = (XyDataset)JFCatPlot.this.datasetMap.remove(index);
            if (dataset == null) {
                throw new ChartException("No chart data model exists for id: " + index);
            }
            JFCatPlot.this.plot.setDataset(index, null);
        }

        @Override
        public void removeAll() {
            int count = JFCatPlot.this.getDatasetCount();
            JFCatPlot.this.datasetMap.clear();
            for (int i = 0; i < count; ++i) {
                JFCatPlot.this.plot.setDataset(i, null);
            }
        }
    }

    private class OrientAdapter
    implements XyOrient {
        private OrientAdapter() {
        }

        @Override
        public void vertical() {
            JFCatPlot.this.plot.setOrientation(PlotOrientation.VERTICAL);
        }

        @Override
        public void horizontal() {
            JFCatPlot.this.plot.setOrientation(PlotOrientation.HORIZONTAL);
        }
    }
}

