/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.jfree.JFCatPlot;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.data.category.CategoryDataset;

class JFCatRender
implements XyRender {
    private int index;
    private JFCatPlot plot;

    JFCatRender(JFCatPlot plot, int index) {
        this.plot = plot;
        this.index = index;
    }

    @Override
    public void withDots() {
        this.withDots(4);
    }

    @Override
    public void withDots(int diameter) {
        this.plot.underlying().setRenderer(this.index, (CategoryItemRenderer)new MorpheusDotRenderer(this.index, diameter));
    }

    @Override
    public void withShapes() {
        this.plot.underlying().setRenderer(this.index, (CategoryItemRenderer)new LineAndShapeRenderer(false, false));
    }

    @Override
    public void withArea(boolean shapes) {
        this.plot.underlying().setRenderer(this.index, (CategoryItemRenderer)new AreaRenderer());
    }

    @Override
    public void withBars(boolean stacked, double margin) {
        this.plot.underlying().setRenderer(this.index, (CategoryItemRenderer)(stacked ? new MorpheusStackedBarRenderer(this.index) : new MorpheusBarRenderer(this.index)));
    }

    @Override
    public void withLines(boolean shapes, boolean dashed) {
        this.plot.underlying().setRenderer(this.index, (CategoryItemRenderer)new LineAndShapeRenderer(true, false));
    }

    @Override
    public void withSpline(boolean shapes, boolean dashed) {
        throw new UnsupportedOperationException("Not supported for category plots");
    }

    private class MorpheusDotRenderer
    extends LineAndShapeRenderer {
        private int datasetIndex;
        private Shape dotShape;

        MorpheusDotRenderer(int datasetIndex, int diameter) {
            this.datasetIndex = datasetIndex;
            this.dotShape = new Ellipse2D.Double(-2.0, -2.0, diameter, diameter);
            this.setBaseShape(this.dotShape);
            this.setBaseLinesVisible(false);
            this.setBaseShapesVisible(true);
        }

        public Paint getSeriesPaint(int series) {
            try {
                CategoryPlot categoryPlot = this.getPlot();
                CategoryDataset dataset = categoryPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getRowKey(series);
                    Color color = JFCatRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFCatRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }

        public Shape getSeriesShape(int series) {
            return super.getSeriesShape(series);
        }
    }

    private class MorpheusStackedBarRenderer
    extends StackedBarRenderer {
        private int datasetIndex;

        MorpheusStackedBarRenderer(int datasetIndex) {
            this.datasetIndex = datasetIndex;
            this.setBarPainter((BarPainter)new StandardBarPainter());
            this.setDrawBarOutline(true);
            this.setShadowVisible(false);
        }

        public Paint getSeriesPaint(int series) {
            try {
                CategoryPlot catPlot = this.getPlot();
                CategoryDataset dataset = catPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getRowKey(series);
                    Color color = JFCatRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFCatRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusBarRenderer
    extends BarRenderer {
        private int datasetIndex;

        MorpheusBarRenderer(int datasetIndex) {
            this.datasetIndex = datasetIndex;
            this.setBarPainter((BarPainter)new StandardBarPainter());
            this.setDrawBarOutline(true);
            this.setShadowVisible(false);
            this.setItemMargin(0.01);
        }

        public Paint getSeriesPaint(int series) {
            try {
                CategoryPlot catPlot = this.getPlot();
                CategoryDataset dataset = catPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getRowKey(series);
                    Color color = JFCatRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFCatRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }
}

