/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.ChartLabel;
import com.zavtech.morpheus.viz.chart.ChartLegend;
import com.zavtech.morpheus.viz.chart.ChartOptions;
import com.zavtech.morpheus.viz.chart.ChartTheme;
import com.zavtech.morpheus.viz.jfree.JFCatPlot;
import com.zavtech.morpheus.viz.jfree.JFPiePlot;
import com.zavtech.morpheus.viz.jfree.JFXyPlot;
import com.zavtech.morpheus.viz.js.JsCode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.Optional;
import javax.swing.JFrame;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;

abstract class JFChartBase<P>
implements Chart<P>,
ChartMouseListener {
    private P plot;
    private JFreeChart freeChart;
    private ChartPanel chartPanel;
    private ChartOptions options;

    JFChartBase(P plot, boolean legend) {
        this.plot = plot;
        this.freeChart = new JFreeChart(null, new Font("Arial", 0, 4), this.underlying(plot), legend);
        this.freeChart.setBackgroundPaint((Paint)Color.WHITE);
        this.chartPanel = new ChartPanel(this.freeChart);
        this.chartPanel.setMouseZoomable(true);
        this.chartPanel.setRefreshBuffer(true);
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.options = new ChartOptions.Default();
    }

    private Plot underlying(P plot) {
        if (plot instanceof JFXyPlot) {
            return ((JFXyPlot)plot).underlying();
        }
        if (plot instanceof JFCatPlot) {
            return ((JFCatPlot)plot).underlying();
        }
        if (plot instanceof JFPiePlot) {
            return ((JFPiePlot)plot).underlying();
        }
        throw new IllegalArgumentException("Unsupported plot type: " + plot);
    }

    ChartPanel chartPanel() {
        return this.chartPanel;
    }

    JFreeChart freeChart() {
        return this.freeChart;
    }

    @Override
    public P plot() {
        return this.plot;
    }

    @Override
    public ChartLabel title() {
        return new TitleAdapter(this.freeChart, false);
    }

    @Override
    public ChartLabel subtitle() {
        return new TitleAdapter(this.freeChart, true);
    }

    @Override
    public ChartLegend legend() {
        return new LegendAdapter(this.freeChart);
    }

    @Override
    public ChartOptions options() {
        return this.options;
    }

    @Override
    public ChartTheme theme() {
        return new ThemeAdapter();
    }

    @Override
    public Chart show() {
        return this.show(1024, 600);
    }

    @Override
    public Chart show(int width, int height) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new BorderLayout(0, 0));
        frame.getContentPane().add((Component)this.chartPanel, "Center");
        frame.getContentPane().setBackground(Color.WHITE);
        frame.pack();
        frame.setSize(width, height);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        return this;
    }

    @Override
    public Chart writerPng(File file, int width, int height, boolean transparent) {
        BufferedOutputStream os = null;
        try {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                System.err.printf("Unable to create directory for %s", file.getAbsolutePath());
            }
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.writerPng(os, width, height, transparent);
            JFChartBase jFChartBase = this;
            return jFChartBase;
        }
        catch (Exception ex) {
            throw new ChartException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public Chart writerPng(OutputStream os, int width, int height, boolean transparent) {
        try {
            if (transparent) {
                this.freeChart().setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
                this.freeChart().setBackgroundImageAlpha(0.0f);
                this.freeChart().getPlot().setBackgroundPaint((Paint)new Color(255, 255, 255, 0));
                this.freeChart().getPlot().setBackgroundImageAlpha(0.0f);
            }
            ChartUtilities.writeChartAsPNG((OutputStream)os, (JFreeChart)this.freeChart, (int)width, (int)height, (boolean)transparent, (int)0);
            JFChartBase jFChartBase = this;
            return jFChartBase;
        }
        catch (Exception ex) {
            throw new ChartException(ex.getMessage(), ex);
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void accept(JsCode jsCode, String functionName, String divId) {
        try {
            String base64Image = this.toBase64Image();
            jsCode.newFunction(functionName, func -> {
                func.write("var divElement = document.getElementById('%s');", divId);
                func.newLine().write("var imageElement = document.createElement('img');", new Object[0]);
                func.newLine().write("imageElement.setAttribute('src', 'data:image/png;base64, %s');", base64Image);
                func.newLine().write("imageElement.setAttribute('alt', 'Embedded Chart');", new Object[0]);
                func.newLine().write("imageElement.setAttribute('class', 'chart');", new Object[0]);
                func.newLine().write("divElement.appendChild(imageElement);", new Object[0]);
            });
        }
        catch (IOException ex) {
            throw new ChartException("Failed to generate base64 image of chart", ex);
        }
    }

    String toBase64Image() throws IOException {
        double width = this.options().getPreferredSize().map(Dimension::getWidth).orElse(700.0);
        double height = this.options().getPreferredSize().map(Dimension::getHeight).orElse(400.0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writerPng(baos, (int)width, (int)height, true);
        byte[] imageBytes = baos.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        byte[] base64 = encoder.encode(imageBytes);
        return new String(base64);
    }

    private class ThemeAdapter
    implements ChartTheme {
        private ThemeAdapter() {
        }

        @Override
        public void light() {
            Color lightColor = Color.WHITE;
            Color darkColor = Color.BLACK;
            JFChartBase.this.freeChart().setBackgroundPaint((Paint)lightColor);
            Optional.ofNullable(JFChartBase.this.freeChart().getTitle()).ifPresent(x -> {
                x.setPaint((Paint)darkColor);
                x.setBackgroundPaint((Paint)lightColor);
            });
            Optional.ofNullable(JFChartBase.this.freeChart().getSubtitle(0)).ifPresent(x -> {
                if (x instanceof TextTitle) {
                    ((TextTitle)x).setBackgroundPaint((Paint)lightColor);
                    ((TextTitle)x).setPaint((Paint)darkColor);
                }
            });
            Optional.ofNullable(JFChartBase.this.freeChart().getLegend()).ifPresent(x -> {
                x.setBackgroundPaint((Paint)lightColor);
                x.setItemPaint((Paint)darkColor);
            });
            Plot plot = JFChartBase.this.freeChart().getPlot();
            if (plot instanceof XYPlot) {
                int i;
                XYPlot xyPlot = (XYPlot)plot;
                xyPlot.setBackgroundPaint((Paint)lightColor);
                xyPlot.setDomainGridlinesVisible(true);
                xyPlot.setRangeGridlinesVisible(true);
                xyPlot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
                xyPlot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
                for (i = 0; i < xyPlot.getDatasetCount(); ++i) {
                    xyPlot.getDomainAxis().setLabelPaint((Paint)darkColor);
                    xyPlot.getDomainAxis().setTickLabelPaint((Paint)darkColor);
                    xyPlot.getDomainAxis().setLabelPaint((Paint)darkColor);
                    xyPlot.getDomainAxis().setAxisLinePaint((Paint)darkColor);
                    xyPlot.getDomainAxis().setTickMarkPaint((Paint)darkColor);
                }
                for (i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                    xyPlot.getRangeAxis(i).setLabelPaint((Paint)darkColor);
                    xyPlot.getRangeAxis(i).setTickLabelPaint((Paint)darkColor);
                    xyPlot.getRangeAxis(i).setLabelPaint((Paint)darkColor);
                    xyPlot.getRangeAxis(i).setAxisLinePaint((Paint)darkColor);
                    xyPlot.getRangeAxis(i).setTickMarkPaint((Paint)darkColor);
                }
            }
        }

        @Override
        public void dark() {
            Color darkColor = Color.BLACK;
            Color lightColor = Color.LIGHT_GRAY;
            JFChartBase.this.freeChart().setBackgroundPaint((Paint)darkColor);
            Optional.ofNullable(JFChartBase.this.freeChart().getTitle()).ifPresent(x -> {
                x.setPaint((Paint)lightColor);
                x.setBackgroundPaint((Paint)darkColor);
            });
            Optional.ofNullable(JFChartBase.this.freeChart().getSubtitle(0)).ifPresent(x -> {
                if (x instanceof TextTitle) {
                    ((TextTitle)x).setBackgroundPaint((Paint)darkColor);
                    ((TextTitle)x).setPaint((Paint)lightColor);
                }
            });
            Optional.ofNullable(JFChartBase.this.freeChart().getLegend()).ifPresent(x -> {
                x.setBackgroundPaint((Paint)darkColor);
                x.setItemPaint((Paint)lightColor);
            });
            Plot plot = JFChartBase.this.freeChart().getPlot();
            if (plot instanceof XYPlot) {
                int i;
                XYPlot xyPlot = (XYPlot)plot;
                xyPlot.setBackgroundPaint((Paint)darkColor);
                xyPlot.setDomainGridlinesVisible(true);
                xyPlot.setRangeGridlinesVisible(true);
                xyPlot.setDomainGridlinePaint((Paint)Color.LIGHT_GRAY);
                xyPlot.setRangeGridlinePaint((Paint)Color.LIGHT_GRAY);
                for (i = 0; i < xyPlot.getDatasetCount(); ++i) {
                    xyPlot.getDomainAxis().setLabelPaint((Paint)lightColor);
                    xyPlot.getDomainAxis().setTickLabelPaint((Paint)lightColor);
                    xyPlot.getDomainAxis().setLabelPaint((Paint)lightColor);
                    xyPlot.getDomainAxis().setAxisLinePaint((Paint)lightColor);
                    xyPlot.getDomainAxis().setTickMarkPaint((Paint)lightColor);
                }
                for (i = 0; i < xyPlot.getRangeAxisCount(); ++i) {
                    xyPlot.getRangeAxis(i).setLabelPaint((Paint)lightColor);
                    xyPlot.getRangeAxis(i).setTickLabelPaint((Paint)lightColor);
                    xyPlot.getRangeAxis(i).setLabelPaint((Paint)lightColor);
                    xyPlot.getRangeAxis(i).setAxisLinePaint((Paint)lightColor);
                    xyPlot.getRangeAxis(i).setTickMarkPaint((Paint)lightColor);
                }
            }
        }
    }

    private class LegendAdapter
    implements ChartLegend {
        private JFreeChart chart;

        private LegendAdapter(JFreeChart chart) {
            this.chart = chart;
        }

        @Override
        public ChartLegend on() {
            LegendTitle legend = this.chart.getLegend();
            if (legend == null) {
                Plot plot = this.chart.getPlot();
                legend = new LegendTitle((LegendItemSource)plot);
                this.chart.addLegend(legend);
                this.chart.getLegend().setVisible(true);
                this.chart.getLegend().setPosition(RectangleEdge.RIGHT);
                this.chart.getLegend().setItemLabelPadding(new RectangleInsets(1.0, 1.0, 1.0, 5.0));
                this.chart.getLegend().setLegendItemGraphicPadding(new RectangleInsets(1.0, 5.0, 1.0, 1.0));
            }
            return this;
        }

        @Override
        public ChartLegend off() {
            LegendTitle legend = this.chart.getLegend();
            if (legend != null) {
                legend.setVisible(false);
            }
            return this;
        }

        @Override
        public ChartLegend right() {
            this.on();
            this.chart.getLegend().setPosition(RectangleEdge.RIGHT);
            return this;
        }

        @Override
        public ChartLegend left() {
            this.on();
            this.chart.getLegend().setPosition(RectangleEdge.LEFT);
            return this;
        }

        @Override
        public ChartLegend top() {
            this.on();
            this.chart.getLegend().setPosition(RectangleEdge.TOP);
            return this;
        }

        @Override
        public ChartLegend bottom() {
            this.on();
            this.chart.getLegend().setPosition(RectangleEdge.BOTTOM);
            return this;
        }
    }

    private class TitleAdapter
    implements ChartLabel {
        private JFreeChart chart;
        private boolean subtitle;

        private TitleAdapter(JFreeChart chart, boolean subtitle) {
            this.chart = chart;
            this.subtitle = subtitle;
        }

        @Override
        public ChartLabel withText(String text) {
            this.getTitle().setText(text);
            return this;
        }

        @Override
        public ChartLabel withColor(Color color) {
            this.getTitle().setPaint((Paint)color);
            return this;
        }

        @Override
        public ChartLabel withFont(Font font) {
            this.getTitle().setFont(font);
            return this;
        }

        private TextTitle getTitle() {
            if (this.subtitle) {
                if (this.chart.getSubtitleCount() > 0) {
                    for (int i = 0; i < this.chart.getSubtitleCount(); ++i) {
                        Title title = this.chart.getSubtitle(i);
                        if (!(title instanceof TextTitle)) continue;
                        return (TextTitle)title;
                    }
                }
                TextTitle subtitle = new TextTitle();
                this.chart.addSubtitle((Title)subtitle);
                return subtitle;
            }
            TextTitle title = this.chart.getTitle();
            if (title == null) {
                title = new TextTitle();
                title.setFont(new Font("Arial", 1, 15));
                this.chart.setTitle(title);
            }
            return title;
        }
    }
}

