/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.util.Collect;
import com.zavtech.morpheus.viz.chart.Chart;
import com.zavtech.morpheus.viz.chart.ChartFactory;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.xy.XyPlot;
import com.zavtech.morpheus.viz.jfree.JFCatChart;
import com.zavtech.morpheus.viz.jfree.JFChartBase;
import com.zavtech.morpheus.viz.jfree.JFDateAxis;
import com.zavtech.morpheus.viz.jfree.JFPieChart;
import com.zavtech.morpheus.viz.jfree.JFXyChart;
import com.zavtech.morpheus.viz.js.JsCode;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.security.Timestamp;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.swing.JFrame;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;

public class JFChartFactory
implements ChartFactory {
    private static final Set<Class<?>> timeTypeSet = new HashSet();

    @Override
    public void show(int columns, Stream<Chart<?>> charts) {
        this.show(columns, Collect.asIterable(charts));
    }

    @Override
    public void show(int columns, Iterable<Chart<?>> charts) {
        JFrame frame = new JFrame();
        List chartList = Collect.asList(charts);
        double rowCount = Math.ceil(Math.max(1.0, (double)chartList.size() / (double)columns));
        frame.getContentPane().setLayout(new GridLayout((int)rowCount, columns));
        for (Chart chart : chartList) {
            JFChartBase jChart = (JFChartBase)chart;
            frame.getContentPane().add((Component)jChart.chartPanel());
        }
        frame.getContentPane().setBackground(Color.WHITE);
        frame.pack();
        frame.setSize(1024, 768);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    @Override
    public boolean isSupported(Chart<?> chart) {
        return chart instanceof JFCatChart || chart instanceof JFPieChart || chart instanceof JFXyChart;
    }

    @Override
    public String javascript(Iterable<Chart<?>> charts) {
        return this.javascript((Chart[])Collect.asStream(charts).toArray(Chart[]::new));
    }

    public String javascript(Chart ... charts) {
        return JsCode.create(jsCode -> {
            jsCode.newLine().write("window.onload = drawCharts", new Object[0]);
            jsCode.newLine();
            jsCode.newFunction("drawCharts", init -> {
                jsCode.write("console.info('Writing charts...');", new Object[0]);
                for (int i = 0; i < charts.length; ++i) {
                    init.newLine();
                    init.write("drawChart_%s();", i);
                }
            });
            for (int i = 0; i < charts.length; ++i) {
                Chart chart = charts[i];
                String functionName = String.format("drawChart_%s", i);
                String divId = chart.options().getId().orElse(String.format("chart_%s", i));
                jsCode.newLine().newLine();
                chart.accept((JsCode)jsCode, functionName, divId);
            }
        });
    }

    @Override
    public <X extends Comparable> Chart<XyPlot<X>> ofXY(Class<X> domainType, Consumer<Chart<XyPlot<X>>> configurator) {
        if (Integer.class.equals(domainType)) {
            NumberAxis domainAxis = new NumberAxis();
            NumberAxis rangeAxis = new NumberAxis();
            domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            JFXyChart chart = new JFXyChart((ValueAxis)domainAxis, (ValueAxis)rangeAxis, false);
            if (configurator != null) {
                configurator.accept(chart);
            }
            return chart;
        }
        if (Number.class.isAssignableFrom(domainType)) {
            NumberAxis domainAxis = new NumberAxis();
            NumberAxis rangeAxis = new NumberAxis();
            JFXyChart chart = new JFXyChart((ValueAxis)domainAxis, (ValueAxis)rangeAxis, false);
            if (configurator != null) {
                configurator.accept(chart);
            }
            return chart;
        }
        if (this.isTimeBased(domainType)) {
            JFDateAxis domainAxis = new JFDateAxis();
            NumberAxis rangeAxis = new NumberAxis();
            JFXyChart chart = new JFXyChart((ValueAxis)domainAxis, (ValueAxis)rangeAxis, false);
            if (configurator != null) {
                configurator.accept(chart);
            }
            return chart;
        }
        CategoryAxis domainAxis = new CategoryAxis();
        NumberAxis rangeAxis = new NumberAxis();
        JFCatChart chart = new JFCatChart(domainAxis, (ValueAxis)rangeAxis, false);
        if (configurator != null) {
            configurator.accept(chart);
        }
        return chart;
    }

    @Override
    public <X extends Comparable, S extends Comparable> Chart<PiePlot<X, S>> ofPiePlot(boolean is3d, Consumer<Chart<PiePlot<X, S>>> configurator) {
        JFPieChart chart = new JFPieChart(is3d, true);
        if (configurator != null) {
            configurator.accept(chart);
        }
        return chart;
    }

    private boolean isTimeBased(Class<?> type) {
        return timeTypeSet.contains(type);
    }

    static {
        timeTypeSet.add(java.util.Date.class);
        timeTypeSet.add(LocalDate.class);
        timeTypeSet.add(LocalDateTime.class);
        timeTypeSet.add(ZonedDateTime.class);
        timeTypeSet.add(Timestamp.class);
        timeTypeSet.add(Date.class);
        timeTypeSet.add(Calendar.class);
    }
}

