/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.viz.chart.ChartShape;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

class JFChartShapes {
    private Map<ChartShape, Shape> shapeMap = new HashMap<ChartShape, Shape>();

    JFChartShapes() {
        this(6.0);
    }

    private JFChartShapes(double size) {
        double delta = size / 2.0;
        this.shapeMap.put(ChartShape.SQUARE, new Rectangle2D.Double(-delta, -delta, size, size));
        this.shapeMap.put(ChartShape.CIRCLE, new Ellipse2D.Double(-delta, -delta, size, size));
        this.shapeMap.put(ChartShape.DIAMOND, new Polygon(JFChartShapes.intArray(0.0, delta, 0.0, -delta), JFChartShapes.intArray(-delta, 0.0, delta, 0.0), 4));
        this.shapeMap.put(ChartShape.TRIANGLE_UP, new Polygon(JFChartShapes.intArray(0.0, delta, -delta), JFChartShapes.intArray(-delta, delta, delta), 3));
        this.shapeMap.put(ChartShape.TRIANGLE_DOWN, new Polygon(JFChartShapes.intArray(-delta, delta, 0.0), JFChartShapes.intArray(-delta, -delta, delta), 3));
        this.shapeMap.put(ChartShape.TRIANGLE_RIGHT, new Polygon(JFChartShapes.intArray(0.0, delta, 0.0, -delta), JFChartShapes.intArray(-delta, 0.0, delta, 0.0), 4));
        this.shapeMap.put(ChartShape.TRIANGLE_LEFT, new Polygon(JFChartShapes.intArray(-delta, delta, delta), JFChartShapes.intArray(0.0, -delta, delta), 3));
    }

    Shape getShape(ChartShape shape) {
        return this.shapeMap.get((Object)shape);
    }

    private static int[] intArray(double a, double b, double c) {
        return new int[]{(int)a, (int)b, (int)c};
    }

    private static int[] intArray(double a, double b, double c, double d) {
        return new int[]{(int)a, (int)b, (int)c, (int)d};
    }
}

