/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTick;
import org.jfree.chart.axis.Tick;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;

class JFDateAxis
extends DateAxis {
    private double tickAngle;

    JFDateAxis() {
        this(null);
    }

    JFDateAxis(String label) {
        this(label, 0.0);
    }

    JFDateAxis(String label, double tickAngle) {
        super(label);
        this.tickAngle = tickAngle;
    }

    protected List refreshTicksVertical(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        List<Tick> ticks = super.refreshTicksVertical(g2, dataArea, edge);
        return this.tickAngle == 0.0 ? ticks : this.rotate(ticks);
    }

    protected List refreshTicksHorizontal(Graphics2D g2, Rectangle2D dataArea, RectangleEdge edge) {
        List<Tick> ticks = super.refreshTicksHorizontal(g2, dataArea, edge);
        return this.tickAngle == 0.0 ? ticks : this.rotate(ticks);
    }

    private List<Tick> rotate(List<Tick> ticks) {
        try {
            ArrayList<Tick> ticksRotated = new ArrayList<Tick>();
            for (Tick tick : ticks) {
                if (tick instanceof DateTick) {
                    DateTick dateTick = (DateTick)tick;
                    Date date = dateTick.getDate();
                    String tickLabel = dateTick.getText();
                    TextAnchor tickAnchor = TextAnchor.BASELINE_RIGHT;
                    TextAnchor rotationAnchor = TextAnchor.BASELINE_RIGHT;
                    ticksRotated.add((Tick)new DateTick(date, tickLabel, tickAnchor, rotationAnchor, this.tickAngle));
                    continue;
                }
                ticksRotated.add(tick);
            }
            return ticksRotated;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return ticks;
        }
    }
}

