/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.array.ArrayBuilder;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.index.Index;
import com.zavtech.morpheus.viz.chart.pie.PieModel;
import com.zavtech.morpheus.viz.chart.pie.PieModelDefault;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;

class JFPieModel<X extends Comparable, S extends Comparable>
extends AbstractDataset
implements PieModel<X, S>,
PieDataset {
    private Index<X> itemKeys = Index.empty();
    private PieModelDefault<X, S> model = new PieModelDefault();

    JFPieModel() {
    }

    private void updateItemKeys() {
        if (this.isEmpty()) {
            this.itemKeys = Index.empty();
        } else {
            int size = this.model.getFrame().rowCount();
            ArrayBuilder builder = ArrayBuilder.of((int)size);
            IntStream.range(0, size).forEach(i -> builder.add(this.model.getItemFunction().apply(i)));
            this.itemKeys = Index.of((Iterable)builder.toArray());
        }
    }

    @Override
    public Iterable<X> keys() {
        return this.model.keys();
    }

    @Override
    public final boolean isEmpty() {
        return this.model.isEmpty();
    }

    @Override
    public void clear(boolean notify) {
        this.model.clear(notify);
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    @Override
    public void apply(DataFrame<X, S> frame) {
        this.model.apply(frame);
        this.updateItemKeys();
    }

    @Override
    public void apply(DataFrame<X, S> frame, S valueKey) {
        this.model.apply(frame, valueKey);
        this.updateItemKeys();
    }

    @Override
    public void apply(DataFrame<?, S> frame, S itemKey, S valueKey) {
        this.model.apply(frame, itemKey, valueKey);
        this.updateItemKeys();
    }

    public final int getItemCount() {
        return this.isEmpty() ? 0 : this.model.getFrame().rowCount();
    }

    public final List getKeys() {
        return this.isEmpty() ? Collections.emptyList() : this.itemKeys.toList();
    }

    public final Comparable getKey(int index) {
        return this.isEmpty() ? null : (Comparable)this.itemKeys.getKey(index);
    }

    public final int getIndex(Comparable itemKey) {
        return this.isEmpty() ? -1 : this.itemKeys.getOrdinalForKey((Object)itemKey);
    }

    public final Number getValue(Comparable itemKey) {
        if (this.isEmpty()) {
            return null;
        }
        int ordinal = this.itemKeys.getIndexForKey((Object)itemKey);
        return this.model.getValueFunction().applyAsDouble(ordinal);
    }

    public final Number getValue(int index) {
        if (this.isEmpty()) {
            return null;
        }
        return this.model.getValueFunction().applyAsDouble(index);
    }
}

