/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.viz.chart.pie.PieLabels;
import com.zavtech.morpheus.viz.chart.pie.PieModel;
import com.zavtech.morpheus.viz.chart.pie.PiePlot;
import com.zavtech.morpheus.viz.chart.pie.PieSection;
import com.zavtech.morpheus.viz.html.HtmlCode;
import com.zavtech.morpheus.viz.jfree.JFPieModel;
import com.zavtech.morpheus.viz.util.ColorModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.RingPlot;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleInsets;

class JFPiePlot<X extends Comparable, S extends Comparable>
implements PiePlot<X, S> {
    private ColorModel colorModel;
    private org.jfree.chart.plot.PiePlot plot;
    private Color sectionOutlineColor = Color.WHITE;
    private Stroke sectionOutlineStroke = new BasicStroke(1.0f);
    private JFPieModel<X, S> model = new JFPieModel();
    private Map<X, PieSection> sectionMap = new HashMap<X, PieSection>();
    private MorpheusPieLabels labels = new MorpheusPieLabels();

    JFPiePlot(boolean is3d) {
        this.plot = is3d ? new MorpheusPiePlot3D() : new MorpheusPiePlot2D();
        this.plot.setDataset(this.model);
        this.colorModel = ColorModel.DEFAULT.get();
        this.plot.setSectionOutlinesVisible(true);
        this.plot.setOutlineVisible(false);
        this.plot.setIgnoreNullValues(true);
        this.plot.setIgnoreZeroValues(true);
        this.plot.setAutoPopulateSectionPaint(true);
        this.plot.setBaseSectionOutlinePaint((Paint)this.sectionOutlineColor);
        this.plot.setBaseSectionOutlineStroke(this.sectionOutlineStroke);
        this.plot.setLabelPadding(new RectangleInsets(2.0, 10.0, 2.0, 10.0));
        this.plot.setInteriorGap(0.02);
        this.plot.setStartAngle(0.0);
        this.plot.setSimpleLabels(true);
        this.plot.setToolTipGenerator(this::toolTip);
        this.plot.setStartAngle(90.0);
        this.labels().on().withPercent();
        if (this.plot instanceof RingPlot) {
            ((RingPlot)this.plot).setSectionDepth(1.0);
            ((RingPlot)this.plot).setSeparatorsVisible(false);
        } else if (this.plot instanceof PiePlot3D) {
            ((PiePlot3D)this.plot).setDepthFactor(0.2);
        }
    }

    @Override
    public PieModel<X, S> data() {
        return this.model;
    }

    @Override
    public PieLabels labels() {
        return this.labels;
    }

    @Override
    public PieSection section(X itemKey) {
        PieSection section = this.sectionMap.get(itemKey);
        if (section == null) {
            section = new MorpheusPieSection(this, itemKey);
            this.sectionMap.put(itemKey, section);
        }
        return section;
    }

    @Override
    public PiePlot<X, S> withStartAngle(double degrees) {
        this.plot.setStartAngle(90.0 - degrees);
        return this;
    }

    @Override
    public PiePlot<X, S> withPieHole(double percent) {
        if (this.plot instanceof RingPlot) {
            ((RingPlot)this.plot).setSectionDepth(1.0 - percent);
        }
        return this;
    }

    @Override
    public PiePlot<X, S> withSectionOutlineColor(Color color) {
        this.sectionOutlineColor = color;
        this.plot.setBaseSectionOutlinePaint((Paint)color);
        return this;
    }

    void toggle(Comparable itemKey) {
    }

    void highlight(Comparable itemKey) {
        try {
            this.model.keys().forEach(key -> {
                if (itemKey.equals(key)) {
                    this.plot.setSectionOutlineStroke(key, (Stroke)new BasicStroke(1.5f));
                    this.plot.setSectionOutlinePaint(key, (Paint)Color.BLACK);
                } else {
                    this.plot.setSectionOutlineStroke(key, this.sectionOutlineStroke);
                    this.plot.setSectionOutlinePaint(key, (Paint)this.sectionOutlineColor);
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private String toolTip(PieDataset dataset, Comparable key) {
        try {
            double value = Optional.ofNullable(dataset.getValue(key)).map(Number::doubleValue).orElse(Double.NaN);
            if (!Double.isNaN(value)) {
                return HtmlCode.createHtml(writer -> writer.newElement("html", html -> {
                    double total = DatasetUtilities.calculatePieDatasetTotal((PieDataset)dataset);
                    double percent = value / total;
                    StringBuilder text = new StringBuilder();
                    text.append(this.labels.valueFormat.format(value));
                    text.append("  (");
                    text.append(this.labels.percentFormat.format(percent));
                    text.append(")");
                    html.newElement("h2", h2 -> h2.text(key.toString()));
                    html.newElement("h3", h3 -> h3.text(text.toString()));
                }));
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    org.jfree.chart.plot.PiePlot underlying() {
        return this.plot;
    }

    private class MorpheusPieSectionLabelGenerator
    implements PieSectionLabelGenerator {
        private MorpheusPieSectionLabelGenerator() {
        }

        public String generateSectionLabel(PieDataset dataset, Comparable key) {
            try {
                if (JFPiePlot.this.labels.labelType == LabelType.NAME) {
                    return key.toString();
                }
                if (JFPiePlot.this.labels.labelType == LabelType.VALUE) {
                    double value = Optional.ofNullable(dataset.getValue(key)).map(Number::doubleValue).orElse(Double.NaN);
                    return Double.isNaN(value) ? "" : JFPiePlot.this.labels.valueFormat.format(value);
                }
                if (JFPiePlot.this.labels.labelType == LabelType.PERCENT) {
                    double value = Optional.ofNullable(dataset.getValue(key)).map(Number::doubleValue).orElse(Double.NaN);
                    double total = DatasetUtilities.calculatePieDatasetTotal((PieDataset)dataset);
                    double percent = value / total;
                    return JFPiePlot.this.labels.percentFormat.format(percent);
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }

        public AttributedString generateAttributedSectionLabel(PieDataset dataset, Comparable key) {
            return null;
        }
    }

    private class MorpheusPiePlot3D
    extends PiePlot3D {
        private MorpheusPiePlot3D() {
        }

        protected Paint lookupSectionPaint(Comparable key, boolean autoPopulate) {
            return this.getColor(key);
        }

        public Paint getSectionPaint(Comparable key) {
            return this.getColor(key);
        }

        private Paint getColor(Comparable key) {
            try {
                PieDataset dataset = this.getDataset();
                if (dataset != null) {
                    MorpheusPieSection section = (MorpheusPieSection)JFPiePlot.this.section(key);
                    return section.color != null ? section.color : JFPiePlot.this.colorModel.getColor(key);
                }
                return super.getSectionPaint(key);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSectionPaint(key);
            }
        }
    }

    private class MorpheusPiePlot2D
    extends RingPlot {
        private MorpheusPiePlot2D() {
        }

        protected Paint lookupSectionPaint(Comparable key, boolean autoPopulate) {
            return this.getColor(key);
        }

        public Paint getSectionPaint(Comparable key) {
            return this.getColor(key);
        }

        private Paint getColor(Comparable key) {
            try {
                PieDataset dataset = this.getDataset();
                if (dataset != null) {
                    MorpheusPieSection section = (MorpheusPieSection)JFPiePlot.this.section(key);
                    return section.color != null ? section.color : JFPiePlot.this.colorModel.getColor(key);
                }
                return super.getSectionPaint(key);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSectionPaint(key);
            }
        }
    }

    private static class MorpheusPieSection
    implements PieSection {
        private X itemKey;
        private Color color;
        final /* synthetic */ JFPiePlot this$0;

        MorpheusPieSection(X itemKey) {
            this.this$0 = var1_1;
            this.itemKey = itemKey;
        }

        @Override
        public PieSection withColor(Color color) {
            this.color = color;
            return this;
        }

        @Override
        public PieSection withOffset(double offset) {
            this.this$0.plot.setExplodePercent(this.itemKey, offset);
            return this;
        }
    }

    private class MorpheusPieLabels
    implements PieLabels {
        private LabelType labelType = LabelType.PERCENT;
        private DecimalFormat valueFormat = new DecimalFormat("###,##0.##;-###,##0.##");
        private DecimalFormat percentFormat = new DecimalFormat("0.##'%';-0.##'%'");

        MorpheusPieLabels() {
            this.percentFormat.setMultiplier(100);
        }

        @Override
        public PieLabels off() {
            JFPiePlot.this.plot.setLabelGenerator(null);
            return this;
        }

        @Override
        public PieLabels on() {
            JFPiePlot.this.plot.setLabelGenerator((PieSectionLabelGenerator)new MorpheusPieSectionLabelGenerator());
            return this;
        }

        @Override
        public PieLabels withName() {
            this.labelType = LabelType.NAME;
            return this;
        }

        @Override
        public PieLabels withValue() {
            this.labelType = LabelType.VALUE;
            return this;
        }

        @Override
        public PieLabels withPercent() {
            this.labelType = LabelType.PERCENT;
            return this;
        }

        @Override
        public PieLabels withFont(Font font) {
            JFPiePlot.this.plot.setLabelFont(font);
            return this;
        }

        @Override
        public PieLabels withTextColor(Color color) {
            JFPiePlot.this.plot.setLabelPaint((Paint)color);
            return this;
        }

        @Override
        public PieLabels withBackgroundColor(Color color) {
            JFPiePlot.this.plot.setLabelBackgroundPaint((Paint)color);
            return this;
        }
    }

    private static enum LabelType {
        NAME,
        VALUE,
        PERCENT;

    }
}

