/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.util.Bounds;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.ChartFormat;
import com.zavtech.morpheus.viz.chart.ChartLabel;
import com.zavtech.morpheus.viz.chart.ChartTextStyle;
import com.zavtech.morpheus.viz.chart.xy.XyAxes;
import com.zavtech.morpheus.viz.chart.xy.XyAxis;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.LogAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

class JFXyAxes
implements XyAxes {
    private Plot plot;

    JFXyAxes(Plot plot) {
        this.plot = plot;
    }

    @Override
    public XyAxis domain() {
        if (this.plot instanceof XYPlot) {
            return new AxisAdapter((Axis)((XYPlot)this.plot).getDomainAxis(), 0, true);
        }
        if (this.plot instanceof CategoryPlot) {
            return new AxisAdapter((Axis)((CategoryPlot)this.plot).getDomainAxis(), 0, true);
        }
        throw new ChartException("Unsupported plot type for this adapter: " + this.plot);
    }

    @Override
    public XyAxis range(int index) {
        Axis axis = this.getRangeAxis(index);
        if (axis != null) {
            return new AxisAdapter(axis, index, false);
        }
        NumberAxis newAxis = new NumberAxis();
        if (this.plot instanceof XYPlot) {
            ((XYPlot)this.plot).setRangeAxis(index, (ValueAxis)newAxis);
            return new AxisAdapter((Axis)newAxis, index, false);
        }
        if (this.plot instanceof CategoryPlot) {
            ((CategoryPlot)this.plot).setRangeAxis(index, (ValueAxis)newAxis);
            return new AxisAdapter((Axis)newAxis, index, false);
        }
        throw new ChartException("Unsupported plot type for this adapter: " + this.plot);
    }

    private Axis getRangeAxis(int index) {
        if (this.plot instanceof XYPlot) {
            return ((XYPlot)this.plot).getRangeAxis(index);
        }
        if (this.plot instanceof CategoryPlot) {
            return ((CategoryPlot)this.plot).getRangeAxis(index);
        }
        throw new ChartException("Unsupported plot type for this adapter: " + this.plot);
    }

    private class AxisStyleAdapter
    implements ChartTextStyle {
        private Axis axis;

        private AxisStyleAdapter(Axis axis) {
            this.axis = axis;
        }

        @Override
        public ChartTextStyle withColor(Color color) {
            this.axis.setAxisLinePaint((Paint)color);
            this.axis.setTickLabelPaint((Paint)color);
            return this;
        }

        @Override
        public ChartTextStyle withFont(Font font) {
            this.axis.setTickLabelFont(font);
            return this;
        }
    }

    private class AxisLabelAdapter
    implements ChartLabel {
        private Axis axis;

        private AxisLabelAdapter(Axis axis) {
            this.axis = axis;
        }

        @Override
        public ChartLabel withText(String text) {
            this.axis.setLabel(text);
            return this;
        }

        @Override
        public ChartLabel withColor(Color color) {
            this.axis.setLabelPaint((Paint)color);
            return this;
        }

        @Override
        public ChartLabel withFont(Font font) {
            this.axis.setLabelFont(font);
            return this;
        }
    }

    private class AxisFormatAdapter
    implements ChartFormat {
        private Axis axis;

        private AxisFormatAdapter(Axis axis) {
            this.axis = axis;
        }

        @Override
        public void withPattern(String pattern) {
            if (this.axis instanceof NumberAxis) {
                ((NumberAxis)this.axis).setNumberFormatOverride((NumberFormat)new DecimalFormat(pattern));
            } else if (this.axis instanceof LogAxis) {
                ((LogAxis)this.axis).setNumberFormatOverride((NumberFormat)new DecimalFormat(pattern));
            } else if (this.axis instanceof DateAxis) {
                ((DateAxis)this.axis).setDateFormatOverride((DateFormat)new SimpleDateFormat(pattern));
            }
        }
    }

    private class AxisAdapter
    implements XyAxis {
        private Axis axis;
        private int index;
        private boolean domain;
        private Bounds<?> range;

        private AxisAdapter(Axis axis, int index, boolean domain) {
            this.axis = axis;
            this.index = index;
            this.domain = domain;
        }

        @Override
        public ChartLabel label() {
            return new AxisLabelAdapter(this.axis);
        }

        @Override
        public ChartFormat format() {
            return new AxisFormatAdapter(this.axis);
        }

        @Override
        public ChartTextStyle ticks() {
            return new AxisStyleAdapter(this.axis);
        }

        @Override
        public XyAxis asLogScale() {
            if (this.axis instanceof CategoryAxis) {
                throw new ChartException("Cannot convert discrete axis to continuous axis");
            }
            if (!(this.axis instanceof LogAxis)) {
                String label = this.axis.getLabel();
                LogAxis logAxis = new LogAxis(label);
                logAxis.setLabelFont(this.axis.getLabelFont());
                logAxis.setTickLabelFont(this.axis.getTickLabelFont());
                logAxis.setLabelPaint(this.axis.getLabelPaint());
                logAxis.setTickLabelPaint(this.axis.getTickLabelPaint());
                this.axis = logAxis;
                if (this.range != null) {
                    this.withRange(this.range);
                }
                if (this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setDomainAxis(this.index, (ValueAxis)logAxis);
                } else if (!this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)logAxis);
                } else if (JFXyAxes.this.plot instanceof CategoryPlot) {
                    ((CategoryPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)logAxis, true);
                } else {
                    throw new ChartException("Unsupported plot type for log scale: " + JFXyAxes.this.plot);
                }
            }
            return this;
        }

        @Override
        public XyAxis asLinearScale() {
            if (this.axis instanceof CategoryAxis) {
                throw new ChartException("Cannot convert discrete axis to continuous axis");
            }
            if (!(this.axis instanceof NumberAxis)) {
                String label = this.axis.getLabel();
                NumberAxis linearAxis = new NumberAxis(label);
                linearAxis.setLabelFont(this.axis.getLabelFont());
                linearAxis.setTickLabelFont(this.axis.getTickLabelFont());
                linearAxis.setLabelPaint(this.axis.getLabelPaint());
                linearAxis.setTickLabelPaint(this.axis.getTickLabelPaint());
                this.axis = linearAxis;
                if (this.range != null) {
                    this.withRange(this.range);
                }
                if (this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setDomainAxis(this.index, (ValueAxis)linearAxis);
                } else if (!this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)linearAxis);
                } else if (JFXyAxes.this.plot instanceof CategoryPlot) {
                    ((CategoryPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)linearAxis);
                } else {
                    throw new ChartException("Unsupported plot type for log scale: " + JFXyAxes.this.plot);
                }
            }
            return this;
        }

        @Override
        public XyAxis asDateScale() {
            if (this.axis instanceof CategoryAxis) {
                throw new ChartException("Cannot convert discrete axis to continuous axis");
            }
            if (!(this.axis instanceof NumberAxis)) {
                String label = this.axis.getLabel();
                DateAxis dateAxis = new DateAxis(label);
                dateAxis.setLabelFont(this.axis.getLabelFont());
                dateAxis.setTickLabelFont(this.axis.getTickLabelFont());
                dateAxis.setLabelPaint(this.axis.getLabelPaint());
                dateAxis.setTickLabelPaint(this.axis.getTickLabelPaint());
                this.axis = dateAxis;
                if (this.range != null) {
                    this.withRange(this.range);
                }
                if (this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setDomainAxis(this.index, (ValueAxis)dateAxis);
                } else if (!this.domain && JFXyAxes.this.plot instanceof XYPlot) {
                    ((XYPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)dateAxis);
                } else if (JFXyAxes.this.plot instanceof CategoryPlot) {
                    ((CategoryPlot)JFXyAxes.this.plot).setRangeAxis(this.index, (ValueAxis)dateAxis);
                } else {
                    throw new ChartException("Unsupported plot type for log scale: " + JFXyAxes.this.plot);
                }
            }
            return this;
        }

        @Override
        public XyAxis withRange(Bounds<?> range) {
            this.range = range;
            if (this.axis != null) {
                if (this.axis instanceof NumberAxis) {
                    NumberAxis numberAxis = (NumberAxis)this.axis;
                    double lower = ((Number)range.lower()).doubleValue();
                    double upper = ((Number)range.upper()).doubleValue();
                    Range autoRange = new Range(lower, upper);
                    numberAxis.setDefaultAutoRange(autoRange);
                    numberAxis.setRange(lower, upper);
                } else if (this.axis instanceof DateAxis) {
                    DateAxis dateAxis = (DateAxis)this.axis;
                    long lower = this.toEpochMillis(range.lower());
                    long upper = this.toEpochMillis(range.upper());
                    Range autoRange = new Range((double)lower, (double)upper);
                    dateAxis.setDefaultAutoRange(autoRange);
                } else {
                    throw new IllegalStateException("Can only set range of numeric or date axis");
                }
            }
            return this;
        }

        private long toEpochMillis(Object value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof Date) {
                return ((Date)value).getTime();
            }
            if (value instanceof LocalDate) {
                LocalDate date = (LocalDate)value;
                LocalDateTime localDateTime = LocalDateTime.of(date, LocalTime.MIDNIGHT);
                return localDateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
            }
            throw new IllegalArgumentException("Cannot resolve date value from " + value);
        }
    }
}

