/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.array.Array;
import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYZDataset;

class JFXyDataset<X extends Comparable, S extends Comparable>
extends AbstractXYDataset
implements XyDataset<X, S>,
IntervalXYDataset,
TableXYDataset,
XYZDataset {
    private static final Double NAN = Double.NaN;
    private DataFrame<?, S> frame;
    private Array<Integer> colOrdinals;
    private Supplier<Class<X>> domainType;
    private IntFunction<X> domainValueFunction;
    private Consumer<JFXyDataset<X, S>> refreshHandler;
    private Function<X, X> lowerDomainIntervalFunction;
    private Function<X, X> upperDomainIntervalFunction;

    private JFXyDataset(Consumer<JFXyDataset<X, S>> refreshHandler) {
        this.refreshHandler = refreshHandler;
        this.refresh();
    }

    static <X extends Comparable, S extends Comparable> JFXyDataset<X, S> of(Supplier<DataFrame<X, S>> frameSupplier) {
        return new JFXyDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    Supplier domainType = () -> frame.rows().keyType();
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).toArray());
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.rows().key(rowIndex));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    static <X extends Comparable, S extends Comparable> JFXyDataset<X, S> of(S domainAxisKey, Supplier<DataFrame<?, S>> frameSupplier) {
        return new JFXyDataset<X, S>(dataset -> {
            try {
                DataFrame frame = (DataFrame)frameSupplier.get();
                if (frame != null) {
                    int domainAxisColOrdinal = frame.cols().ordinalOf((Object)domainAxisKey);
                    Supplier domainType = () -> frame.cols().type((Object)domainAxisKey);
                    Array colOrdinals = Array.of((int[])IntStream.range(0, frame.colCount()).filter(i -> i != domainAxisColOrdinal).toArray());
                    dataset.update(frame, (Array<Integer>)colOrdinals, domainType, rowIndex -> (Comparable)frame.data().getValue(rowIndex, domainAxisColOrdinal));
                } else {
                    dataset.clear(true);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(DataFrame<?, S> frame, Array<Integer> colOrdinals, Supplier<Class<X>> domainType, IntFunction<X> domainValueFunction) {
        try {
            this.frame = frame;
            this.domainType = domainType;
            this.colOrdinals = colOrdinals;
            this.domainValueFunction = domainValueFunction;
        }
        finally {
            this.fireDatasetChanged();
        }
    }

    @Override
    public void refresh() {
        this.refreshHandler.accept(this);
    }

    @Override
    public final boolean isEmpty() {
        return this.frame == null || this.frame.rowCount() == 0 || this.colOrdinals == null || this.colOrdinals.length() == 0;
    }

    @Override
    public final void clear(boolean notify) {
        this.frame = null;
        this.colOrdinals = null;
        if (notify) {
            this.fireDatasetChanged();
        }
    }

    @Override
    public Class<X> domainType() {
        return this.isEmpty() ? null : this.domainType.get();
    }

    @Override
    public final <R> DataFrame<R, S> frame() {
        return this.frame;
    }

    @Override
    public final IntFunction<X> domainFunction() {
        return this.domainValueFunction;
    }

    @Override
    public final boolean contains(S seriesKey) {
        return !this.isEmpty() && this.frame.cols().contains(seriesKey);
    }

    @Override
    public final XyDataset<X, S> withLowerDomainInterval(Function<X, X> lowerIntervalFunction) {
        this.lowerDomainIntervalFunction = lowerIntervalFunction;
        return this;
    }

    @Override
    public final XyDataset<X, S> withUpperDomainInterval(Function<X, X> upperIntervalFunction) {
        this.upperDomainIntervalFunction = upperIntervalFunction;
        return null;
    }

    public final int getItemCount() {
        return this.isEmpty() ? 0 : this.frame.rowCount();
    }

    public final int getSeriesCount() {
        return this.isEmpty() ? 0 : this.colOrdinals.length();
    }

    public final S getSeriesKey(int series) {
        if (this.isEmpty()) {
            return null;
        }
        int colOrdinal = this.colOrdinals.getInt(series);
        return (S)((Comparable)this.frame.cols().key(colOrdinal));
    }

    public final int getItemCount(int series) {
        return this.isEmpty() ? 0 : this.frame.rowCount();
    }

    public final Number getZ(int series, int item) {
        return null;
    }

    public final double getZValue(int series, int item) {
        return 0.0;
    }

    public final Number getX(int series, int item) {
        double value = this.getXValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public final Number getY(int series, int item) {
        double value = this.getYValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public final Number getStartX(int series, int item) {
        double value = this.getStartXValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public final Number getEndX(int series, int item) {
        double value = this.getEndXValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public final Number getStartY(int series, int item) {
        double value = this.getStartYValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public Number getEndY(int series, int item) {
        double value = this.getEndYValue(series, item);
        return Double.isNaN(value) ? NAN : value;
    }

    public final double getXValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        Comparable domainValue = (Comparable)this.domainValueFunction.apply(item);
        return this.toNumber(domainValue).doubleValue();
    }

    public final double getYValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        int colOrdinal = this.colOrdinals.getInt(series);
        return this.frame.data().getDouble(item, colOrdinal);
    }

    public final double getStartXValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        Comparable domainValue = (Comparable)this.domainValueFunction.apply(item);
        if (this.lowerDomainIntervalFunction != null) {
            Comparable startValueKey = (Comparable)this.lowerDomainIntervalFunction.apply(domainValue);
            Number startValue = this.toNumber(startValueKey);
            return startValue != null ? startValue.doubleValue() : Double.NaN;
        }
        Number startValue = this.toNumber(domainValue);
        return startValue != null ? startValue.doubleValue() : Double.NaN;
    }

    public final double getEndXValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        Comparable domainValue = (Comparable)this.domainValueFunction.apply(item);
        if (this.upperDomainIntervalFunction != null) {
            Comparable endValueKey = (Comparable)this.upperDomainIntervalFunction.apply(domainValue);
            Number endValue = this.toNumber(endValueKey);
            return endValue != null ? endValue.doubleValue() : Double.NaN;
        }
        Number endValue = this.toNumber(domainValue);
        return endValue != null ? endValue.doubleValue() : Double.NaN;
    }

    public final double getStartYValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        int colOrdinal = this.colOrdinals.getInt(series);
        return this.frame.data().getDouble(item, colOrdinal);
    }

    public final double getEndYValue(int series, int item) {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        int colOrdinal = this.colOrdinals.getInt(series);
        return this.frame.data().getDouble(item, colOrdinal);
    }

    public void fireDatasetChanged() {
        super.fireDatasetChanged();
    }

    private Number toNumber(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            return (Number)value;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof LocalDate) {
            return ((LocalDate)value).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toInstant(ZoneOffset.UTC).toEpochMilli();
        }
        if (value instanceof ZonedDateTime) {
            return ((ZonedDateTime)value).toInstant().toEpochMilli();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        throw new IllegalArgumentException("Unable to convert value to a Number: " + value);
    }
}

