/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.viz.chart.ChartException;
import com.zavtech.morpheus.viz.chart.xy.XyAxes;
import com.zavtech.morpheus.viz.chart.xy.XyDataset;
import com.zavtech.morpheus.viz.chart.xy.XyModel;
import com.zavtech.morpheus.viz.chart.xy.XyOrient;
import com.zavtech.morpheus.viz.chart.xy.XyPlotBase;
import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.chart.xy.XyTrend;
import com.zavtech.morpheus.viz.chart.xy.XyTrendBase;
import com.zavtech.morpheus.viz.html.HtmlCode;
import com.zavtech.morpheus.viz.jfree.JFXyAxes;
import com.zavtech.morpheus.viz.jfree.JFXyDataset;
import com.zavtech.morpheus.viz.jfree.JFXyRender;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;

class JFXyPlot<X extends Comparable>
extends XyPlotBase<X> {
    private XYPlot plot;
    private Map<Comparable, TrendLine> trendMap = new HashMap<Comparable, TrendLine>();
    private Map<Integer, JFXyDataset<X, ? extends Comparable>> datasetMap = new LinkedHashMap<Integer, JFXyDataset<X, ? extends Comparable>>();
    private DecimalFormat decimalFormat = new DecimalFormat("###,##0.####;-###,##0.####");

    JFXyPlot(ValueAxis domainAxis, ValueAxis rangeAxis) {
        this.plot = new XYPlot(null, domainAxis, rangeAxis, null);
        this.plot.getRangeAxis().setAutoRange(true);
        this.plot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        this.plot.setDomainGridlinesVisible(true);
        this.plot.setRangeGridlinesVisible(true);
        this.plot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        this.plot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        this.plot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        if (rangeAxis instanceof NumberAxis) {
            ((NumberAxis)rangeAxis).setAutoRangeIncludesZero(false);
        }
        if (domainAxis instanceof NumberAxis) {
            ((NumberAxis)domainAxis).setAutoRangeIncludesZero(false);
        }
    }

    final XYPlot underlying() {
        return this.plot;
    }

    @Override
    public XyAxes axes() {
        return new JFXyAxes((Plot)this.plot);
    }

    @Override
    public <S extends Comparable> XyModel<X, S> data() {
        return new ModelAdapter();
    }

    @Override
    public XyOrient orient() {
        return new OrientAdapter();
    }

    @Override
    public <S extends Comparable> XyTrend trend(S seriesKey) {
        TrendLine trend = this.trendMap.get(seriesKey);
        if (trend == null) {
            ModelAdapter modelAdapter = new ModelAdapter();
            Stream<JFXyDataset> datasets = modelAdapter.getModels().map(m -> m);
            Optional<JFXyDataset> datasetOpt = datasets.filter(m -> m.contains(seriesKey)).findFirst();
            if (!datasetOpt.isPresent()) {
                throw new ChartException("No chart data could be located for series: " + seriesKey);
            }
            JFXyDataset dataset = datasetOpt.get();
            trend = new TrendLine(dataset, seriesKey);
            this.trendMap.put(seriesKey, trend);
            this.applyTrend(dataset, trend);
        }
        return trend;
    }

    @Override
    public XyRender render(int index) {
        return new JFXyRender(this, index);
    }

    private int getDatasetCount() {
        int count = 0;
        for (int i = 0; i < this.plot.getDatasetCount(); ++i) {
            XYDataset dataSet = this.plot.getDataset(i);
            if (dataSet == null) continue;
            ++count;
        }
        return count;
    }

    private void applyTrend(JFXyDataset<X, Comparable> dataset, TrendLine trend) {
        try {
            this.render(trend.datasetIndex).withLines(false, false);
            this.style(trend.trendKey).withColor(trend.lineColor);
            this.style(trend.trendKey).withLineWidth(trend.lineWidth);
            this.plot.getRenderer(trend.datasetIndex).setBaseSeriesVisibleInLegend(false);
            this.plot.getRenderer(trend.datasetIndex).setBaseToolTipGenerator(this::getTrendTooltip);
            this.plot.setDataset(trend.datasetIndex, JFXyDataset.of(() -> {
                Comparable seriesKey = trend.seriesKey();
                return trend.createTrendData(dataset, seriesKey, trend.trendKey);
            }));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    String getXyTooltip(XYDataset dataset, int series, int item) {
        try {
            Comparable seriesKey = dataset.getSeriesKey(series);
            double x = dataset.getXValue(series, item);
            double y = dataset.getYValue(series, item);
            if (this.plot.getDomainAxis() instanceof DateAxis) {
                DateFormat dateFormat = ((DateAxis)this.plot.getDomainAxis()).getDateFormatOverride();
                DateFormat formatter = dateFormat != null ? dateFormat : new SimpleDateFormat("dd-MMM-yyyy HH:mm");
                String xLabel = formatter.format(new Date((long)x));
                String yLabel = this.decimalFormat.format(y);
                return HtmlCode.createHtml(writer -> writer.newElement("html", html -> {
                    html.newElement("h2", h2 -> h2.text(seriesKey.toString()));
                    html.newElement("h3", h3 -> h3.text(String.format("X = %s, Y = %s", xLabel, yLabel)));
                }));
            }
            String xLabel = this.decimalFormat.format(x);
            String yLabel = this.decimalFormat.format(y);
            return HtmlCode.createHtml(writer -> writer.newElement("html", html -> {
                html.newElement("h2", h2 -> h2.text(seriesKey.toString()));
                html.newElement("h3", h3 -> h3.text(String.format("X = %s, Y = %s", xLabel, yLabel)));
            }));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private String getTrendTooltip(XYDataset dataset, int series, int item) {
        try {
            String seriesKey = dataset.getSeriesKey(series).toString().replace(" (trend)", "");
            TrendLine trend = this.trendMap.get(seriesKey);
            if (trend == null) {
                return null;
            }
            String slope = this.decimalFormat.format(trend.slope());
            String intercept = this.decimalFormat.format(trend.intercept());
            String equation = String.format("Y = %s * X + %s", slope, intercept);
            return HtmlCode.createHtml(arg_0 -> JFXyPlot.lambda$getTrendTooltip$121((Comparable)((Object)seriesKey), equation, arg_0));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static /* synthetic */ void lambda$getTrendTooltip$121(Comparable seriesKey, String equation, HtmlCode writer) {
        writer.newElement("html", html -> {
            html.newElement("h2", h2 -> h2.text(seriesKey.toString()));
            html.newElement("h3", h3 -> h3.text(equation));
        });
    }

    private class ModelAdapter<S extends Comparable>
    implements XyModel<X, S> {
        private ModelAdapter() {
        }

        private Stream<JFXyDataset<X, ? extends Comparable>> getModels() {
            return JFXyPlot.this.datasetMap.values().stream();
        }

        @Override
        public Class<X> domainType() {
            if (JFXyPlot.this.datasetMap.isEmpty()) {
                return null;
            }
            return ((JFXyDataset)JFXyPlot.this.datasetMap.entrySet().iterator().next().getValue()).domainType();
        }

        @Override
        public XyDataset<X, S> at(int index) {
            JFXyDataset dataset = (JFXyDataset)JFXyPlot.this.datasetMap.get(index);
            if (dataset != null) {
                return dataset;
            }
            throw new IllegalArgumentException("No chart data located at index: " + index);
        }

        @Override
        public void setRangeAxis(int dataset, int axis) {
            ValueAxis rangeAxis = JFXyPlot.this.plot.getRangeAxis(axis);
            if (rangeAxis == null) {
                JFXyPlot.this.plot.setRangeAxis(axis, (ValueAxis)new NumberAxis());
                JFXyPlot.this.plot.mapDatasetToRangeAxis(dataset, axis);
            } else {
                JFXyPlot.this.plot.mapDatasetToRangeAxis(dataset, axis);
            }
        }

        @Override
        public int add(DataFrame<X, S> frame) {
            int index = JFXyPlot.this.getDatasetCount();
            JFXyDataset dataset = JFXyDataset.of(() -> frame);
            JFXyPlot.this.datasetMap.put(index, dataset);
            JFXyPlot.this.plot.setDataset(index, dataset);
            JFXyPlot.this.render(index).withLines(false, false);
            return index;
        }

        @Override
        public int add(DataFrame<?, S> frame, S domainKey) {
            int index = JFXyPlot.this.getDatasetCount();
            JFXyDataset dataset = JFXyDataset.of(domainKey, () -> frame);
            JFXyPlot.this.datasetMap.put(index, dataset);
            JFXyPlot.this.plot.setDataset(index, dataset);
            JFXyPlot.this.render(index).withLines(false, false);
            return index;
        }

        @Override
        public XyDataset<X, S> update(int index, DataFrame<X, S> frame) {
            JFXyDataset dataset = JFXyDataset.of(() -> frame);
            JFXyPlot.this.datasetMap.put(index, dataset);
            JFXyPlot.this.plot.setDataset(index, dataset);
            return dataset;
        }

        @Override
        public XyDataset<X, S> update(int index, DataFrame<?, S> frame, S domainKey) {
            JFXyDataset dataset = JFXyDataset.of(domainKey, () -> frame);
            JFXyPlot.this.datasetMap.put(index, dataset);
            JFXyPlot.this.plot.setDataset(index, dataset);
            return dataset;
        }

        @Override
        public void remove(int index) {
            JFXyDataset dataset = (JFXyDataset)JFXyPlot.this.datasetMap.remove(index);
            if (dataset == null) {
                throw new ChartException("No chart dataset exists for id: " + index);
            }
            JFXyPlot.this.plot.setDataset(index, null);
        }

        @Override
        public void removeAll() {
            int count = JFXyPlot.this.plot.getDatasetCount();
            JFXyPlot.this.datasetMap.clear();
            for (int i = 0; i < count; ++i) {
                JFXyPlot.this.plot.setDataset(i, null);
            }
        }
    }

    private class TrendLine
    extends XyTrendBase {
        private Color lineColor;
        private float lineWidth;
        private int datasetIndex;
        private Comparable trendKey;

        TrendLine(JFXyDataset<X, Comparable> source, Comparable seriesKey) {
            super(seriesKey);
            this.lineWidth = 2.0f;
            this.lineColor = Color.BLACK;
            this.datasetIndex = JFXyPlot.this.getDatasetCount();
            this.trendKey = String.format("%s (trend)", seriesKey);
        }

        @Override
        public XyTrend withColor(Color color) {
            this.lineColor = color;
            JFXyPlot.this.style(this.trendKey).withColor(color);
            return this;
        }

        @Override
        public XyTrend withLineWidth(float width) {
            this.lineWidth = width;
            JFXyPlot.this.style(this.trendKey).withLineWidth(width);
            return this;
        }

        @Override
        public XyTrend clear() {
            Comparable seriesKey = this.seriesKey();
            JFXyPlot.this.plot.setDataset(this.datasetIndex, null);
            JFXyPlot.this.trendMap.remove(seriesKey);
            return this;
        }
    }

    private class OrientAdapter
    implements XyOrient {
        private OrientAdapter() {
        }

        @Override
        public void vertical() {
            JFXyPlot.this.plot.setOrientation(PlotOrientation.VERTICAL);
        }

        @Override
        public void horizontal() {
            JFXyPlot.this.plot.setOrientation(PlotOrientation.HORIZONTAL);
        }
    }
}

