/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.jfree;

import com.zavtech.morpheus.viz.chart.ChartShape;
import com.zavtech.morpheus.viz.chart.xy.XyRender;
import com.zavtech.morpheus.viz.jfree.JFChartShapes;
import com.zavtech.morpheus.viz.jfree.JFXyPlot;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.StandardXYBarPainter;
import org.jfree.chart.renderer.xy.XYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYBarPainter;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.xy.XYDataset;

class JFXyRender
implements XyRender {
    private int index;
    private JFXyPlot<?> plot;

    JFXyRender(JFXyPlot<?> plot, int index) {
        this.plot = plot;
        this.index = index;
    }

    @Override
    public void withDots() {
        this.withDots(4);
    }

    @Override
    public void withDots(int diameter) {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)new MorpheusDotRenderer(this.index, diameter));
    }

    @Override
    public void withShapes() {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)new MorpheusLineAndShapeRenderer(false, true, this.index, false));
    }

    @Override
    public void withArea(boolean stacked) {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)(stacked ? new MorpheusStackedAreaRenderer(this.index) : new MorpheusAreaRenderer(this.index)));
    }

    @Override
    public void withLines(boolean shapes, boolean dashed) {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)new MorpheusLineAndShapeRenderer(true, shapes, this.index, dashed));
    }

    @Override
    public void withSpline(boolean shapes, boolean dashed) {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)new MorpheusSplineRenderer(shapes, 5, this.index, dashed));
    }

    @Override
    public void withBars(boolean stacked, double margin) {
        this.plot.underlying().setRenderer(this.index, (XYItemRenderer)(stacked ? new MorpheusStackedBarRenderer(margin, this.index) : new MorpheusBarRenderer(this.index)));
    }

    private class MorpheusStackedAreaRenderer
    extends StackedXYAreaRenderer2 {
        private int datasetIndex;

        MorpheusStackedAreaRenderer(int datasetIndex) {
            this.datasetIndex = datasetIndex;
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusAreaRenderer
    extends XYAreaRenderer2 {
        private int datasetIndex;

        MorpheusAreaRenderer(int datasetIndex) {
            this.datasetIndex = datasetIndex;
            this.setOutline(false);
            this.setBaseCreateEntities(false);
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusDotRenderer
    extends XYLineAndShapeRenderer {
        private int datasetIndex;
        private Shape dotShape;

        MorpheusDotRenderer(int datasetIndex, int diameter) {
            this.datasetIndex = datasetIndex;
            this.dotShape = new Ellipse2D.Double(-2.0, -2.0, diameter, diameter);
            this.setBaseShape(this.dotShape);
            this.setBaseLinesVisible(false);
            this.setBaseShapesVisible(true);
            this.setBaseToolTipGenerator(JFXyRender.this.plot::getXyTooltip);
        }

        public Shape getSeriesShape(int series) {
            return this.dotShape;
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusStackedBarRenderer
    extends StackedXYBarRenderer {
        private int datasetIndex;

        MorpheusStackedBarRenderer(double margin, int datasetIndex) {
            super(margin);
            this.datasetIndex = datasetIndex;
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setDrawBarOutline(true);
            this.setShadowVisible(false);
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusBarRenderer
    extends XYBarRenderer {
        private int datasetIndex;

        MorpheusBarRenderer(int datasetIndex) {
            this.datasetIndex = datasetIndex;
            this.setBarPainter((XYBarPainter)new StandardXYBarPainter());
            this.setDrawBarOutline(true);
            this.setShadowVisible(false);
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }
    }

    private class MorpheusSplineRenderer
    extends XYSplineRenderer {
        private int datasetIndex;
        private JFChartShapes shapes;

        MorpheusSplineRenderer(boolean shapes, int precision, int datasetIndex, boolean dotted) {
            super(precision);
            this.shapes = new JFChartShapes();
            this.setBaseShapesVisible(shapes);
            this.datasetIndex = datasetIndex;
            if (dotted) {
                this.setBaseStroke(new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            }
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }

        public Stroke getSeriesStroke(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Float lineWidth = JFXyRender.this.plot.getSeriesLineWidth(seriesKey);
                    Boolean dashed = JFXyRender.this.plot.isSeriesDashedLine(seriesKey);
                    if (dashed != null && dashed.booleanValue()) {
                        float[] dash = new float[]{2.0f, 6.0f};
                        float width = !Float.isNaN(lineWidth.floatValue()) ? lineWidth.floatValue() : 1.0f;
                        return new BasicStroke(width, 1, 1, 1.0f, dash, 0.0f);
                    }
                    return lineWidth != null && !Float.isNaN(lineWidth.floatValue()) ? new BasicStroke(lineWidth.floatValue()) : super.getSeriesStroke(series);
                }
                return super.getSeriesStroke(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesStroke(series);
            }
        }

        public Boolean getSeriesShapesVisible(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Boolean visible = JFXyRender.this.plot.isSeriesPointsVisible(seriesKey);
                    return visible != null ? visible : super.getSeriesShapesVisible(series);
                }
                return super.getSeriesShapesVisible(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesShapesVisible(series);
            }
        }

        public Boolean getSeriesLinesVisible(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Float lineWidth = JFXyRender.this.plot.getSeriesLineWidth(seriesKey);
                    if (lineWidth != null && lineWidth.floatValue() == 0.0f) {
                        return false;
                    }
                }
                return super.getSeriesLinesVisible(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesLinesVisible(series);
            }
        }

        public Shape getSeriesShape(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Shape shape;
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    ChartShape pointShape = JFXyRender.this.plot.getSeriesPointShape(seriesKey);
                    if (pointShape != null && (shape = this.shapes.getShape(pointShape)) != null) {
                        return shape;
                    }
                }
                return super.getSeriesShape(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesShape(series);
            }
        }
    }

    private class MorpheusLineAndShapeRenderer
    extends XYLineAndShapeRenderer {
        private int datasetIndex;
        private JFChartShapes shapes;

        MorpheusLineAndShapeRenderer(boolean lines, boolean shapes, int datasetIndex, boolean dotted) {
            super(lines, shapes);
            this.shapes = new JFChartShapes();
            this.datasetIndex = datasetIndex;
            if (dotted) {
                this.setBaseStroke(new BasicStroke(2.0f, 1, 1, 1.0f, new float[]{2.0f, 6.0f}, 0.0f));
            }
            if (!lines && shapes) {
                this.setDrawOutlines(true);
                this.setUseOutlinePaint(true);
                this.setBaseOutlinePaint(Color.GRAY);
            }
        }

        public Paint getSeriesPaint(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Color color = JFXyRender.this.plot.getSeriesColor(seriesKey);
                    return color != null ? color : JFXyRender.this.plot.getColorModel().getColor(seriesKey);
                }
                return super.getSeriesPaint(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesPaint(series);
            }
        }

        public Stroke getSeriesStroke(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Float lineWidth = JFXyRender.this.plot.getSeriesLineWidth(seriesKey);
                    Boolean dashed = JFXyRender.this.plot.isSeriesDashedLine(seriesKey);
                    if (dashed != null && dashed.booleanValue()) {
                        float[] dash = new float[]{2.0f, 6.0f};
                        float width = lineWidth != null && !Float.isNaN(lineWidth.floatValue()) ? lineWidth.floatValue() : 1.0f;
                        return new BasicStroke(width, 1, 1, 1.0f, dash, 0.0f);
                    }
                    return lineWidth != null && !Float.isNaN(lineWidth.floatValue()) ? new BasicStroke(lineWidth.floatValue()) : super.getBaseStroke();
                }
                return super.getSeriesStroke(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesStroke(series);
            }
        }

        public Boolean getSeriesShapesVisible(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Boolean visible = JFXyRender.this.plot.isSeriesPointsVisible(seriesKey);
                    return visible != null ? visible : super.getSeriesShapesVisible(series);
                }
                return super.getSeriesShapesVisible(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesShapesVisible(series);
            }
        }

        public Boolean getSeriesLinesVisible(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    Float lineWidth = JFXyRender.this.plot.getSeriesLineWidth(seriesKey);
                    if (lineWidth != null && lineWidth.floatValue() == 0.0f) {
                        return false;
                    }
                }
                return super.getSeriesLinesVisible(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesLinesVisible(series);
            }
        }

        public Shape getSeriesShape(int series) {
            try {
                XYPlot xyPlot = this.getPlot();
                XYDataset dataset = xyPlot.getDataset(this.datasetIndex);
                if (dataset != null) {
                    Shape shape;
                    Comparable seriesKey = dataset.getSeriesKey(series);
                    ChartShape pointShape = JFXyRender.this.plot.getSeriesPointShape(seriesKey);
                    if (pointShape != null && (shape = this.shapes.getShape(pointShape)) != null) {
                        return shape;
                    }
                }
                return super.getSeriesShape(series);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return super.getSeriesShape(series);
            }
        }
    }
}

