/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.js;

import com.zavtech.morpheus.viz.js.JsCode;
import com.zavtech.morpheus.viz.js.JsObject;
import java.util.function.Consumer;

public class JsArray {
    private int length;
    private boolean inline;
    private JsCode script;

    JsArray(JsCode script, boolean inline) {
        this.script = script;
        this.inline = inline;
    }

    public boolean isInline() {
        return this.inline;
    }

    public JsArray append(boolean value) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        if (!this.inline) {
            this.script.newLine();
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        } else {
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        }
        return this;
    }

    public JsArray append(int value) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        if (!this.inline) {
            this.script.newLine();
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        } else {
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        }
        return this;
    }

    public JsArray append(double value) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        if (!this.inline) {
            this.script.newLine();
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        } else {
            this.script.write(String.valueOf(value), new Object[0]);
            ++this.length;
        }
        return this;
    }

    public JsArray append(String value) {
        if (value == null || value.length() == 0) {
            return this.append("null", false);
        }
        return this.append(value, true);
    }

    public JsArray append(String value, boolean quotes) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        if (!this.inline) {
            this.script.newLine();
            this.script.write(quotes ? "\"" : "", new Object[0]);
            this.script.write(value, new Object[0]);
            this.script.write(quotes ? "\"" : "", new Object[0]);
            ++this.length;
        } else {
            this.script.write(quotes ? "\"" : "", new Object[0]);
            this.script.write(value, new Object[0]);
            this.script.write(quotes ? "\"" : "", new Object[0]);
            ++this.length;
        }
        return this;
    }

    public JsArray appendObject(Consumer<JsObject> consumer) {
        return this.appendObject(false, consumer);
    }

    public JsArray appendObject(boolean inline, Consumer<JsObject> consumer) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        if (!this.isInline()) {
            this.script.newLine();
            this.script.indent(4);
        }
        this.script.write("{", new Object[0]);
        if (!inline) {
            this.script.newLine();
            this.script.indent(4);
        }
        consumer.accept(new JsObject(this.script, inline));
        if (!inline) {
            this.script.unident(4);
            this.script.newLine();
        }
        this.script.write("}", new Object[0]);
        if (!this.isInline()) {
            this.script.unident(4);
        }
        ++this.length;
        return this;
    }

    public JsArray appendArray(boolean inline, Consumer<JsArray> consumer) {
        if (this.length > 0) {
            this.script.write(",", new Object[0]);
        }
        this.script.newLine();
        this.script.indent(4);
        this.script.write("[", new Object[0]);
        consumer.accept(new JsArray(this.script, inline));
        if (!inline) {
            this.script.newLine();
        }
        this.script.write("]", new Object[0]);
        this.script.unident(4);
        ++this.length;
        return this;
    }
}

