/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.js;

import com.zavtech.morpheus.viz.js.JsArray;
import com.zavtech.morpheus.viz.js.JsObject;
import java.util.function.Consumer;

public class JsCode {
    private String indent = "";
    private StringBuilder code = new StringBuilder();

    public static String create(Consumer<JsCode> consumer) {
        JsCode js = new JsCode();
        consumer.accept(js);
        return js.toString();
    }

    public JsCode clear() {
        this.code.delete(0, this.code.length());
        return this;
    }

    public JsCode write(String code, Object ... args) {
        this.code.append(String.format(code, args));
        return this;
    }

    public JsCode newLine() {
        return this.newLine(1);
    }

    public JsCode newLine(int count) {
        for (int i = 0; i < count; ++i) {
            this.code.append("\n");
        }
        this.code.append(this.indent);
        return this;
    }

    public JsCode indent(int count) {
        StringBuilder indentation = new StringBuilder(this.indent);
        for (int i = 0; i < count; ++i) {
            indentation.append(" ");
            this.code.append(" ");
        }
        this.indent = indentation.toString();
        return this;
    }

    public JsCode unident(int count) {
        this.indent = this.indent.substring(0, this.indent.length() - count);
        return this;
    }

    public JsCode newObject(Consumer<JsObject> consumer) {
        return this.newObject(false, consumer);
    }

    public JsCode newFunction(String name, Consumer<JsCode> consumer) {
        return this.newFunction(name, null, consumer);
    }

    public JsCode newFunction(String name, String args, Consumer<JsCode> consumer) {
        this.newLine();
        this.write("function %s(", name);
        this.write(args != null ? args : "", new Object[0]);
        this.write(") {", new Object[0]);
        this.newLine();
        this.indent(4);
        consumer.accept(this);
        this.unident(4);
        this.newLine();
        this.write("}", new Object[0]);
        return this;
    }

    public JsCode newObject(boolean inline, Consumer<JsObject> consumer) {
        this.write("{", new Object[0]);
        this.indent(4);
        this.newLine();
        consumer.accept(new JsObject(this, inline));
        this.unident(4);
        this.newLine();
        this.write("}", new Object[0]);
        return this;
    }

    public JsCode newArray(Consumer<JsArray> consumer) {
        return this.newArray(false, consumer);
    }

    public JsCode newArray(boolean inline, Consumer<JsArray> consumer) {
        this.code.append("[");
        if (!inline) {
            // empty if block
        }
        consumer.accept(new JsArray(this, inline));
        if (!inline) {
            this.newLine();
            this.write("]", new Object[0]);
        } else {
            this.write("]", new Object[0]);
        }
        return this;
    }

    public String toString() {
        return this.code.toString();
    }

    public static void main(String[] args) {
        JsCode code = new JsCode();
        code.write("x = ", new Object[0]);
        code.newObject(object -> {
            object.newAttribute((Object)"zav", "witdouck");
            object.newAttribute((Object)"x", 22);
            object.newAttribute((Object)"kilo", "weigth");
            object.newAttribute((Object)"enabled", false);
            object.newObject("test", (JsObject test) -> {
                test.newAttribute((Object)"whatever", "again");
                test.newAttribute((Object)"second", "level");
                test.newArray("inline", true, a -> {
                    for (int i = 0; i < 10; ++i) {
                        a.append(i);
                    }
                });
                test.newArray("third", false, x -> {
                    x.appendObject(p -> {
                        p.newAttribute((Object)"AAA", 22323);
                        p.newAttribute((Object)"BBB", 95843);
                        p.newAttribute((Object)"CCC", false);
                        p.newAttribute((Object)"XXX", "YYYY");
                    });
                    x.appendObject(p -> {
                        p.newAttribute((Object)"AAA", 22323);
                        p.newAttribute((Object)"BBB", 95843);
                        p.newAttribute((Object)"CCC", false);
                        p.newAttribute((Object)"XXX", "YYYY");
                    });
                    x.appendObject(p -> {
                        p.newAttribute((Object)"AAA", 22323);
                        p.newAttribute((Object)"BBB", 95843);
                        p.newAttribute((Object)"CCC", false);
                        p.newAttribute((Object)"XXX", "YYYY");
                    });
                });
            });
        });
        System.out.println(code.toString());
    }
}

