/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.js;

import com.zavtech.morpheus.viz.js.JsArray;
import com.zavtech.morpheus.viz.js.JsCode;
import java.util.function.Consumer;

public class JsObject {
    private JsCode script;
    private boolean inline;
    private int attributeCount = 0;
    private boolean ignoreNulls = false;

    JsObject(JsCode script, boolean inline) {
        this.script = script;
        this.inline = inline;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    private JsObject newAttribute(String template, Object key, Object value) {
        if (this.ignoreNulls && value == null) {
            return this;
        }
        if (this.attributeCount > 0) {
            this.script.write(",", new Object[0]);
            if (!this.inline) {
                this.script.newLine();
            } else {
                this.script.write(" ", new Object[0]);
            }
        }
        this.script.write(template, key, value);
        ++this.attributeCount;
        return this;
    }

    private JsObject createObject(Object key, Consumer<JsObject> consumer) {
        if (this.attributeCount > 0) {
            this.script.write(",", new Object[0]);
            this.script.newLine();
        }
        this.script.write("%s: ", key);
        this.script.newObject(consumer);
        ++this.attributeCount;
        return this;
    }

    private JsObject createArray(Object key, boolean inline, Consumer<JsArray> consumer) {
        if (this.attributeCount > 0) {
            this.script.write(",", new Object[0]);
            this.script.newLine();
        }
        this.script.write("%s: ", key);
        this.script.newArray(inline, consumer);
        ++this.attributeCount;
        return this;
    }

    public JsObject newAttribute(Object key, Boolean value) {
        return this.newAttribute("%s: %s", key, value);
    }

    public JsObject newAttribute(Object key, Integer value) {
        return this.newAttribute("%s: %s", key, value);
    }

    public JsObject newAttribute(Object key, Float value) {
        return this.newAttribute("%s: %s", key, value);
    }

    public JsObject newAttribute(Object key, Double value) {
        return this.newAttribute("%s: %s", key, value);
    }

    public JsObject newAttribute(Object key, String value) {
        return this.newAttribute("%s: \"%s\"", key, value);
    }

    public JsObject newObject(Object key, Consumer<JsObject> consumer) {
        return this.createObject(key, consumer);
    }

    public JsObject newArray(Object key, Consumer<JsArray> consumer) {
        return this.createArray(key, false, consumer);
    }

    public JsObject newArray(Object key, boolean inline, Consumer<JsArray> consumer) {
        return this.createArray(key, inline, consumer);
    }
}

