/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.table;

import com.zavtech.morpheus.util.text.SmartFormat;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;

public class DataFrameCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private Object value;
    private Component editor;
    private boolean selectAll = true;
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            DataFrameCellEditor.this.stopCellEditing();
        }
    };

    public boolean isSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean selectAll) {
        this.selectAll = selectAll;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)event;
            return me.getClickCount() == 2;
        }
        return false;
    }

    @Override
    public boolean shouldSelectCell(EventObject event) {
        if (this.editor instanceof JTextComponent) {
            final JTextComponent textComponent = (JTextComponent)this.editor;
            if (this.selectAll) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textComponent.requestFocus();
                        textComponent.selectAll();
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            if (this.editor instanceof JFormattedTextField) {
                this.value = ((JFormattedTextField)this.editor).getValue();
                this.fireEditingStopped();
                return true;
            }
            if (this.editor instanceof JTextField) {
                this.value = ((JTextField)this.editor).getText();
                this.fireEditingStopped();
                return true;
            }
            if (this.editor instanceof JSpinner) {
                JSpinner spinner = (JSpinner)this.editor;
                this.value = spinner.getValue();
                this.fireEditingStopped();
                return true;
            }
            this.fireEditingStopped();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int rowIndex, int colIndex) {
        TableCellRenderer renderer = table.getCellRenderer(rowIndex, colIndex);
        JComponent component = (JComponent)renderer.getTableCellRendererComponent(table, value, selected, false, rowIndex, colIndex);
        Font font = component.getFont();
        System.out.println("getTableCellEditorComponent() value=" + value + "row=" + rowIndex + " column=" + colIndex);
        if (value == null) {
            SmartFormat format = new SmartFormat();
            JFormattedTextField smartEditor = new JFormattedTextField((Format)format);
            smartEditor.setBorder(component.getBorder());
            smartEditor.setFont(font);
            smartEditor.setValue(value);
            smartEditor.addActionListener(this.actionListener);
            this.editor = smartEditor;
        } else if (value instanceof Double) {
            DecimalFormat doubleFormat = new DecimalFormat("0.00####;-0.00####");
            JFormattedTextField doubleEditor = new JFormattedTextField(doubleFormat);
            doubleEditor.setFont(font);
            doubleEditor.setValue(value);
            doubleEditor.setBorder(component.getBorder());
            doubleEditor.addActionListener(this.actionListener);
            doubleEditor.setHorizontalAlignment(4);
            this.editor = doubleEditor;
        } else if (value instanceof Integer) {
            DecimalFormat integerFormat = new DecimalFormat("0;-0");
            JFormattedTextField integerEditor = new JFormattedTextField(integerFormat);
            integerEditor.setFont(font);
            integerEditor.setBorder(component.getBorder());
            integerEditor.setHorizontalAlignment(4);
            integerEditor.setValue(value);
            integerEditor.addActionListener(this.actionListener);
            this.editor = integerEditor;
        } else if (value instanceof String) {
            JTextField stringEditor = new JTextField();
            stringEditor.setFont(font);
            stringEditor.setBorder(component.getBorder());
            stringEditor.setText(value.toString());
            stringEditor.addActionListener(this.actionListener);
            this.editor = stringEditor;
        } else if (value instanceof Date) {
            SpinnerDateModel model = new SpinnerDateModel();
            JSpinner spinner = new JSpinner(model);
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, "dd-MMM-yyyy");
            dateEditor.getTextField().setFont(font);
            dateEditor.getTextField().setBorder(component.getBorder());
            spinner.setFont(font);
            spinner.setEditor(dateEditor);
            spinner.setValue(value);
            this.editor = spinner;
        } else if (value instanceof Calendar) {
            SpinnerDateModel model = new SpinnerDateModel();
            JSpinner spinner = new JSpinner(model);
            JSpinner.DateEditor dateEditor = new JSpinner.DateEditor(spinner, "dd-MMM-yyyy");
            dateEditor.getTextField().setFont(font);
            dateEditor.getTextField().setBorder(component.getBorder());
            dateEditor.getModel().setValue(((Calendar)value).getTime());
            this.editor = dateEditor;
        }
        return this.editor;
    }
}

