/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.table;

import java.awt.Font;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataFrameCellFormat {
    private static final Logger LOG = Logger.getLogger(DataFrameCellFormat.class.getName());
    public static final int DECIMAL = 0;
    public static final int PERCENT = 1;
    public static final int BASIS_POINTS = 2;
    public static final int SCIENTIFIC = 3;
    private static final List<Format> decimalFormatList = new ArrayList<Format>();
    private static final List<Format> percentFormatList = new ArrayList<Format>();
    private static final List<Format> scientificFormatList = new ArrayList<Format>();
    private static final List<Format> basisPointsFormatList = new ArrayList<Format>();
    private static final Map<String, Format> dateFormatMap = new HashMap<String, Format>();
    private Font font;
    private int precision = 4;
    private int numberType = 0;
    private int alignment = -1;
    private String datePattern = "dd-MMM-yyyy";
    private Object background;
    private Object foreground;

    public Font getFont() {
        return this.font;
    }

    public int getAlignment(int defaultAlignment) {
        return this.alignment >= 0 ? this.alignment : defaultAlignment;
    }

    public int getNumberType() {
        return this.numberType;
    }

    public int getPrecision() {
        return this.precision;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public Object getBackground() {
        return this.background;
    }

    public Object getForeground() {
        return this.foreground;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public void setNumberType(int numberType) {
        this.numberType = numberType;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public void setBackground(Object background) {
        this.background = background;
    }

    public void setForeground(Object foreground) {
        this.foreground = foreground;
    }

    public String format(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return this.formatDate((Date)value);
        }
        if (value instanceof Number) {
            return this.formatDecimal((Number)value);
        }
        return value.toString();
    }

    public final void increasePrecision() {
        ++this.precision;
    }

    public final void decreasePrecision() {
        --this.precision;
    }

    protected synchronized String formatDate(Date date) {
        String pattern = this.getDatePattern();
        Format dateFormat = dateFormatMap.get(pattern);
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat(pattern);
            dateFormatMap.put(pattern, dateFormat);
        }
        return dateFormat.format(date);
    }

    protected synchronized String formatDecimal(Number value) {
        int precision = this.getPrecision();
        int type = this.getNumberType();
        switch (type) {
            case 0: {
                return decimalFormatList.get(precision).format(value);
            }
            case 1: {
                return percentFormatList.get(precision).format(value);
            }
            case 3: {
                return scientificFormatList.get(precision).format(value);
            }
            case 2: {
                return basisPointsFormatList.get(precision).format(value);
            }
        }
        return decimalFormatList.get(precision).format(value);
    }

    private static void createDecimalFormats(String template, int count, int multiplier, List<Format> formats) {
        try {
            for (int i = 0; i < count; ++i) {
                StringBuilder zeros = new StringBuilder(count + 1).append(i > 0 ? "." : "");
                for (int j = 0; j < i; ++j) {
                    zeros.append("0");
                }
                String pattern = template.replace("<ZEROS>", zeros.toString());
                DecimalFormat format = new DecimalFormat(pattern);
                format.setMultiplier(multiplier);
                formats.add(format);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    static {
        try {
            DataFrameCellFormat.createDecimalFormats("#,##0<ZEROS>;-#,##0<ZEROS>", 30, 1, decimalFormatList);
            DataFrameCellFormat.createDecimalFormats("0<ZEROS>E00;-0<ZEROS>E00", 30, 1, scientificFormatList);
            DataFrameCellFormat.createDecimalFormats("#,##0<ZEROS>'%';-#,##0<ZEROS>'%'", 30, 100, percentFormatList);
            DataFrameCellFormat.createDecimalFormats("#,##0<ZEROS>' bps';-#,##0<ZEROS>' bps'", 30, 10000, basisPointsFormatList);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }
}

