/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.table;

import com.zavtech.morpheus.viz.table.DataFrameCellFormat;
import com.zavtech.morpheus.viz.table.DataFrameCellProperty;
import com.zavtech.morpheus.viz.table.DataFrameTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DataFrameCellRenderer
extends DefaultTableCellRenderer {
    private static final Logger LOG = Logger.getLogger(DataFrameCellRenderer.class.getName());
    private static int PERF_COUNT = 10000;
    private int count;
    private long time;
    private DataFrameTable dataFrameTable;

    DataFrameCellRenderer(DataFrameTable dataFrameTable) {
        this.dataFrameTable = dataFrameTable;
    }

    static DataFrameCellProperty createColorProperty(final Color zero, final Color positive, final Color negative) {
        return new DataFrameCellProperty(){

            public Object getValue(Object value) throws IllegalArgumentException {
                if (value instanceof Number) {
                    double number = ((Number)value).doubleValue();
                    return number > 0.0 ? positive : (number < 0.0 ? negative : zero);
                }
                return zero;
            }
        };
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focus, int rowIndex, int colIndex) {
        long t1 = System.currentTimeMillis();
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, selected, focus, rowIndex, colIndex);
        try {
            int columnIndex = this.dataFrameTable.getColumnIndex(table, colIndex);
            DataFrameCellFormat format = this.dataFrameTable.getCellFormat(rowIndex, columnIndex, false);
            DataFrameCellFormat cellFormat = format != null ? format : this.dataFrameTable.getDefaultCellFormat();
            Font font = cellFormat != null ? cellFormat.getFont() : null;
            Color background = this.getBackground(table, cellFormat, value, selected);
            Color foreground = this.getForeground(table, cellFormat, value, selected);
            label.setBackground(background);
            label.setForeground(foreground);
            label.setFont(font != null ? font : table.getFont());
            String text = cellFormat.format(value);
            label.setText(text);
            if (value == null) {
                label.setHorizontalAlignment(0);
            } else if (value instanceof Double) {
                int alignment = cellFormat.getAlignment(4);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof Float) {
                int alignment = cellFormat.getAlignment(4);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof Number) {
                int alignment = cellFormat.getAlignment(4);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof String) {
                int alignment = cellFormat.getAlignment(2);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof Date) {
                int alignment = cellFormat.getAlignment(2);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof Calendar) {
                int alignment = cellFormat.getAlignment(2);
                label.setHorizontalAlignment(alignment);
            } else if (value instanceof Boolean) {
                int alignment = cellFormat.getAlignment(0);
                label.setHorizontalAlignment(alignment);
            } else {
                int alignment = cellFormat.getAlignment(4);
                label.setHorizontalAlignment(alignment);
            }
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
        long t2 = System.currentTimeMillis();
        this.time += t2 - t1;
        ++this.count;
        if (this.count % PERF_COUNT == 0) {
            LOG.info("DataFrameCellRenderer cell time=" + (double)this.time / (double)PERF_COUNT * 1000000.0 + " nanos, total time=" + this.time + " millis");
            this.time = 0L;
            this.count = 0;
        }
        return label;
    }

    protected final Color getBackground(JTable table, DataFrameCellFormat format, Object value, boolean selected) {
        DataFrameCellProperty property;
        Object result;
        Object background;
        Object object = background = format != null ? format.getBackground() : null;
        if (background instanceof Color) {
            Color color = (Color)background;
            return selected ? color.darker() : color;
        }
        if (background instanceof DataFrameCellProperty && (result = (property = (DataFrameCellProperty)background).getValue(value)) instanceof Color) {
            return selected ? ((Color)result).darker() : (Color)result;
        }
        return selected ? table.getSelectionBackground() : table.getBackground();
    }

    protected final Color getForeground(JTable table, DataFrameCellFormat format, Object value, boolean selected) {
        DataFrameCellProperty property;
        Object result;
        Object foreground;
        Object object = foreground = format != null ? format.getForeground() : null;
        if (foreground instanceof Color) {
            Color color = (Color)foreground;
            return selected ? color.darker() : color;
        }
        if (foreground instanceof DataFrameCellProperty && (result = (property = (DataFrameCellProperty)foreground).getValue(value)) instanceof Color) {
            return selected ? ((Color)result).brighter() : (Color)result;
        }
        return selected ? table.getSelectionForeground() : table.getForeground();
    }
}

