/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.table;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.index.Index;
import com.zavtech.morpheus.viz.table.DataFrameCellEditor;
import com.zavtech.morpheus.viz.table.DataFrameCellFormat;
import com.zavtech.morpheus.viz.table.DataFrameCellRenderer;
import com.zavtech.morpheus.viz.table.DataFrameTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class DataFrameTable
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DataFrameTable.class.getName());
    private static Map<Integer, String> fontStyleNameMap = new LinkedHashMap<Integer, String>();
    private static Map<Integer, Icon> fontStyleIconMap = new LinkedHashMap<Integer, Icon>();
    private static Map<Integer, String> alignmentNameMap = new LinkedHashMap<Integer, String>();
    private static Map<Integer, Icon> alignmentIconMap = new LinkedHashMap<Integer, Icon>();
    private static Map<Integer, String> formatNameMap = new LinkedHashMap<Integer, String>();
    private static Map<Integer, Icon> formatIconMap = new LinkedHashMap<Integer, Icon>();
    private int decimalCount = 4;
    private JScrollPane scrollPane;
    private JTable leftTable = new JTable();
    private JTable rightTable = new JTable();
    private DataFrameCellEditor editor = new DataFrameCellEditor();
    private DataFrameTableModel model = new DataFrameTableModel();
    private DataFrameCellRenderer renderer = new DataFrameCellRenderer(this);
    private DataFrameCellFormat defaultCellFormat = new DataFrameCellFormat();
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private TableRowSorter<TableModel> sorter = new TableRowSorter<DataFrameTableModel>(this.model);
    private Map<Object, DataFrameCellFormat> formatMap = new HashMap<Object, DataFrameCellFormat>();
    private Index<Object> rowIndex = Index.of(Object.class, (int)2000);
    private Index<Object> colIndex = Index.of(Object.class, (int)100);
    private DataFrame<Object, Object> formatFrame = DataFrame.ofObjects(this.rowIndex, this.colIndex);
    private JPopupMenu popupMenu = new JPopupMenu();
    private JMenu fontMenu = new JMenu("Font...");
    private JMenu styleMenu = new JMenu("Style....");
    private JMenu dateFormatMenu = new JMenu("Date Format...");
    private JMenu decimalFormatMenu = new JMenu("Number Format...");
    private JMenu alignmentMenu = new JMenu("Alignment...");
    private Action bestFitAction = this.createBestFitAction();
    private Action exportCsvAction = this.createCsvExportAction();
    private Action backgroundAction = this.createFillColorAction();
    private Action foregroundAction = this.createFontColorAction();
    private Action increasePrecisionAction = this.createIncreasePrecisionAction();
    private Action decreasePrecisionAction = this.createDecreasePrecisionAction();
    private TableColumnModelListener columnModelListener = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
            DataFrameTable.this.resizeLeftTable();
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            DataFrameTable.this.resizeLeftTable();
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            DataFrameTable.this.resizeLeftTable();
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
            DataFrameTable.this.resizeLeftTable();
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
            DataFrameTable.this.resizeLeftTable();
        }
    };
    private MouseListener mouseListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger() && !DataFrameTable.this.popupMenu.isVisible()) {
                DataFrameTable.this.popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
            } else if (event.getSource() == DataFrameTable.this.rightTable) {
                if (!DataFrameTable.this.rightTable.getCellSelectionEnabled()) {
                    DataFrameTable.this.leftTable.clearSelection();
                    DataFrameTable.this.leftTable.setRowSelectionAllowed(false);
                    DataFrameTable.this.leftTable.setCellSelectionEnabled(true);
                    DataFrameTable.this.rightTable.setRowSelectionAllowed(false);
                    DataFrameTable.this.rightTable.setCellSelectionEnabled(true);
                }
            } else if (event.getSource() == DataFrameTable.this.leftTable && DataFrameTable.this.rightTable.getCellSelectionEnabled()) {
                DataFrameTable.this.leftTable.setCellSelectionEnabled(false);
                DataFrameTable.this.leftTable.setRowSelectionAllowed(true);
                DataFrameTable.this.rightTable.setCellSelectionEnabled(false);
                DataFrameTable.this.rightTable.setRowSelectionAllowed(true);
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.isPopupTrigger() && !DataFrameTable.this.popupMenu.isVisible()) {
                DataFrameTable.this.popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger() && !DataFrameTable.this.popupMenu.isVisible()) {
                DataFrameTable.this.popupMenu.show((Component)event.getSource(), event.getX(), event.getY());
            }
        }
    };

    public DataFrameTable() {
        this((DataFrame)null);
    }

    public DataFrameTable(DataFrame frame) {
        try {
            this.initPopupMenu();
            this.initTable(this.leftTable);
            this.initTable(this.rightTable);
            this.leftTable.getColumnModel().addColumnModelListener(this.columnModelListener);
            this.scrollPane = new JScrollPane(this.rightTable);
            this.scrollPane.setCorner("UPPER_LEFT_CORNER", this.leftTable.getTableHeader());
            this.scrollPane.setRowHeaderView(this.leftTable);
            this.setLayout(new BorderLayout(0, 0));
            this.add((Component)this.scrollPane, "Center");
            this.setDataFrame(frame);
            this.scrollPane.getRowHeader().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    JViewport leftViewPort = DataFrameTable.this.scrollPane.getRowHeader();
                    JViewport rightViewPort = DataFrameTable.this.scrollPane.getViewport();
                    Point leftPoint = leftViewPort.getViewPosition();
                    Point rightPoint = rightViewPort.getViewPosition();
                    if (leftPoint.y != rightPoint.y) {
                        rightViewPort.setViewPosition(new Point(rightPoint.x, leftPoint.y));
                    }
                }
            });
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private void initTable(JTable table) {
        try {
            table.setAutoCreateColumnsFromModel(false);
            table.setModel(this.model);
            table.setRowSorter(this.sorter);
            table.setShowGrid(true);
            table.setRowHeight(16);
            table.setGridColor(Color.GRAY);
            table.setAutoResizeMode(0);
            table.setDefaultRenderer(Object.class, this.renderer);
            table.setDefaultRenderer(String.class, this.renderer);
            table.setDefaultRenderer(Double.class, this.renderer);
            table.setSelectionMode(2);
            table.setSelectionModel(this.selectionModel);
            table.addMouseListener(this.mouseListener);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
        finally {
            this.createColumns(table);
        }
    }

    protected void createColumns(JTable table) {
        table.setColumnModel(new DefaultTableColumnModel());
        if (table == this.leftTable) {
            table.addColumn(new TableColumn(0, 100, this.renderer, this.editor));
        } else {
            for (int i = 1; i < this.model.getColumnCount(); ++i) {
                table.addColumn(new TableColumn(i, 100, this.renderer, this.editor));
            }
        }
    }

    private void initPopupMenu() {
        try {
            this.fontMenu.setIcon(DataFrameTable.getIcon(16, "font.png"));
            this.fontMenu.add(this.createFontAction());
            this.fontMenu.addSeparator();
            this.fontMenu.add(this.createFontStyleAction(0));
            this.fontMenu.add(this.createFontStyleAction(1));
            this.fontMenu.add(this.createFontStyleAction(2));
            this.styleMenu.setIcon(DataFrameTable.getIcon(16, "color.png"));
            this.styleMenu.add(this.backgroundAction);
            this.styleMenu.add(this.foregroundAction);
            this.styleMenu.add(this.createConditionalFontColorAction());
            this.alignmentMenu.setIcon(DataFrameTable.getIcon(16, "text_align_right.png"));
            this.alignmentMenu.add(this.createAlignmentAction(2));
            this.alignmentMenu.add(this.createAlignmentAction(0));
            this.alignmentMenu.add(this.createAlignmentAction(4));
            this.dateFormatMenu.setIcon(DataFrameTable.getIcon(16, "date.png"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd-MMM-yyyy"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd/MM/yyyy"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd-MM-yyyy"));
            this.dateFormatMenu.add(this.createDateFormatAction("MM/dd/yyyy"));
            this.dateFormatMenu.add(this.createDateFormatAction("MM-dd-yyyy"));
            this.dateFormatMenu.add(this.createDateFormatAction("yyyy-MM-dd"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd-MMM-yyyy HH:mm"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd/MM/yyyy HH:mm"));
            this.dateFormatMenu.add(this.createDateFormatAction("dd-MM-yyyy HH:mm"));
            this.dateFormatMenu.add(this.createDateFormatAction("MM/dd/yyyy HH:mm"));
            this.dateFormatMenu.add(this.createDateFormatAction("MM-dd-yyyy HH:mm"));
            this.dateFormatMenu.add(this.createDateFormatAction("yyyy-MM-dd HH:mm"));
            this.decimalFormatMenu.setIcon(DataFrameTable.getIcon(16, "number.png"));
            this.decimalFormatMenu.add(this.createNumberTypeAction(0, "Decimal"));
            this.decimalFormatMenu.add(this.createNumberTypeAction(1, "Percent"));
            this.decimalFormatMenu.add(this.createNumberTypeAction(3, "Scientific"));
            this.decimalFormatMenu.add(this.createNumberTypeAction(2, "Basis Points"));
            this.popupMenu.add(this.fontMenu);
            this.popupMenu.add(this.styleMenu);
            this.popupMenu.add(this.alignmentMenu);
            this.popupMenu.add(this.dateFormatMenu);
            this.popupMenu.add(this.decimalFormatMenu);
            this.popupMenu.add(this.createClearFormatAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.bestFitAction);
            this.popupMenu.addSeparator();
            this.popupMenu.add(this.exportCsvAction);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    public <R, C> DataFrame<R, C> getDataFrame() {
        return this.model.getFrame();
    }

    public void setDataFrame(DataFrame frame) {
        try {
            this.model.setFrame(frame);
            this.leftTable.getColumnModel().removeColumnModelListener(this.columnModelListener);
            this.createColumns(this.leftTable);
            this.createColumns(this.rightTable);
            this.leftTable.getColumnModel().addColumnModelListener(this.columnModelListener);
            this.model.fireTableStructureChanged();
        }
        finally {
            this.resizeLeftTable();
            this.validateActions();
        }
    }

    public DataFrameCellFormat getDefaultCellFormat() {
        return this.defaultCellFormat;
    }

    public void setDefaultCellFormat(DataFrameCellFormat defaultCellFormat) {
        this.defaultCellFormat = defaultCellFormat;
    }

    public DataFrameCellFormat getRowHeaderFormat(Object row, boolean create) {
        DataFrameCellFormat format = this.formatMap.get(row);
        if (format != null) {
            return format;
        }
        if (!create) {
            format = this.defaultCellFormat;
        } else {
            format = new DataFrameCellFormat();
            this.formatMap.put(row, format);
        }
        return format;
    }

    public DataFrameCellFormat getCellFormat(Object row, Object column, boolean create) {
        if (this.formatFrame.rows().contains(row) && this.formatFrame.cols().contains(column)) {
            int rowIndex = this.formatFrame.rows().ordinalOf(row);
            int colIndex = this.formatFrame.cols().ordinalOf(column);
            DataFrameCellFormat format = (DataFrameCellFormat)this.formatFrame.data().getValue(rowIndex, colIndex);
            if (format == null && create) {
                format = new DataFrameCellFormat();
                this.formatFrame.data().setValue(row, column, (Object)format);
            }
            return format;
        }
        if (!create) {
            return this.defaultCellFormat;
        }
        this.formatFrame.rows().add(row);
        this.formatFrame.cols().add(column, DataFrameCellFormat.class);
        DataFrameCellFormat format = new DataFrameCellFormat();
        this.formatFrame.data().setValue(row, column, (Object)format);
        return format;
    }

    public final DataFrameCellFormat getCellFormat(int rowIndex, int colIndex, boolean create) {
        DataFrame data = this.model.getFrame();
        if (colIndex < this.leftTable.getColumnCount()) {
            int rowModelIndex = this.leftTable.convertRowIndexToModel(rowIndex);
            Object row = data.rows().key(rowModelIndex);
            return this.getRowHeaderFormat(row, create);
        }
        int actualColIndex = colIndex - this.leftTable.getColumnCount();
        int rowModelIndex = this.rightTable.convertRowIndexToModel(rowIndex);
        int colModelIndex = this.rightTable.convertColumnIndexToModel(actualColIndex);
        Object row = data.rows().key(rowModelIndex);
        Object column = data.cols().key(colModelIndex - 1);
        return this.getCellFormat(row, column, create);
    }

    int getColumnIndex(JTable table, int colIndex) {
        return this.leftTable == table ? colIndex : colIndex + this.leftTable.getColumnCount();
    }

    public void setDecimalCount(int decimalCount) {
        this.decimalCount = decimalCount;
    }

    private Action createAlignmentAction(final int alignment) {
        String name = alignmentNameMap.get(alignment);
        Icon icon = alignmentIconMap.get(alignment);
        String description = null;
        return new CustomAction(name, icon, description){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, true);
                            format.setAlignment(alignment);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createFontAction() {
        return new CustomAction("Font Face", null, null){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DataFrameTable parent = DataFrameTable.this;
                    String msg = "Select that font to accept to selected cells";
                    GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    Object[] fonts = ge.getAvailableFontFamilyNames();
                    String fontName = (String)JOptionPane.showInputDialog(parent, "Select that font to accept to selected cells", "Font", 1, null, fonts, fonts[0]);
                    if (fontName != null) {
                        Font font = new Font(fontName, 0, 11);
                        int[] rows = DataFrameTable.this.getSelectedRows();
                        int[] columns = DataFrameTable.this.getSelectedColumns();
                        for (int row : rows) {
                            for (int column : columns) {
                                DataFrameTable.this.getCellFormat(row, column, true).setFont(font);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createFontStyleAction(final int style) {
        String name = fontStyleNameMap.get(style);
        Icon icon = fontStyleIconMap.get(style);
        String description = null;
        return new CustomAction(name, icon, description){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameCellFormat cellFormat = DataFrameTable.this.getCellFormat(row, column, true);
                            Font font = cellFormat.getFont() != null ? cellFormat.getFont() : DataFrameTable.this.rightTable.getFont();
                            cellFormat.setFont(new Font(font.getName(), style, font.getSize()));
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createDateFormatAction(final String pattern) {
        ImageIcon icon = DataFrameTable.getIcon(16, "date.png");
        String name = pattern + "  (" + new SimpleDateFormat(pattern).format(new Date()) + ")";
        return new CustomAction(name, icon, name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameTable.this.getCellFormat(row, column, true).setDatePattern(pattern);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createNumberTypeAction(final Integer numberType, String description) {
        Icon icon = formatIconMap.get(numberType);
        String name = formatNameMap.get(numberType);
        return new CustomAction(name, icon, description){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, true);
                            if (format == null) continue;
                            format.setNumberType(numberType);
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createIncreasePrecisionAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "add-decimal-place.png");
        return new CustomAction("Increase Preicision", icon, "Increases numeric precision of selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameTable.this.getCellFormat(row, column, true).increasePrecision();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createDecreasePrecisionAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "delete-decimal-place.png");
        return new CustomAction("Decrease Preicision", icon, "Decreases numeric precision of selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameTable.this.getCellFormat(row, column, true).decreasePrecision();
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createCsvExportAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "excel.png");
        return new CustomAction("Export to CSV", icon, "Decreases numeric precision of selected cells"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (DataFrameTable.this.decimalCount > 0) {
                        DataFrameTable.this.decimalCount--;
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        };
    }

    private Action createBestFitAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "table_best_fit.png");
        return new CustomAction("Best Fit Columns", icon, "Resizes columns to optimal widths based on content"){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    TableColumnModel columnModel = DataFrameTable.this.rightTable.getColumnModel();
                    for (int j = 0; j < columnModel.getColumnCount(); ++j) {
                        int width = -1;
                        TableColumn column = columnModel.getColumn(j);
                        int modelIndex = column.getModelIndex();
                        int columnIndex = DataFrameTable.this.rightTable.convertColumnIndexToView(modelIndex);
                        TableCellRenderer headerRenderer = DataFrameTable.this.rightTable.getTableHeader().getDefaultRenderer();
                        if (headerRenderer != null) {
                            String columnName = DataFrameTable.this.rightTable.getColumnName(j);
                            Component component = headerRenderer.getTableCellRendererComponent(DataFrameTable.this.rightTable, columnName, false, false, 0, columnIndex);
                            if (component instanceof JComponent) {
                                JComponent jcomp = (JComponent)component;
                                int stringWidth = (int)jcomp.getPreferredSize().getWidth();
                                width = (stringWidth = stringWidth + jcomp.getInsets().left + jcomp.getInsets().right + 30) > width ? stringWidth : width;
                            }
                        }
                        TableModel model = DataFrameTable.this.rightTable.getModel();
                        for (int i = 0; i < model.getRowCount(); ++i) {
                            Object value = model.getValueAt(i, modelIndex);
                            Component component = DataFrameTable.this.renderer.getTableCellRendererComponent(DataFrameTable.this.rightTable, value, false, false, i, columnIndex);
                            if (!(component instanceof JLabel)) continue;
                            JLabel label = (JLabel)component;
                            int stringWidth = (int)label.getPreferredSize().getWidth();
                            width = (stringWidth = stringWidth + label.getInsets().left + label.getInsets().right + 4) > width ? stringWidth : width;
                        }
                        if (width <= 0) continue;
                        column.setPreferredWidth(width);
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
            }
        };
    }

    private Action createFillColorAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "color.png");
        return new CustomAction("Fill Color", icon, "Sets the background for selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Color color = JColorChooser.showDialog(DataFrameTable.this, "Background", Color.WHITE);
                    if (color != null) {
                        int[] rows = DataFrameTable.this.getSelectedRows();
                        int[] columns = DataFrameTable.this.getSelectedColumns();
                        for (int row : rows) {
                            for (int column : columns) {
                                DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, true);
                                format.setBackground(color);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createFontColorAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "edit-color.png");
        return new CustomAction("Font Color", icon, "Sets the font color for selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Color color = JColorChooser.showDialog(DataFrameTable.this, "Foreground", Color.WHITE);
                    if (color != null) {
                        int[] rows = DataFrameTable.this.getSelectedRows();
                        int[] columns = DataFrameTable.this.getSelectedColumns();
                        for (int row : rows) {
                            for (int column : columns) {
                                DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, true);
                                format.setForeground(color);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createConditionalFontColorAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "edit-color.png");
        return new CustomAction("Green / Red Font Color", icon, "Sets the font color for selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            Color zero = DataFrameTable.this.leftTable.getForeground();
                            Color positive = Color.GREEN;
                            Color negative = Color.RED;
                            DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, true);
                            format.setForeground(DataFrameCellRenderer.createColorProperty(zero, positive, negative));
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private Action createClearFormatAction() {
        ImageIcon icon = DataFrameTable.getIcon(16, "edit-color.png");
        return new CustomAction("Clear Formatting", icon, "Removes any formatting applied to the selected cells"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int[] rows = DataFrameTable.this.getSelectedRows();
                    int[] columns = DataFrameTable.this.getSelectedColumns();
                    for (int row : rows) {
                        for (int column : columns) {
                            DataFrameCellFormat format = DataFrameTable.this.getCellFormat(row, column, false);
                            if (format == null) continue;
                        }
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                }
                finally {
                    DataFrameTable.this.model.fireTableDataChanged();
                }
            }
        };
    }

    private void validateActions() {
        this.increasePrecisionAction.setEnabled(true);
        this.decreasePrecisionAction.setEnabled(true);
        this.exportCsvAction.setEnabled(this.model.getRowCount() > 0);
    }

    public int[] getSelectedRows() {
        return this.rightTable.getSelectedRows();
    }

    public int[] getSelectedColumns() {
        int[] columns1 = this.leftTable.getSelectedColumns();
        int[] columns2 = this.rightTable.getSelectedColumns();
        int[] columns = new int[columns1.length + columns2.length];
        System.arraycopy(columns1, 0, columns, 0, columns1.length);
        for (int i = 0; i < columns2.length; ++i) {
            columns[columns1.length + i] = columns2[i] + this.leftTable.getColumnCount();
        }
        return columns;
    }

    private static ImageIcon getIcon(int size, String name) {
        String path = "/icons/" + size + "x" + size + "/" + name;
        URL url = DataFrameTable.class.getResource(path);
        if (url == null) {
            LOG.warning("No icon found for path");
        }
        return url != null ? new ImageIcon(url) : null;
    }

    private void resizeLeftTable() {
        try {
            this.scrollPane.getRowHeader().setPreferredSize(this.leftTable.getPreferredSize());
            this.scrollPane.getRowHeader().setMaximumSize(this.leftTable.getPreferredSize());
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    static {
        try {
            fontStyleNameMap.put(0, "Plain Text");
            fontStyleNameMap.put(1, "Bold Text");
            fontStyleNameMap.put(2, "Italic Text");
            fontStyleIconMap.put(0, DataFrameTable.getIcon(16, "font.png"));
            fontStyleIconMap.put(1, DataFrameTable.getIcon(16, "text_bold.png"));
            fontStyleIconMap.put(2, DataFrameTable.getIcon(16, "text_italic.png"));
            formatNameMap.put(0, "Decimal");
            formatNameMap.put(1, "Percent");
            formatNameMap.put(3, "Scientific");
            formatNameMap.put(2, "Basis Points");
            formatIconMap.put(0, DataFrameTable.getIcon(16, "number.png"));
            formatIconMap.put(1, DataFrameTable.getIcon(16, "percent.png"));
            formatIconMap.put(3, DataFrameTable.getIcon(16, "scientific.png"));
            formatIconMap.put(2, DataFrameTable.getIcon(16, "bps.png"));
            alignmentNameMap.put(2, "Align Left");
            alignmentNameMap.put(0, "Align Center");
            alignmentNameMap.put(4, "Align Right");
            alignmentIconMap.put(2, DataFrameTable.getIcon(16, "text_align_left.png"));
            alignmentIconMap.put(0, DataFrameTable.getIcon(16, "text_align_center.png"));
            alignmentIconMap.put(4, DataFrameTable.getIcon(16, "text_align_right.png"));
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
        }
    }

    private static abstract class CustomAction
    extends AbstractAction {
        private CustomAction(String name, Icon icon, String description) {
            super(name);
            if (icon != null) {
                this.putValue("SmallIcon", icon);
            }
            if (description != null) {
                this.putValue("ShortDescription", description);
            }
        }
    }
}

