/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.table;

import com.zavtech.morpheus.frame.DataFrame;
import com.zavtech.morpheus.frame.DataFrameEvent;
import com.zavtech.morpheus.frame.DataFrameListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.AbstractTableModel;

public class DataFrameTableModel
extends AbstractTableModel
implements DataFrameListener {
    private static final Logger LOG = Logger.getLogger(DataFrameTableModel.class.getName());
    private boolean mutable;
    private DataFrame<Object, Object> frame;
    private ThreadLocal<Object[]> coordinates = new ThreadLocal<Object[]>(){

        @Override
        protected Object[] initialValue() {
            return new Object[2];
        }
    };

    public DataFrameTableModel() {
        this(null);
    }

    public DataFrameTableModel(DataFrame frame) {
        this.setFrame(frame);
    }

    public DataFrame getFrame() {
        return this.frame;
    }

    public void setFrame(DataFrame frame) {
        if (this.getFrame() != null) {
            this.getFrame().events().removeDataFrameListener((DataFrameListener)this);
        }
        this.frame = frame;
        if (this.getFrame() != null) {
            this.getFrame().events().addDataFrameListener((DataFrameListener)this);
        }
    }

    public void setMutable(boolean mutable) {
        this.mutable = mutable;
    }

    public void onDataFrameEvent(DataFrameEvent event) {
        try {
            if (event.isSingleElement()) {
                Object row = event.rowKeys().getValue(0);
                Object column = event.colKeys().getValue(0);
                int rowIndex = this.frame.rows().ordinalOf(row);
                int colIndex = this.frame.cols().ordinalOf(column);
                this.fireTableCellUpdated(rowIndex, colIndex);
            } else if (event.isSingleRow()) {
                Object row = event.rowKeys().getValue(0);
                int rowIndex = this.frame.rows().ordinalOf(row);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                this.fireTableDataChanged();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public int getRowCount() {
        return this.frame != null ? this.frame.rowCount() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.frame != null ? this.frame.colCount() + 1 : 0;
    }

    @Override
    public String getColumnName(int colIndex) {
        if (this.frame == null) {
            return null;
        }
        switch (colIndex) {
            case 0: {
                return "Index";
            }
        }
        return this.frame.cols().key(colIndex - 1).toString();
    }

    @Override
    public Class<?> getColumnClass(int colIndex) {
        if (this.frame == null) {
            return Object.class;
        }
        switch (colIndex) {
            case 0: {
                return this.frame.rowCount() > 0 ? this.frame.rows().key(0).getClass() : Object.class;
            }
        }
        Object key = this.frame.cols().key(colIndex - 1);
        return this.frame.cols().type(key);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int colIndex) {
        if (this.frame == null) {
            return false;
        }
        switch (colIndex) {
            case 0: {
                return false;
            }
        }
        return this.mutable;
    }

    @Override
    public Object getValueAt(int rowIndex, int colIndex) {
        if (this.frame == null) {
            return null;
        }
        if (colIndex == 0) {
            return this.frame.rows().key(rowIndex);
        }
        try {
            Object[] coords = this.coordinates.get();
            coords[0] = this.frame.rows().key(rowIndex);
            coords[1] = this.frame.cols().key(colIndex - 1);
            return this.frame.data().getValue(rowIndex, colIndex - 1);
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, t.getMessage(), t);
            return null;
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int colIndex) {
        if (this.frame != null && colIndex > 0) {
            try {
                this.frame.data().setValue(rowIndex, colIndex - 1, value);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, t.getMessage(), t);
            }
        }
    }

    Object[] getLastCoordinates() {
        return this.coordinates.get();
    }
}

