/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.util;

import com.zavtech.morpheus.viz.util.ColorModelBase;
import java.awt.Color;

class GoldenRatioColors
extends ColorModelBase {
    private float h = 0.8f;
    private static final float s = 0.5f;
    private static final float v = 0.95f;
    private static final double goldenRatio = 0.618033988749895;

    GoldenRatioColors() {
    }

    @Override
    protected Color next() {
        this.h = (float)((double)this.h + 0.618033988749895);
        this.h = (float)((double)this.h % 1.0);
        float[] hsv = new float[3];
        float[] rgb = new float[3];
        hsv[0] = this.h;
        hsv[1] = 0.5f;
        hsv[2] = 0.95f;
        if (hsv[0] == -1.0f) {
            rgb[1] = rgb[2] = hsv[2];
            rgb[0] = rgb[2];
            return new Color(rgb[0], rgb[1], rgb[2]);
        }
        int i = (int)Math.floor(hsv[0]);
        float f = hsv[0] - (float)i;
        if (i % 2 == 0) {
            f = 1.0f - f;
        }
        float m = hsv[2] * (1.0f - hsv[1]);
        float n = hsv[2] * (1.0f - hsv[1] * f);
        switch (i) {
            case 0: 
            case 6: {
                rgb[0] = hsv[2];
                rgb[1] = n;
                rgb[2] = m;
                break;
            }
            case 1: {
                rgb[0] = n;
                rgb[1] = hsv[2];
                rgb[2] = m;
                break;
            }
            case 2: {
                rgb[0] = m;
                rgb[1] = hsv[2];
                rgb[2] = n;
                break;
            }
            case 3: {
                rgb[0] = m;
                rgb[1] = n;
                rgb[2] = hsv[2];
                break;
            }
            case 4: {
                rgb[0] = n;
                rgb[1] = m;
                rgb[2] = hsv[2];
                break;
            }
            case 5: {
                rgb[0] = hsv[2];
                rgb[1] = m;
                rgb[2] = n;
            }
        }
        return new Color(rgb[0], rgb[1], rgb[2]);
    }
}

