/*
 * Decompiled with CFR 0.152.
 */
package com.zavtech.morpheus.viz.util;

import java.text.DecimalFormat;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XWilkinson {
    public boolean loose = false;
    private final double[] w;
    private final double[] Q;
    private final double base;
    private final double eps;

    private XWilkinson(double[] Q, double base, double[] w, double eps) {
        this.w = w;
        this.Q = Q;
        this.base = base;
        this.eps = eps;
    }

    private XWilkinson(double[] Q, double base) {
        this(Q, base, new double[]{0.25, 0.2, 0.5, 0.05}, 1.0E-10);
    }

    public static XWilkinson of(double[] Q, double base) {
        return new XWilkinson(Q, base);
    }

    public static XWilkinson base10() {
        return XWilkinson.of(new double[]{1.0, 5.0, 2.0, 2.5, 4.0, 3.0}, 10.0);
    }

    public static XWilkinson base2() {
        return XWilkinson.of(new double[]{1.0}, 2.0);
    }

    public static XWilkinson base16() {
        return XWilkinson.of(new double[]{1.0, 2.0, 4.0, 8.0}, 16.0);
    }

    public static XWilkinson forSeconds() {
        return XWilkinson.of(new double[]{1.0, 2.0, 3.0, 5.0, 10.0, 15.0, 20.0, 30.0}, 60.0);
    }

    public static XWilkinson forMinutes() {
        return XWilkinson.of(new double[]{1.0, 2.0, 3.0, 5.0, 10.0, 15.0, 20.0, 30.0}, 60.0);
    }

    public static XWilkinson forHours24() {
        return XWilkinson.of(new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 8.0, 12.0}, 24.0);
    }

    public static XWilkinson forHours12() {
        return XWilkinson.of(new double[]{1.0, 2.0, 3.0, 4.0, 6.0}, 12.0);
    }

    public static XWilkinson forDays() {
        return XWilkinson.of(new double[]{1.0, 2.0}, 7.0);
    }

    public static XWilkinson forWeeks() {
        return XWilkinson.of(new double[]{1.0, 2.0, 4.0, 13.0, 26.0}, 52.0);
    }

    public static XWilkinson forMonths() {
        return XWilkinson.of(new double[]{1.0, 2.0, 3.0, 4.0, 6.0}, 12.0);
    }

    public static XWilkinson forYears() {
        return XWilkinson.of(new double[]{1.0, 2.0, 5.0}, 10.0);
    }

    private double w(double s, double c, double d, double l) {
        return this.w[0] * s + this.w[1] * c + this.w[2] * d + this.w[3] * l;
    }

    private double logB(double a) {
        return Math.log(a) / Math.log(this.base);
    }

    private double flooredMod(double a, double n) {
        return a - n * Math.floor(a / n);
    }

    private double v(double min, double max, double step) {
        return this.flooredMod(min, step) < this.eps && min <= 0.0 && max >= 0.0 ? 1.0 : 0.0;
    }

    private double simplicity(int i, int j, double min, double max, double step) {
        if (this.Q.length > 1) {
            return 1.0 - (double)i / (double)(this.Q.length - 1) - (double)j + this.v(min, max, step);
        }
        return (double)(1 - j) + this.v(min, max, step);
    }

    private double simplicity_max(int i, int j) {
        if (this.Q.length > 1) {
            return 1.0 - (double)i / (double)(this.Q.length - 1) - (double)j + 1.0;
        }
        return (double)(1 - j) + 1.0;
    }

    private double coverage(double dmin, double dmax, double lmin, double lmax) {
        double a = dmax - lmax;
        double b = dmin - lmin;
        double c = 0.1 * (dmax - dmin);
        return 1.0 - 0.5 * ((a * a + b * b) / (c * c));
    }

    private double coverage_max(double dmin, double dmax, double span) {
        double range = dmax - dmin;
        if (span > range) {
            double half = (span - range) / 2.0;
            double r = 0.1 * range;
            return 1.0 - half * half / (r * r);
        }
        return 1.0;
    }

    private double density(int k, int m, double dmin, double dmax, double lmin, double lmax) {
        double r = (double)(k - 1) / (lmax - lmin);
        double rt = (double)(m - 1) / (Math.max(lmax, dmax) - Math.min(lmin, dmin));
        return 2.0 - Math.max(r / rt, rt / r);
    }

    private double density_max(int k, int m) {
        if (k >= m) {
            return 2 - (k - 1) / (m - 1);
        }
        return 1.0;
    }

    private double legibility(double min, double max, double step) {
        return 1.0;
    }

    public Label search(double dmin, double dmax, int m) {
        Label best = new Label();
        double bestScore = -2.0;
        block0: for (int j = 1; j < Integer.MAX_VALUE; ++j) {
            for (int _i = 0; _i < this.Q.length; ++_i) {
                double dm;
                int i = _i + 1;
                double q = this.Q[_i];
                double sm = this.simplicity_max(i, j);
                if (this.w(sm, 1.0, 1.0, 1.0) < bestScore) break block0;
                for (int k = 2; k < Integer.MAX_VALUE && !(this.w(sm, 1.0, dm = this.density_max(k, m), 1.0) < bestScore); ++k) {
                    double step;
                    double cm;
                    double delta = (dmax - dmin) / (double)(k + 1) / ((double)j * q);
                    for (int z = (int)Math.ceil(this.logB(delta)); z < Integer.MAX_VALUE && !(this.w(sm, cm = this.coverage_max(dmin, dmax, (step = (double)j * q * Math.pow(this.base, z)) * (double)(k - 1)), dm, 1.0) < bestScore); ++z) {
                        int min_start = (int)(Math.floor(dmax / step - (double)(k - 1)) * (double)j);
                        int max_start = (int)Math.ceil(dmin / step) * j;
                        for (int start = min_start; start <= max_start; ++start) {
                            double l;
                            double d;
                            double lmin = (double)start * step / (double)j;
                            double lmax = lmin + step * (double)(k - 1);
                            double c = this.coverage(dmin, dmax, lmin, lmax);
                            double s = this.simplicity(i, j, lmin, lmax, step);
                            double score = this.w(s, c, d = this.density(k, m, dmin, dmax, lmin, lmax), l = this.legibility(lmin, lmax, step));
                            if (!(score > bestScore) || this.loose && (!(lmin <= dmin) || !(lmax >= dmax))) continue;
                            best.min = lmin;
                            best.max = lmax;
                            best.step = step;
                            best.score = score;
                            bestScore = score;
                        }
                    }
                }
            }
        }
        return best;
    }

    public static void main(String[] args) {
        XWilkinson x = XWilkinson.base10();
        x.loose = true;
        System.out.println(x.search(-98.0, 18.0, 3).toString());
        x.loose = false;
        System.out.println(x.search(-98.0, 18.0, 3).toString());
        System.out.println();
        x.loose = true;
        System.out.println(x.search(-1.0, 200.0, 3).toString());
        x.loose = false;
        System.out.println(x.search(-1.0, 200.0, 3).toString());
        System.out.println();
        x.loose = true;
        System.out.println(x.search(119.0, 178.0, 3).toString());
        x.loose = false;
        System.out.println(x.search(119.0, 178.0, 3).toString());
        System.out.println();
        x.loose = true;
        System.out.println(x.search(-31.0, 27.0, 4).toString());
        x.loose = false;
        System.out.println(x.search(-31.0, 27.0, 3).toString());
        System.out.println();
        x.loose = true;
        System.out.println(x.search(-55.45, -49.99, 2).toString());
        x.loose = false;
        System.out.println(x.search(-55.45, -49.99, 3).toString());
        System.out.println();
        x.loose = false;
        System.out.println(x.search(0.0, 100.0, 2).toString());
        System.out.println(x.search(0.0, 100.0, 3).toString());
        System.out.println(x.search(0.0, 100.0, 4).toString());
        System.out.println(x.search(0.0, 100.0, 5).toString());
        System.out.println(x.search(0.0, 100.0, 6).toString());
        System.out.println(x.search(0.0, 100.0, 7).toString());
        System.out.println(x.search(0.0, 100.0, 8).toString());
        System.out.println(x.search(0.0, 100.0, 9).toString());
        System.out.println(x.search(0.0, 100.0, 10).toString());
        System.out.println("Some additional tests: Testing with base2");
        x = XWilkinson.base2();
        System.out.println(x.search(0.0, 32.0, 8).toString());
        System.out.println("Quick experiment with minutes: Check the logic");
        x = XWilkinson.forMinutes();
        System.out.println(x.search(0.0, 240.0, 16));
        System.out.println(x.search(0.0, 240.0, 9));
        System.out.println("Quick experiment with minutes: Convert values to HH:mm");
        LocalTime start = LocalTime.now();
        LocalTime end = start.plusMinutes(245L);
        int dmin = start.toSecondOfDay() / 60;
        int dmax = end.toSecondOfDay() / 60;
        if (dmin > dmax) {
            int swap = dmin;
            dmin = dmax;
            dmax = swap;
        }
        System.out.println("dmin: " + dmin + " dmax: " + dmax);
        Label labels = x.search(dmin, dmax, 15);
        System.out.println("labels");
        for (double time = labels.getMin(); time < labels.getMax(); time += labels.getStep()) {
            LocalTime lt = LocalTime.ofSecondOfDay(Double.valueOf(time).intValue() * 60);
            System.out.println(lt);
        }
    }

    public class Label
    implements Iterable<Double> {
        private double min;
        private double max;
        private double step;
        private double score;

        public String toString() {
            DecimalFormat df = new DecimalFormat("00.00");
            String s = "(Score: " + df.format(this.score) + ") ";
            for (double x = this.min; x <= this.max; x += this.step) {
                s = s + df.format(x) + "\t";
            }
            return s;
        }

        @Override
        public Iterator<Double> iterator() {
            return this.getList().iterator();
        }

        public List<Double> getList() {
            ArrayList<Double> list = new ArrayList<Double>();
            for (double i = this.min; i <= this.max; i += this.step) {
                list.add(i);
            }
            return list;
        }

        public double getMin() {
            return this.min;
        }

        public double getMax() {
            return this.max;
        }

        public double getStep() {
            return this.step;
        }

        public double getScore() {
            return this.score;
        }
    }
}

