/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.pool.HikariPool;
import com.zaxxer.hikari.pool.LeakTask;
import com.zaxxer.hikari.pool.PoolBagEntry;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.HikariCallableStatementProxy;
import com.zaxxer.hikari.proxy.HikariConnectionProxy;
import com.zaxxer.hikari.proxy.HikariPreparedStatementProxy;
import com.zaxxer.hikari.proxy.HikariResultSetProxy;
import com.zaxxer.hikari.proxy.HikariStatementProxy;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public final class ProxyFactory {
    private ProxyFactory() {
    }

    public static IHikariConnectionProxy getProxyConnection(HikariPool hikariPool, PoolBagEntry poolBagEntry, LeakTask leakTask) {
        return new HikariConnectionProxy(hikariPool, poolBagEntry, leakTask);
    }

    static Statement getProxyStatement(ConnectionProxy connectionProxy, Statement statement) {
        return new HikariStatementProxy(connectionProxy, statement);
    }

    static CallableStatement getProxyCallableStatement(ConnectionProxy connectionProxy, CallableStatement callableStatement) {
        return new HikariCallableStatementProxy(connectionProxy, callableStatement);
    }

    static PreparedStatement getProxyPreparedStatement(ConnectionProxy connectionProxy, PreparedStatement preparedStatement) {
        return new HikariPreparedStatementProxy(connectionProxy, preparedStatement);
    }

    static ResultSet getProxyResultSet(ConnectionProxy connectionProxy, ResultSet resultSet) {
        return new HikariResultSetProxy(connectionProxy, resultSet);
    }
}

