/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.HikariPool;
import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.proxy.LeakTask;
import com.zaxxer.hikari.proxy.ProxyFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionProxy
implements IHikariConnectionProxy {
    private static ProxyFactory PROXY_FACTORY;
    @HikariInject
    private static final Set<String> SQL_ERRORS;
    @HikariInject
    private ArrayList<Statement> _openStatements;
    @HikariInject
    private volatile boolean _isClosed;
    @HikariInject
    private HikariPool _parentPool;
    protected final Connection delegate;
    @HikariInject
    private volatile boolean _forceClose;
    @HikariInject
    private long _creationTime;
    @HikariInject
    private long _lastAccess;
    @HikariInject
    private StackTraceElement[] _stackTrace;
    @HikariInject
    private TimerTask _leakTask;

    protected ConnectionProxy(Connection connection) {
        this.delegate = connection;
        this.__init();
    }

    @HikariInject
    public void unregisterStatement(Object statement) {
        if (!this._isClosed) {
            this._openStatements.remove(statement);
        }
    }

    @HikariInject
    public long getCreationTime() {
        return this._creationTime;
    }

    @HikariInject
    public long getLastAccess() {
        return this._lastAccess;
    }

    @HikariInject
    public void markLastAccess() {
        this._lastAccess = System.currentTimeMillis();
    }

    @HikariInject
    public void setParentPool(HikariPool parentPool) {
        this._parentPool = parentPool;
    }

    @HikariInject
    public void unclose() {
        this._isClosed = false;
    }

    @HikariInject
    public void captureStack(long leakDetectionThreshold, Timer scheduler) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        this._stackTrace = new StackTraceElement[trace.length - 4];
        System.arraycopy(trace, 4, this._stackTrace, 0, this._stackTrace.length);
        this._leakTask = new LeakTask(this._stackTrace, leakDetectionThreshold);
        scheduler.schedule(this._leakTask, leakDetectionThreshold);
    }

    @HikariInject
    public boolean isBrokenConnection() {
        return this._forceClose;
    }

    @HikariInject
    public SQLException checkException(SQLException sqle) {
        String sqlState = sqle.getSQLState();
        this._forceClose |= sqlState != null && (sqlState.startsWith("08") || SQL_ERRORS.contains(sqlState));
        return sqle;
    }

    @HikariInject
    private void __init() {
        this._openStatements = new ArrayList(64);
        this._creationTime = this._lastAccess = System.currentTimeMillis();
    }

    @HikariInject
    protected void checkClosed() throws SQLException {
        if (this._isClosed) {
            throw new SQLException("Connection is closed");
        }
    }

    public final Connection getDelegate() {
        return this.delegate;
    }

    @HikariInject
    public void close() throws SQLException {
        if (!this._isClosed) {
            this._isClosed = true;
            if (this._leakTask != null) {
                this._leakTask.cancel();
                this._leakTask = null;
            }
            try {
                for (int i = this._openStatements.size() - 1; i >= 0; --i) {
                    this._openStatements.get(i).close();
                }
            }
            catch (SQLException e) {
                throw this.checkException(e);
            }
            finally {
                this._openStatements.clear();
                this._parentPool.releaseConnection(this);
            }
        }
    }

    @HikariInject
    public boolean isClosed() throws SQLException {
        return this._isClosed;
    }

    @HikariInject
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        try {
            Statement statementProxy = this.__createStatement();
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            Statement statementProxy = this.__createStatement(resultSetType, resultSetConcurrency);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            Statement statementProxy = this.__createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement statementProxy = this.__prepareCall(sql);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement statementProxy = this.__prepareCall(sql, resultSetType, resultSetConcurrency);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            CallableStatement statementProxy = this.__prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql, autoGeneratedKeys);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql, resultSetType, resultSetConcurrency);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql, columnIndexes);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    @HikariInject
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        try {
            PreparedStatement statementProxy = this.__prepareStatement(sql, columnNames);
            ((IHikariStatementProxy)((Object)statementProxy)).setConnectionProxy(this);
            this._openStatements.add(statementProxy);
            return statementProxy;
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    public boolean isValid(int timeout) throws SQLException {
        if (this._isClosed) {
            return false;
        }
        try {
            return this.delegate.isValid(timeout);
        }
        catch (SQLException e) {
            throw this.checkException(e);
        }
    }

    private static void __static() {
        if (PROXY_FACTORY == null) {
            PROXY_FACTORY = JavassistProxyFactoryFactory.getProxyFactory();
        }
    }

    public final void __close() throws SQLException {
        this.delegate.close();
    }

    public final Statement __createStatement() throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement());
    }

    public final Statement __createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency));
    }

    public final Statement __createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyStatement(this, this.delegate.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final CallableStatement __prepareCall(String sql) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql));
    }

    public final CallableStatement __prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency));
    }

    public final CallableStatement __prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyCallableStatement(this, this.delegate.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final PreparedStatement __prepareStatement(String sql) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql));
    }

    public final PreparedStatement __prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, autoGeneratedKeys));
    }

    public final PreparedStatement __prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    public final PreparedStatement __prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    public final PreparedStatement __prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnIndexes));
    }

    public final PreparedStatement __prepareStatement(String sql, String[] columnNames) throws SQLException {
        return PROXY_FACTORY.getProxyPreparedStatement(this, this.delegate.prepareStatement(sql, columnNames));
    }

    static {
        SQL_ERRORS = new HashSet<String>();
        SQL_ERRORS.add("57P01");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("57P03");
        SQL_ERRORS.add("57P02");
        SQL_ERRORS.add("01002");
        ConnectionProxy.__static();
    }
}

