/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassLoaderUtils {
    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return new CascadingClassLoader(cl);
        }
        return ClassLoaderUtils.class.getClassLoader();
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null) {
            return new CascadingClassLoader(cl).loadClass(className);
        }
        return Class.forName(className);
    }

    public static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet interfaces = new HashSet();
        for (Class<?> intf : Arrays.asList(clazz.getInterfaces())) {
            if (intf.getInterfaces().length > 0) {
                interfaces.addAll(ClassLoaderUtils.getAllInterfaces(intf));
            }
            interfaces.add(intf);
        }
        if (clazz.getSuperclass() != null) {
            interfaces.addAll(ClassLoaderUtils.getAllInterfaces(clazz.getSuperclass()));
        }
        if (clazz.isInterface()) {
            interfaces.add(clazz);
        }
        return interfaces;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CascadingClassLoader
    extends ClassLoader {
        private ClassLoader contextLoader;

        CascadingClassLoader(ClassLoader contextLoader) {
            this.contextLoader = contextLoader;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            try {
                return this.contextLoader.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                return CascadingClassLoader.class.getClassLoader().loadClass(name);
            }
        }
    }
}

