/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariClassTransformer;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariClassScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassScanner.class);
    private HikariClassTransformer transformer;
    private Properties codex;

    public HikariClassScanner(HikariClassTransformer transformer) {
        this.transformer = transformer;
    }

    public boolean scanClasses(String dsClassName) {
        try {
            long start = System.currentTimeMillis();
            if (!this.loadCodex()) {
                LOGGER.warn("Unable to load instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.");
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            HashSet hash = (HashSet)this.codex.get(dsClassName);
            if (hash == null) {
                LOGGER.warn("DataSource {} not found in the instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.", (Object)dsClassName);
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            String keyPrefix = (String)hash.iterator().next();
            HashSet classes = (HashSet)this.codex.get(keyPrefix + ".baseConnection");
            this.loadClasses(classes, 1);
            classes = (HashSet)this.codex.get(keyPrefix + ".subConnection");
            this.loadClasses(classes, 6);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseStatement");
            this.loadClasses(classes, 2);
            classes = (HashSet)this.codex.get(keyPrefix + ".subStatement");
            this.loadClasses(classes, 7);
            classes = (HashSet)this.codex.get(keyPrefix + ".basePreparedStatement");
            this.loadClasses(classes, 3);
            classes = (HashSet)this.codex.get(keyPrefix + ".subPreparedStatement");
            this.loadClasses(classes, 8);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseCallableStatement");
            this.loadClasses(classes, 4);
            classes = (HashSet)this.codex.get(keyPrefix + ".subCallableStatement");
            this.loadClasses(classes, 9);
            classes = (HashSet)this.codex.get(keyPrefix + ".baseResultSet");
            this.loadClasses(classes, 5);
            classes = (HashSet)this.codex.get(keyPrefix + ".subResultSet");
            this.loadClasses(classes, 10);
            LOGGER.info("Instrumented JDBC classes in {}ms.", (Object)(System.currentTimeMillis() - start));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean loadCodex() throws IOException {
        String line;
        this.codex = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/codex.properties");
        if (inputStream == null) {
            return false;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        do {
            if ((line = reader.readLine()) == null || (line = line.trim()).startsWith("#") || line.length() == 0) continue;
            String[] split = line.split("=");
            String key = split[0];
            String value = split[1];
            HashSet existing = (HashSet)this.codex.get(key);
            if (existing == null) {
                HashSet<String> array = new HashSet<String>();
                array.add(value);
                this.codex.put(key, array);
                continue;
            }
            existing.add(value);
        } while (line != null);
        return true;
    }

    private void loadClasses(HashSet<String> classes, int classType) throws ClassNotFoundException {
        if (classes == null) {
            return;
        }
        this.transformer.setScanClass(classes, classType);
        for (String clazz : classes) {
            ClassLoaderUtils.loadClass(clazz);
        }
    }
}

