/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariInject;
import com.zaxxer.hikari.javassist.HikariOverride;
import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.IHikariResultSetProxy;
import com.zaxxer.hikari.proxy.IHikariStatementProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariClassTransformer
implements ClassFileTransformer {
    private final Logger LOGGER = LoggerFactory.getLogger(HikariClassTransformer.class);
    public static final int UNDEFINED = 0;
    public static final int CONNECTION = 1;
    public static final int STATEMENT = 2;
    public static final int PREPARED_STATEMENT = 3;
    public static final int CALLABLE_STATEMENT = 4;
    public static final int RESULTSET = 5;
    public static final int CONNECTION_SUBCLASS = 6;
    public static final int STATEMENT_SUBCLASS = 7;
    public static final int PREPARED_STATEMENT_SUBCLASS = 8;
    public static final int CALLABLE_STATEMENT_SUBCLASS = 9;
    public static final int RESULTSET_SUBCLASS = 10;
    private static ClassPool classPool;
    private volatile boolean agentFailed;
    private volatile HashSet<String> scanClasses;
    private int classType;

    public void setScanClass(HashSet<String> scanClasses, int classType) {
        this.scanClasses = new HashSet();
        for (String scanClass : scanClasses) {
            this.scanClasses.add(scanClass.replace('.', '/'));
        }
        this.classType = classType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (this.classType == 0 || !this.scanClasses.contains(className)) {
            return classfileBuffer;
        }
        if (classPool == null) {
            classPool = new ClassPool();
            classPool.appendClassPath((ClassPath)new LoaderClassPath(loader));
            classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classPool.getClassLoader());
            ClassFile classFile = new ClassFile(new DataInputStream(new ByteArrayInputStream(classfileBuffer)));
            this.LOGGER.info("Instrumenting class {}", (Object)className);
            switch (this.classType) {
                case 1: {
                    byte[] byArray = this.transformBaseConnection(classFile);
                    return byArray;
                }
                case 6: {
                    byte[] byArray = this.transformConnectionSubclass(classFile);
                    return byArray;
                }
                case 2: {
                    byte[] byArray = this.transformBaseClass(classFile, StatementProxy.class, IHikariStatementProxy.class);
                    return byArray;
                }
                case 7: {
                    byte[] byArray = this.transformClass(classFile, StatementProxy.class);
                    return byArray;
                }
                case 3: {
                    byte[] byArray = this.transformBaseClass(classFile, PreparedStatementProxy.class, IHikariStatementProxy.class);
                    return byArray;
                }
                case 8: {
                    byte[] byArray = this.transformClass(classFile, PreparedStatementProxy.class);
                    return byArray;
                }
                case 4: {
                    byte[] byArray = this.transformBaseClass(classFile, CallableStatementProxy.class, IHikariStatementProxy.class);
                    return byArray;
                }
                case 9: {
                    byte[] byArray = this.transformClass(classFile, CallableStatementProxy.class);
                    return byArray;
                }
                case 5: {
                    byte[] byArray = this.transformBaseClass(classFile, ResultSetProxy.class, IHikariResultSetProxy.class);
                    return byArray;
                }
                case 10: {
                    byte[] byArray = this.transformClass(classFile, ResultSetProxy.class);
                    return byArray;
                }
            }
            byte[] byArray = classfileBuffer;
            return byArray;
        }
        catch (Exception e) {
            this.agentFailed = true;
            this.LOGGER.error("Error transforming class {}", (Object)className, (Object)e);
            byte[] byArray = classfileBuffer;
            return byArray;
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            this.LOGGER.debug("--------------------------------------------------------------------------");
        }
    }

    public boolean isAgentFailed() {
        return this.agentFailed;
    }

    private byte[] transformBaseConnection(ClassFile classFile) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass intf = classPool.get(IHikariConnectionProxy.class.getName());
        target.addInterface(intf);
        this.LOGGER.debug("Added interface {} to {}", (Object)intf.getName(), (Object)className);
        CtClass proxy = classPool.get(ConnectionProxy.class.getName());
        this.copyFields(proxy, target);
        this.copyMethods(proxy, target, classFile);
        for (CtConstructor constructor : target.getDeclaredConstructors()) {
            constructor.insertBeforeBody("__init();");
        }
        this.mergeClassInitializers(proxy, target, classFile);
        return this.transformConnectionSubclass(classFile);
    }

    private byte[] transformConnectionSubclass(ClassFile classFile) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass proxy = classPool.get(ConnectionProxy.class.getName());
        this.overrideMethods(proxy, target, classFile);
        this.injectTryCatch(target);
        this.specialConnectionInjectCloseCheck(target);
        for (CtConstructor constructor : target.getDeclaredConstructors()) {
            constructor.insertBeforeBody("__init();");
        }
        return target.toBytecode();
    }

    private byte[] transformBaseClass(ClassFile classFile, Class<?> proxyClass, Class<?> interfase) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass intf = classPool.get(interfase.getName());
        target.addInterface(intf);
        this.LOGGER.debug("Added interface {} to {}", (Object)intf.getName(), (Object)className);
        CtClass proxy = classPool.get(proxyClass.getName());
        this.copyFields(proxy, target);
        this.copyMethods(proxy, target, classFile);
        this.mergeClassInitializers(proxy, target, classFile);
        return this.transformClass(classFile, proxyClass);
    }

    private byte[] transformClass(ClassFile classFile, Class<?> proxyClass) throws Exception {
        String className = classFile.getName();
        CtClass target = classPool.getCtClass(className);
        CtClass proxy = classPool.get(proxyClass.getName());
        this.overrideMethods(proxy, target, classFile);
        this.injectTryCatch(target);
        return target.toBytecode();
    }

    private void copyFields(CtClass srcClass, CtClass targetClass) throws Exception {
        HashSet<CtField> srcFields = new HashSet<CtField>();
        srcFields.addAll(Arrays.asList(srcClass.getDeclaredFields()));
        srcFields.addAll(Arrays.asList(srcClass.getFields()));
        for (CtField field : srcFields) {
            if (field.getAnnotation(HikariInject.class) == null) continue;
            CtField copy = new CtField(field.getType(), field.getName(), targetClass);
            copy.setModifiers(field.getModifiers());
            targetClass.addField(copy);
            this.LOGGER.debug("Copied field {}.{} to {}", new Object[]{field.getDeclaringClass().getSimpleName(), field.getName(), targetClass.getSimpleName()});
        }
    }

    private void copyMethods(CtClass srcClass, CtClass targetClass, ClassFile targetClassFile) throws Exception {
        ConstPool constPool = targetClassFile.getConstPool();
        for (CtMethod method : srcClass.getMethods()) {
            if (method.getAnnotation(HikariInject.class) == null) continue;
            CtMethod copy = CtNewMethod.copy((CtMethod)method, (CtClass)targetClass, null);
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            Annotation annotation = new Annotation(HikariInject.class.getName(), constPool);
            attr.setAnnotation(annotation);
            copy.getMethodInfo().addAttribute((AttributeInfo)attr);
            targetClass.addMethod(copy);
            this.LOGGER.debug("Copied method {}.{} to {}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), targetClass.getSimpleName()});
        }
    }

    private void overrideMethods(CtClass srcClass, CtClass targetClass, ClassFile targetClassFile) throws Exception {
        ConstPool constPool = targetClassFile.getConstPool();
        AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        Annotation annotation = new Annotation(HikariOverride.class.getName(), constPool);
        attr.setAnnotation(annotation);
        for (CtMethod method : srcClass.getMethods()) {
            if (method.getAnnotation(HikariOverride.class) == null || (targetClass.getModifiers() & 0x400) == 1024) continue;
            try {
                CtMethod destMethod = targetClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
                this.LOGGER.debug("Rename method {}{} to __{}", new Object[]{destMethod.getName(), destMethod.getSignature(), destMethod.getName()});
                destMethod.setName("__" + destMethod.getName());
                destMethod.getMethodInfo().addAttribute((AttributeInfo)attr);
                CtMethod copy = CtNewMethod.copy((CtMethod)method, (CtClass)targetClass, null);
                copy.getMethodInfo().addAttribute((AttributeInfo)attr);
                targetClass.addMethod(copy);
                this.LOGGER.debug("Override method {}.{} in {}", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), targetClass.getSimpleName()});
            }
            catch (NotFoundException nfe) {
                // empty catch block
            }
        }
    }

    private void mergeClassInitializers(CtClass srcClass, CtClass targetClass, ClassFile targetClassFile) throws Exception {
        CtConstructor srcInitializer = srcClass.getClassInitializer();
        if (srcInitializer == null) {
            return;
        }
        CtConstructor destInitializer = targetClass.getClassInitializer();
        if (destInitializer == null && srcInitializer != null) {
            CtConstructor copy = CtNewConstructor.copy((CtConstructor)srcInitializer, (CtClass)targetClass, null);
            targetClass.addConstructor(copy);
            CtMethod __static = CtNewMethod.make((int)8, (CtClass)CtClass.voidType, (String)"__static", null, null, (String)"{}", (CtClass)targetClass);
            targetClass.addMethod(__static);
            this.LOGGER.debug("Copied static initializer of {} to {}", (Object)srcClass.getSimpleName(), (Object)targetClass.getSimpleName());
        } else {
            CtMethod method = destInitializer.toMethod("__static", targetClass);
            targetClass.addMethod(method);
            targetClass.removeConstructor(destInitializer);
            this.LOGGER.debug("Move static initializer of {}", (Object)targetClass.getSimpleName());
            CtConstructor copy = CtNewConstructor.copy((CtConstructor)srcInitializer, (CtClass)targetClass, null);
            targetClass.addConstructor(copy);
            this.LOGGER.debug("Copied static initializer of {} to {}", (Object)srcClass.getSimpleName(), (Object)targetClass.getSimpleName());
        }
    }

    private void injectTryCatch(CtClass targetClass) throws Exception {
        block0: for (CtMethod method : targetClass.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) != 1 || (method.getModifiers() & 8) == 8 || method.getAnnotation(HikariInject.class) != null || method.getAnnotation(HikariOverride.class) != null || method.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass exception : method.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(exception.getName())) continue;
                this.LOGGER.debug("Injecting try..catch into {}{}", (Object)method.getName(), (Object)method.getSignature());
                method.addCatch("throw _checkException($e);", exception);
                continue block0;
            }
        }
    }

    private void specialConnectionInjectCloseCheck(CtClass targetClass) throws Exception {
        block0: for (CtMethod method : targetClass.getDeclaredMethods()) {
            if ((method.getModifiers() & 1) != 1 || (method.getModifiers() & 8) == 8 || method.getAnnotation(HikariInject.class) != null || method.getAnnotation(HikariOverride.class) != null || method.getMethodInfo().getCodeAttribute() == null) continue;
            for (CtClass exception : method.getExceptionTypes()) {
                if (!"java.sql.SQLException".equals(exception.getName())) continue;
                method.insertBefore("if (_isClosed) { throw new java.sql.SQLException(\"Connection is closed\"); }");
                continue block0;
            }
        }
    }
}

