/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import com.zaxxer.hikari.proxy.CallableStatementProxy;
import com.zaxxer.hikari.proxy.ConnectionProxy;
import com.zaxxer.hikari.proxy.PreparedStatementProxy;
import com.zaxxer.hikari.proxy.ProxyFactory;
import com.zaxxer.hikari.proxy.ResultSetProxy;
import com.zaxxer.hikari.proxy.StatementProxy;
import com.zaxxer.hikari.util.ClassLoaderUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;

public final class JavassistProxyFactoryFactory {
    private static final ProxyFactory proxyFactory;
    private ClassPool classPool = new ClassPool();

    private JavassistProxyFactoryFactory() {
        this.classPool.importPackage("java.sql");
        this.classPool.appendClassPath((ClassPath)new LoaderClassPath(this.getClass().getClassLoader()));
        try {
            String methodBody = "{ _checkClosed(); try { return ((cast) delegate).method($$); } catch (SQLException e) { throw _checkException(e); } }";
            this.generateProxyClass(Connection.class, ConnectionProxy.class, methodBody);
            methodBody = "{ try { return ((cast) delegate).method($$); } catch (SQLException e) { throw _checkException(e); } }";
            this.generateProxyClass(Statement.class, StatementProxy.class, methodBody);
            this.generateProxyClass(CallableStatement.class, CallableStatementProxy.class, methodBody);
            this.generateProxyClass(PreparedStatement.class, PreparedStatementProxy.class, methodBody);
            this.generateProxyClass(ResultSet.class, ResultSetProxy.class, methodBody);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ProxyFactory getProxyFactory() {
        return proxyFactory;
    }

    private ProxyFactory generateProxyFactory() throws Exception {
        String packageName = ProxyFactory.class.getPackage().getName();
        CtClass targetCt = this.classPool.makeClass(packageName + ".JavassistProxyFactory");
        CtClass superCt = this.classPool.getCtClass(ProxyFactory.class.getName());
        targetCt.setSuperclass(superCt);
        targetCt.setModifiers(16);
        for (CtMethod intfMethod : superCt.getDeclaredMethods()) {
            CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, null);
            StringBuilder call = new StringBuilder("{");
            if ("getProxyConnection".equals(method.getName())) {
                call.append("return new ").append(packageName).append(".ConnectionJavassistProxy($$);");
            }
            if ("getProxyStatement".equals(method.getName())) {
                call.append("return $2 != null ? new ").append(packageName).append(".StatementJavassistProxy($$) : null;");
            }
            if ("getProxyPreparedStatement".equals(method.getName())) {
                call.append("return $2 != null ? new ").append(packageName).append(".PreparedStatementJavassistProxy($$) : null;");
            }
            if ("getProxyResultSet".equals(method.getName())) {
                call.append("return $2 != null ? new ").append(packageName).append(".ResultSetJavassistProxy($$) : null;");
            }
            if ("getProxyCallableStatement".equals(method.getName())) {
                call.append("return $2 != null ? new ").append(packageName).append(".CallableStatementJavassistProxy($$) : null;");
            }
            call.append('}');
            method.setBody(call.toString());
            targetCt.addMethod(method);
        }
        Class clazz = targetCt.toClass(this.classPool.getClassLoader(), null);
        return (ProxyFactory)clazz.newInstance();
    }

    private <T> Class<T> generateProxyClass(Class<T> primaryInterface, Class<?> superClass, String methodBody) throws Exception {
        String superClassName = superClass.getName();
        CtClass superClassCt = this.classPool.getCtClass(superClassName);
        CtClass targetCt = this.classPool.makeClass(superClassName.replace("Proxy", "JavassistProxy"), superClassCt);
        targetCt.setModifiers(16);
        HashSet<String> superSigs = new HashSet<String>();
        for (CtMethod method : superClassCt.getMethods()) {
            if ((method.getModifiers() & 0x400) == 1024) continue;
            superSigs.add(method.getName() + method.getSignature());
        }
        methodBody = methodBody.replace("cast", primaryInterface.getName());
        HashSet<String> methods = new HashSet<String>();
        Set<Class<?>> interfaces = ClassLoaderUtils.getAllInterfaces(primaryInterface);
        for (Class<?> intf : interfaces) {
            CtClass intfCt = this.classPool.getCtClass(intf.getName());
            targetCt.addInterface(intfCt);
            for (CtMethod intfMethod : intfCt.getDeclaredMethods()) {
                if (superSigs.contains(intfMethod.getName() + intfMethod.getSignature()) || methods.contains(intfMethod.getName() + intfMethod.getSignature())) continue;
                CtMethod method = CtNewMethod.copy((CtMethod)intfMethod, (CtClass)targetCt, null);
                methods.add(intfMethod.getName() + intfMethod.getSignature());
                String modifiedBody = methodBody.replace("method", method.getName());
                if (method.getReturnType() == CtClass.voidType) {
                    modifiedBody = modifiedBody.replace("return", "");
                }
                method.setBody(modifiedBody);
                targetCt.addMethod(method);
            }
        }
        return targetCt.toClass(this.classPool.getClassLoader(), null);
    }

    static {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(JavassistProxyFactoryFactory.class.getClassLoader());
            JavassistProxyFactoryFactory proxyFactoryFactory = new JavassistProxyFactoryFactory();
            proxyFactory = proxyFactoryFactory.generateProxyFactory();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

