/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfigMBean;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariConfig
implements HikariConfigMBean {
    private static final long CONNECTION_TIMEOUT = 5000L;
    private static final long ACQUIRE_RETRY_DELAY = 750L;
    private static final long IDLE_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private static final long MAX_LIFETIME = TimeUnit.MINUTES.toMillis(30L);
    private static int poolNumber;
    private volatile int acquireIncrement = 5;
    private volatile int acquireRetries = 3;
    private volatile long acquireRetryDelay = 750L;
    private volatile long connectionTimeout = 5000L;
    private volatile long idleTimeout;
    private volatile long leakDetectionThreshold;
    private volatile long maxLifetime;
    private volatile int minPoolSize = 10;
    private volatile int maxPoolSize = 60;
    private String poolName;
    private String connectionTestQuery;
    private String dataSourceClassName;
    private String shadedCodexMapping;
    private boolean isJdbc4connectionTest = true;
    private boolean isAutoCommit = true;
    private boolean isUseInstrumentation = true;
    private Properties driverProperties = new Properties();

    public HikariConfig() {
        this.idleTimeout = IDLE_TIMEOUT;
        this.maxLifetime = MAX_LIFETIME;
        this.poolName = "HikariPool-" + poolNumber++;
    }

    public HikariConfig(String propertyFileName) {
        this();
        File propFile = new File(propertyFileName);
        if (!propFile.isFile()) {
            throw new IllegalArgumentException("Property file " + propertyFileName + " was not found.");
        }
        try {
            FileInputStream fis = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(fis);
            PropertyBeanSetter.setTargetFromProperties(this, props);
        }
        catch (IOException io) {
            throw new RuntimeException("Error loading properties file", io);
        }
    }

    public void addDataSourceProperty(String propertyName, Object value) {
        this.driverProperties.put(propertyName, value);
    }

    public Properties getDataSourceProperties() {
        return this.driverProperties;
    }

    @Override
    public int getAcquireIncrement() {
        return this.acquireIncrement;
    }

    @Override
    public void setAcquireIncrement(int acquireIncrement) {
        if (acquireIncrement < 1) {
            throw new IllegalArgumentException("acquireRetries cannot be less than 1");
        }
        this.acquireIncrement = acquireIncrement;
    }

    @Override
    public int getAcquireRetries() {
        return this.acquireRetries;
    }

    @Override
    public void setAcquireRetries(int acquireRetries) {
        if (acquireRetries < 0) {
            throw new IllegalArgumentException("acquireRetries cannot be negative");
        }
        this.acquireRetries = acquireRetries;
    }

    @Override
    public long getAcquireRetryDelay() {
        return this.acquireRetryDelay;
    }

    @Override
    public void setAcquireRetryDelay(long acquireRetryDelayMs) {
        if (acquireRetryDelayMs < 0L) {
            throw new IllegalArgumentException("acquireRetryDelay cannot be negative");
        }
        this.acquireRetryDelay = acquireRetryDelayMs;
    }

    public String getConnectionTestQuery() {
        return this.connectionTestQuery;
    }

    public void setConnectionTestQuery(String connectionTestQuery) {
        this.connectionTestQuery = connectionTestQuery;
    }

    @Override
    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public void setConnectionTimeout(long connectionTimeoutMs) {
        if (connectionTimeoutMs < 0L) {
            throw new IllegalArgumentException("connectionTimeout cannot be negative");
        }
        if (connectionTimeoutMs == 0L) {
            this.connectionTimeout = Integer.MAX_VALUE;
        }
        this.connectionTimeout = connectionTimeoutMs;
    }

    public String getDataSourceClassName() {
        return this.dataSourceClassName;
    }

    public void setDataSourceClassName(String className) {
        this.dataSourceClassName = className;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeoutMs) {
        this.idleTimeout = idleTimeoutMs;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    public void setAutoCommit(boolean isAutoCommit) {
        this.isAutoCommit = isAutoCommit;
    }

    public boolean isJdbc4ConnectionTest() {
        return this.isJdbc4connectionTest;
    }

    public void setJdbc4ConnectionTest(boolean useIsValid) {
        this.isJdbc4connectionTest = useIsValid;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.leakDetectionThreshold;
    }

    @Override
    public void setLeakDetectionThreshold(long leakDetectionThresholdMs) {
        this.leakDetectionThreshold = leakDetectionThresholdMs;
    }

    public boolean isUseInstrumentation() {
        return this.isUseInstrumentation;
    }

    public void setUseInstrumentation(boolean useInstrumentation) {
        this.isUseInstrumentation = useInstrumentation;
    }

    @Override
    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public void setMaxLifetime(long maxLifetimeMs) {
        this.maxLifetime = maxLifetimeMs;
    }

    @Override
    public int getMinimumPoolSize() {
        return this.minPoolSize;
    }

    @Override
    public void setMinimumPoolSize(int minPoolSize) {
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("minPoolSize cannot be negative");
        }
        this.minPoolSize = minPoolSize;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.maxPoolSize;
    }

    @Override
    public void setMaximumPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("maxPoolSize cannot be negative");
        }
        this.maxPoolSize = maxPoolSize;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public String getShadedCodexMapping() {
        return this.shadedCodexMapping;
    }

    public void setShadedCodexMapping(String mapping) {
        this.shadedCodexMapping = mapping;
    }

    public void validate() {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        if (this.acquireRetryDelay < 0L) {
            logger.error("acquireRetryDelay cannot be negative.");
            throw new IllegalStateException("acquireRetryDelay cannot be negative.");
        }
        if (this.acquireRetryDelay < 100L) {
            logger.warn("acquireRetryDelay is less than 100ms, did you specify the wrong time unit?  Using default instead.");
            this.acquireRetryDelay = 750L;
        }
        if (this.connectionTimeout == Integer.MAX_VALUE) {
            logger.warn("No connection wait timeout is set, this might cause an infinite wait.");
        } else if (this.connectionTimeout < 100L) {
            logger.warn("connectionTimeout is less than 100ms, did you specify the wrong time unit?  Using default instead.");
            this.connectionTimeout = 5000L;
        }
        if (this.idleTimeout < 0L) {
            logger.error("idleTimeout cannot be negative.");
            throw new IllegalStateException("idleTimeout cannot be negative.");
        }
        if (this.idleTimeout < 30000L) {
            logger.warn("idleTimeout is less than 30000ms, did you specify the wrong time unit?  Using default instead.");
            this.idleTimeout = IDLE_TIMEOUT;
        }
        if (!this.isJdbc4connectionTest && this.connectionTestQuery == null) {
            logger.error("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified.");
            throw new IllegalStateException("Either jdbc4ConnectionTest must be enabled or a connectionTestQuery must be specified.");
        }
        if (this.leakDetectionThreshold != 0L && this.leakDetectionThreshold < 10000L) {
            logger.warn("leakDetectionThreshold is less than 10000ms, did you specify the wrong time unit?  Disabling leak detection.");
            this.leakDetectionThreshold = 0L;
        }
        if (this.minPoolSize < 0) {
            logger.error("minPoolSize cannot be negative.");
            throw new IllegalStateException("minPoolSize cannot be negative.");
        }
        if (this.maxPoolSize < this.minPoolSize) {
            logger.warn("maxPoolSize is less than minPoolSize, forcing them equal.");
            this.maxPoolSize = this.minPoolSize;
        }
        if (this.maxLifetime < 0L) {
            logger.error("maxLifetime cannot be negative.");
            throw new IllegalStateException("maxLifetime cannot be negative.");
        }
        if (this.maxLifetime < 120000L) {
            logger.warn("maxLifetime is less than 120000ms, did you specify the wrong time unit?  Using default instead.");
            this.maxLifetime = MAX_LIFETIME;
        }
    }
}

