/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.zaxxer.hikari.javassist.HikariClassScanner;
import com.zaxxer.hikari.javassist.HikariClassTransformer;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentRegistrationElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassScanner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadTransformerAgent(String dsClassName, String shadedCodexMapping) {
        String agentJarPath = AgentRegistrationElf.getAgentJarPath();
        if (agentJarPath == null) {
            LOGGER.warn("Cannot find the HikariCP-agent jar file through introspection.");
            return false;
        }
        try {
            Properties systemProperties = System.getProperties();
            HikariClassTransformer transformer = new HikariClassTransformer();
            systemProperties.put("com.zaxxer.hikari.transformer", transformer);
            AgentRegistrationElf.registerInstrumentation(agentJarPath);
            LOGGER.info("Successfully loaded instrumentation agent.  Scanning classes...");
            HikariClassScanner scanner = new HikariClassScanner(transformer, shadedCodexMapping);
            boolean bl = scanner.scanClasses(dsClassName);
            return bl;
        }
        catch (Exception e) {
            LOGGER.warn("Instrumentation agent could not be loaded.  Please report at http://github.com/brettwooldridge/HikariCP.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (AgentRegistrationElf.unregisterInstrumenation()) {
                LOGGER.info("Unloaded instrumentation agent.");
            }
        }
    }

    private static String getAgentJarPath() {
        URL resource = AgentRegistrationElf.class.getResource("/com/zaxxer/hikari/javassist/HikariInstrumentationAgent.class");
        if (resource == null) {
            return null;
        }
        String jarPath = resource.toString();
        jarPath = jarPath.replace("file:", "");
        if ((jarPath = jarPath.replace("jar:", "")).indexOf(33) <= 0) {
            return System.getProperty("com.zaxxer.hikari.agentJar");
        }
        jarPath = jarPath.substring(0, jarPath.indexOf(33));
        return jarPath;
    }

    private static void registerInstrumentation(String jarPath) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine vm = VirtualMachine.attach(AgentRegistrationElf.getPid());
        vm.loadAgent(jarPath);
        vm.detach();
    }

    private static boolean unregisterInstrumenation() {
        boolean unregistered = false;
        Properties systemProperties = System.getProperties();
        Instrumentation instrumentation = (Instrumentation)systemProperties.get("com.zaxxer.hikari.instrumentation");
        if (instrumentation != null) {
            ClassFileTransformer transformer = (ClassFileTransformer)systemProperties.get("com.zaxxer.hikari.transformer");
            instrumentation.removeTransformer(transformer);
            unregistered = true;
        }
        systemProperties.remove("com.zaxxer.hikari.instrumentation");
        systemProperties.remove("com.zaxxer.hikari.transformer");
        return unregistered;
    }

    private static String getPid() {
        String nameOfRunningVM = ManagementFactory.getRuntimeMXBean().getName();
        int p = nameOfRunningVM.indexOf(64);
        return nameOfRunningVM.substring(0, p);
    }
}

