/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPoolMBean;
import com.zaxxer.hikari.javassist.AgentRegistrationElf;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariPool
implements HikariPoolMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariPool.class);
    private final HikariConfig configuration;
    private final LinkedTransferQueue<IHikariConnectionProxy> idleConnections;
    private final AtomicInteger totalConnections;
    private final AtomicInteger idleConnectionCount;
    private final DataSource dataSource;
    private final long leakDetectionThreshold;
    private final boolean jdbc4ConnectionTest;
    private final boolean delegationProxies;
    private final Timer houseKeepingTimer;

    HikariPool(HikariConfig configuration) {
        configuration.validate();
        this.configuration = configuration;
        this.totalConnections = new AtomicInteger();
        this.idleConnectionCount = new AtomicInteger();
        this.idleConnections = new LinkedTransferQueue();
        this.jdbc4ConnectionTest = configuration.isJdbc4ConnectionTest();
        this.leakDetectionThreshold = configuration.getLeakDetectionThreshold();
        String dsClassName = configuration.getDataSourceClassName();
        try {
            String shadedCodexMapping = configuration.getShadedCodexMapping();
            boolean bl = this.delegationProxies = !configuration.isUseInstrumentation() || !AgentRegistrationElf.loadTransformerAgent(dsClassName, shadedCodexMapping);
            if (this.delegationProxies) {
                LOGGER.info("Using Javassist delegate-based proxies.");
            }
            Class<?> clazz = this.getClass().getClassLoader().loadClass(dsClassName);
            this.dataSource = (DataSource)clazz.newInstance();
            PropertyBeanSetter.setTargetFromProperties(this.dataSource, configuration.getDataSourceProperties());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create datasource class: " + dsClassName, e);
        }
        this.registerMBean();
        this.houseKeepingTimer = new Timer("Hikari Housekeeping Timer", true);
        long idleTimeout = configuration.getIdleTimeout();
        if (idleTimeout > 0L || configuration.getMaxLifetime() > 0L) {
            this.houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeeper(), TimeUnit.SECONDS.toMillis(30L), TimeUnit.SECONDS.toMillis(30L));
        }
        this.fillPool();
    }

    /*
     * Exception decompiling
     */
    Connection getConnection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseConnection(IHikariConnectionProxy connectionProxy) {
        if (!connectionProxy._isBrokenConnection()) {
            connectionProxy._markLastAccess();
            this.idleConnectionCount.incrementAndGet();
            this.idleConnections.put(connectionProxy);
        } else {
            this.closeConnection(connectionProxy);
        }
    }

    @Override
    public int getActiveConnections() {
        return Math.min(this.configuration.getMaximumPoolSize(), this.totalConnections.get() - this.idleConnectionCount.get());
    }

    @Override
    public int getIdleConnections() {
        return this.idleConnectionCount.get();
    }

    @Override
    public int getTotalConnections() {
        return this.totalConnections.get();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.idleConnections.getWaitingConsumerCount();
    }

    @Override
    public void closeIdleConnections() {
        IHikariConnectionProxy connectionProxy;
        int idleCount = this.idleConnectionCount.get();
        for (int i = 0; i < idleCount && (connectionProxy = this.idleConnections.poll()) != null; ++i) {
            this.idleConnectionCount.decrementAndGet();
            this.closeConnection(connectionProxy);
        }
    }

    private void fillPool() {
        int maxIters = this.configuration.getMinimumPoolSize() * this.configuration.getAcquireRetries();
        while (this.totalConnections.get() < this.configuration.getMinimumPoolSize() && maxIters-- > 0) {
            this.addConnection();
        }
    }

    private synchronized void addConnections(AddConnectionStrategy strategy) {
        switch (strategy) {
            case ONLY_IF_EMPTY: {
                if (this.idleConnectionCount.get() != 0) break;
                int max = this.configuration.getMaximumPoolSize();
                int increment = this.configuration.getAcquireIncrement();
                for (int i = 0; this.idleConnectionCount.get() < increment && i < increment && this.totalConnections.get() < max; ++i) {
                    this.addConnection();
                }
                break;
            }
            case MAINTAIN_MINIMUM: {
                int min = this.configuration.getMinimumPoolSize();
                int max = this.configuration.getMaximumPoolSize();
                int increment = this.configuration.getAcquireIncrement();
                for (int i = 0; this.totalConnections.get() < min && i < increment && this.totalConnections.get() < max; ++i) {
                    this.addConnection();
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addConnection() {
        int retries = 0;
        while (true) {
            try {
                Connection connection = this.dataSource.getConnection();
                IHikariConnectionProxy proxyConnection = this.delegationProxies ? (IHikariConnectionProxy)((Object)JavassistProxyFactoryFactory.getProxyFactory().getProxyConnection(connection)) : (IHikariConnectionProxy)((Object)connection);
                proxyConnection._setParentPool(this);
                boolean alive = this.isConnectionAlive((Connection)((Object)proxyConnection), this.configuration.getConnectionTimeout());
                if (!alive) {
                    throw new RuntimeException("Connection not alive, retry.");
                }
                String initSql = this.configuration.getConnectionInitSql();
                if (initSql != null && initSql.length() > 0) {
                    try (Statement statement = connection.createStatement();){
                        statement.executeQuery(initSql);
                    }
                }
                this.idleConnectionCount.incrementAndGet();
                this.totalConnections.incrementAndGet();
                this.idleConnections.add(proxyConnection);
                return;
            }
            catch (Exception e) {
                if (retries++ > this.configuration.getAcquireRetries()) {
                    LOGGER.error("Maximum connection creation retries exceeded", (Throwable)e);
                    return;
                }
                try {
                    Thread.sleep(this.configuration.getAcquireRetryDelay());
                }
                catch (InterruptedException e1) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive(Connection connection, long timeoutMs) {
        if (timeoutMs < 1000L) {
            timeoutMs = 1000L;
        }
        try {
            if (this.jdbc4ConnectionTest) {
                return connection.isValid((int)timeoutMs / 1000);
            }
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.configuration.getConnectionTestQuery());
            }
            return true;
        }
        catch (SQLException e) {
            LOGGER.error("Exception during keep alive check.  Connection must be dead.");
            return false;
        }
    }

    private void closeConnection(IHikariConnectionProxy connectionProxy) {
        try {
            this.totalConnections.decrementAndGet();
            connectionProxy.__close();
        }
        catch (SQLException e) {
            return;
        }
    }

    private void registerMBean() {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + this.configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + this.configuration.getPoolName() + ")");
            if (!mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.registerMBean(this.configuration, poolConfigName);
                mBeanServer.registerMBean(this, poolName);
            } else {
                LOGGER.error("You cannot use the same HikariConfig for separate pool instances.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register management beans.", (Throwable)e);
        }
    }

    private static enum AddConnectionStrategy {
        ONLY_IF_EMPTY,
        MAINTAIN_MINIMUM;

    }

    private class HouseKeeper
    extends TimerTask {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            IHikariConnectionProxy connectionProxy;
            HikariPool.this.houseKeepingTimer.purge();
            long now = System.currentTimeMillis();
            long idleTimeout = HikariPool.this.configuration.getIdleTimeout();
            long maxLifetime = HikariPool.this.configuration.getMaxLifetime();
            int idleCount = HikariPool.this.idleConnectionCount.get();
            for (int i = 0; i < idleCount && (connectionProxy = (IHikariConnectionProxy)HikariPool.this.idleConnections.poll()) != null; ++i) {
                HikariPool.this.idleConnectionCount.decrementAndGet();
                if (idleTimeout > 0L && now > connectionProxy._getLastAccess() + idleTimeout || maxLifetime > 0L && now > connectionProxy._getCreationTime() + maxLifetime) {
                    HikariPool.this.closeConnection(connectionProxy);
                    continue;
                }
                HikariPool.this.idleConnectionCount.incrementAndGet();
                HikariPool.this.idleConnections.add(connectionProxy);
            }
            HikariPool.this.addConnections(AddConnectionStrategy.MAINTAIN_MINIMUM);
        }
    }
}

