/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPool;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariMBeanElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariMBeanElf.class);

    private HikariMBeanElf() {
    }

    public static void registerMBeans(HikariConfig configuration, HikariPool pool) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName poolConfigName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + configuration.getPoolName() + ")");
            ObjectName poolName = new ObjectName("com.zaxxer.hikari:type=Pool (" + configuration.getPoolName() + ")");
            if (!mBeanServer.isRegistered(poolConfigName)) {
                mBeanServer.registerMBean(configuration, poolConfigName);
                mBeanServer.registerMBean(pool, poolName);
            } else {
                LOGGER.error("You cannot use the same HikariConfig for separate pool instances.");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Unable to register management beans.", (Throwable)e);
        }
    }
}

