/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.sun.tools.attach.AgentInitializationException;
import com.sun.tools.attach.AgentLoadException;
import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import com.zaxxer.hikari.javassist.HikariClassScanner;
import com.zaxxer.hikari.javassist.HikariClassTransformer;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentRegistrationElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassScanner.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadTransformerAgent(String string, String string2) {
        String string3 = AgentRegistrationElf.getAgentJarPath();
        if (string3 == null) {
            LOGGER.info("Cannot find the HikariCP-agent jar file through introspection.");
            return false;
        }
        try {
            Properties properties = System.getProperties();
            HikariClassTransformer hikariClassTransformer = new HikariClassTransformer();
            properties.put("com.zaxxer.hikari.transformer", hikariClassTransformer);
            LOGGER.info("Using HikariCP agent jar found at: {}", (Object)string3);
            AgentRegistrationElf.registerInstrumentation(string3);
            LOGGER.info("Successfully loaded instrumentation agent.  Scanning classes...");
            HikariClassScanner hikariClassScanner = new HikariClassScanner(hikariClassTransformer, string2);
            boolean bl = hikariClassScanner.scanClasses(string);
            return bl;
        }
        catch (Exception exception) {
            LOGGER.warn("Instrumentation agent could not be loaded.  Please report at http://github.com/brettwooldridge/HikariCP.", (Throwable)exception);
            boolean bl = false;
            return bl;
        }
        finally {
            if (AgentRegistrationElf.unregisterInstrumenation()) {
                LOGGER.info("Unloaded instrumentation agent.");
            }
        }
    }

    private static String getAgentJarPath() {
        URL uRL = AgentRegistrationElf.class.getResource("/com/zaxxer/hikari/javassist/HikariInstrumentationAgent.class");
        if (uRL == null) {
            return null;
        }
        String string = uRL.toString();
        string = string.replace("file:", "");
        if ((string = string.replace("jar:", "")).indexOf(33) <= 0) {
            return System.getProperty("com.zaxxer.hikari.agentJar");
        }
        string = string.substring(0, string.indexOf(33));
        return string;
    }

    private static void registerInstrumentation(String string) throws AttachNotSupportedException, IOException, AgentLoadException, AgentInitializationException {
        VirtualMachine virtualMachine = VirtualMachine.attach(AgentRegistrationElf.getPid());
        virtualMachine.loadAgent(string);
        virtualMachine.detach();
    }

    private static boolean unregisterInstrumenation() {
        boolean bl = false;
        Properties properties = System.getProperties();
        Instrumentation instrumentation = (Instrumentation)properties.get("com.zaxxer.hikari.instrumentation");
        if (instrumentation != null) {
            ClassFileTransformer classFileTransformer = (ClassFileTransformer)properties.get("com.zaxxer.hikari.transformer");
            instrumentation.removeTransformer(classFileTransformer);
            bl = true;
        }
        properties.remove("com.zaxxer.hikari.instrumentation");
        properties.remove("com.zaxxer.hikari.transformer");
        return bl;
    }

    private static String getPid() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        int n = string.indexOf(64);
        return string.substring(0, n);
    }
}

